@props(['items' => []])
<nav class="text-sm text-slate-600 dark:text-slate-300" aria-label="Breadcrumb">
  <ol class="flex items-center gap-2 flex-wrap">
    <li>
      <a href="{{ route('admin.dashboard') }}" class="inline-flex items-center gap-1 hover:underline"><i data-lucide="home" class="w-4 h-4"></i><span>Admin</span></a>
    </li>
    @foreach($items as $i => $item)
      <li class="text-slate-400">/
      </li>
      <li>
        @if(!empty($item['url']))
          <a href="{{ $item['url'] }}" class="hover:underline">{{ $item['label'] }}</a>
        @else
          <span aria-current="page">{{ $item['label'] }}</span>
        @endif
      </li>
    @endforeach
  </ol>
  </nav>
