<div class="h-16 flex items-center justify-between px-4 sm:px-6 lg:px-8 backdrop-blur supports-[backdrop-filter]:bg-white/60 dark:supports-[backdrop-filter]:bg-slate-900/60 bg-white/70 dark:bg-slate-900/70 border-b border-white/30 dark:border-slate-700/50">
  <div class="flex items-center gap-2">
    {{ $slot }}
  </div>
  <div class="flex items-center gap-3">
    @php(
      $roleLabel = collect(auth()->user()?->getRoleNames() ?? [])
        ->map(fn($role) => $role === 'Super Admin' ? 'Admin' : $role)
        ->first() ?? 'User'
    )
  <x-dropdown align="right" width="w-56" :content-classes="'py-1 bg-white dark:bg-slate-800'">
      <x-slot name="trigger">
        <button type="button" class="inline-flex items-center gap-2 pl-2 pr-2 py-1 rounded-full hover:bg-slate-100 dark:hover:bg-slate-800 focus:outline-none focus:ring-2 focus:ring-slate-300 dark:focus:ring-slate-600">
          <span class="inline-flex items-center text-[11px] px-2 py-0.5 rounded-full bg-slate-100 dark:bg-slate-800 text-slate-700 dark:text-slate-200 border border-white/30 dark:border-slate-700/50">{{ $roleLabel }}</span>
          <span class="text-sm text-slate-700 dark:text-slate-200 max-w-[10rem] truncate">{{ auth()->user()->name ?? 'Admin' }}</span>
          <div class="w-8 h-8 rounded-full bg-indigo-200 dark:bg-indigo-800 flex items-center justify-center text-indigo-900 dark:text-indigo-100 font-semibold">
            {{ strtoupper(substr(auth()->user()->name ?? 'A', 0, 1)) }}
          </div>
          <i data-lucide="chevron-down" class="w-4 h-4 text-slate-500 dark:text-slate-400"></i>
        </button>
      </x-slot>

      <x-slot name="content">
        <div class="px-2 py-1">
          <div class="px-2 py-1 text-xs text-slate-500 dark:text-slate-400">Signed in as</div>
          <div class="px-2 pb-2 text-sm font-medium text-slate-800 dark:text-slate-200 truncate">{{ auth()->user()->email ?? '' }}</div>
        </div>
        <x-dropdown-link :href="route('admin.dashboard')">
          {{ __('Dashboard') }}
        </x-dropdown-link>
        <x-dropdown-link :href="route('home')">
          {{ __('View site') }}
        </x-dropdown-link>
        <x-dropdown-link :href="route('profile.edit')">
          {{ __('Profile') }}
        </x-dropdown-link>
        <hr class="my-1 border-white/30 dark:border-slate-700/50" />
        <x-dropdown-link :href="route('logout.get')">
          {{ __('Log Out') }}
        </x-dropdown-link>
      </x-slot>
    </x-dropdown>
  </div>
</div>
