@props(['disabled' => false])

<div class="relative">
    <select 
        @disabled($disabled) 
        {{ $attributes->merge(['class' => 'checkout-field w-full px-4 py-3 text-sm font-medium rounded-lg transition-all duration-200 focus:outline-none appearance-none pr-10']) }}
    >
        {{ $slot }}
    </select>
    <div class="absolute inset-y-0 right-0 flex items-center pr-3 pointer-events-none">
        <svg class="w-5 h-5 text-slate-400 transition-colors duration-200" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M19 9l-7 7-7-7"></path>
        </svg>
    </div>
</div>