@props(['label' => '', 'value' => null, 'icon' => null, 'href' => null])
<div class="surface rounded-xl p-4 flex items-center gap-3">
  <div class="w-10 h-10 rounded-lg bg-primary/10 text-primary flex items-center justify-center shrink-0">
    @if($icon)
      <i data-lucide="{{ $icon }}" class="w-5 h-5"></i>
    @else
      <svg class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor"><circle cx="12" cy="12" r="10"/></svg>
    @endif
  </div>
  <div class="min-w-0">
    <div class="text-xs text-slate-500 dark:text-slate-400">{{ $label }}</div>
    @if($href)
      <a href="{{ $href }}" class="block text-lg font-semibold text-slate-900 dark:text-white hover:underline">{{ $value }}</a>
    @else
      <div class="text-lg font-semibold text-slate-900 dark:text-white">{{ $value }}</div>
    @endif
  </div>
</div>
