@props([
  'points' => 0,
  'tier' => 'Member',
  'nextTier' => 'Silver',
  'progress' => 0, // 0..100
  'ctaHref' => null,
  'ctaText' => null,
])
<section class="surface rounded-xl p-4" data-io-hydrate @io-hydrate.window="$dispatch('loyalty-start')">
  <div class="flex items-center justify-between mb-3">
    <h3 class="font-semibold text-slate-900 dark:text-white">Loyalty</h3>
    <span class="inline-flex items-center text-xs px-2 py-1 rounded-full bg-indigo-500/10 text-indigo-600 dark:text-indigo-300">{{ $tier }}</span>
  </div>
  <div class="flex items-center gap-4" x-data @loyalty-start.window="void 0">
    <div class="w-14 h-14 rounded-full bg-indigo-500/10 text-indigo-600 dark:text-indigo-300 flex items-center justify-center text-lg font-bold">{{ (int) $points }}</div>
    <div class="flex-1">
      <div class="flex items-center justify-between text-xs text-slate-500 dark:text-slate-400 mb-1">
        <span>Progress to {{ $nextTier }}</span>
        <span>{{ (int) $progress }}%</span>
      </div>
      <div class="h-2 rounded-full bg-slate-200 dark:bg-slate-700 overflow-hidden">
        <div class="h-full bg-indigo-500" style="width: {{ max(0,min(100,(int)$progress)) }}%"></div>
      </div>
    </div>
  </div>
  @if($ctaHref && $ctaText)
  <div class="mt-3">
    <a href="{{ $ctaHref }}" class="btn btn-xs btn-outline">{{ $ctaText }}</a>
  </div>
  @endif
</section>
