@php
  $cart = session('cart.items', []);
  $cartCount = 0;
  if (is_array($cart)) {
    foreach ($cart as $it) { $cartCount += is_array($it) && isset($it['qty']) ? (int)$it['qty'] : (is_numeric($it) ? (int)$it : 0); }
  }
@endphp
<nav class="md:hidden fixed bottom-0 inset-x-0 z-40" aria-label="Mobile actions"
    x-data="{ hasActive:false, async init(){
      const url = this.$el.getAttribute('data-kpi-url');
      if(!url) return;
      try{ const res = await fetch(url, {headers:{'Accept':'application/json'}});
          const data = await res.json(); this.hasActive = !!(data && data.active_order); }
      catch(e){ /* ignore */ }
    }}"
    @auth data-kpi-url="{{ route('api.me.kpis') }}" @endauth>
  <div class="mx-4 mb-4 rounded-2xl bg-[var(--charcoal)] text-white shadow-lg ring-1 ring-black/5 px-3 py-2" style="padding-bottom: max(env(safe-area-inset-bottom), .5rem)">
    <ul class="grid grid-cols-4 gap-2">
      <li>
        <a href="{{ route('menu.index') }}" class="flex flex-col items-center justify-center gap-1 rounded-xl px-2 py-2 hover:bg-white/10 focus:outline-none focus:ring-2 focus:ring-white">
          <i data-lucide="chef-hat" class="w-5 h-5"></i>
          <span class="text-[11px]">Order</span>
        </a>
      </li>
      <li>
        <a href="{{ route('cart.index') }}" class="relative flex flex-col items-center justify-center gap-1 rounded-xl px-2 py-2 hover:bg-white/10 focus:outline-none focus:ring-2 focus:ring-white">
          <i data-lucide="shopping-cart" class="w-5 h-5"></i>
          <span class="text-[11px]">Cart</span>
          @if($cartCount)
            <span class="absolute -top-1.5 -right-1.5 inline-flex items-center justify-center min-w-[1.25rem] h-5 rounded-full bg-[var(--coral)] text-white text-[10px] px-1">{{ $cartCount }}</span>
          @endif
        </a>
      </li>
      <li>
        @if(Route::has('orders.index'))
        <a href="{{ route('orders.index') }}" class="relative flex flex-col items-center justify-center gap-1 rounded-xl px-2 py-2 hover:bg-white/10 focus:outline-none focus:ring-2 focus:ring-white">
          <i data-lucide="list" class="w-5 h-5"></i>
          <span class="text-[11px]">Orders</span>
          <span x-show="hasActive" x-cloak class="absolute top-1.5 right-3 inline-block w-2.5 h-2.5 rounded-full bg-emerald-400 ring-2 ring-[var(--charcoal)]" aria-label="Active order"></span>
        </a>
        @else
        <span class="flex flex-col items-center justify-center gap-1 rounded-xl px-2 py-2 opacity-60">
          <i data-lucide="list" class="w-5 h-5"></i>
          <span class="text-[11px]">Orders</span>
        </span>
        @endif
      </li>
      <li>
        <a href="{{ route('profile.edit') }}" class="flex flex-col items-center justify-center gap-1 rounded-xl px-2 py-2 hover:bg-white/10 focus:outline-none focus:ring-2 focus:ring-white">
          <i data-lucide="user" class="w-5 h-5"></i>
          <span class="text-[11px]">Profile</span>
        </a>
      </li>
    </ul>
  </div>
</nav>
