@props(['promos' => []])
@php $items = collect($promos)->filter(fn($p)=>is_array($p) && !empty($p['id']) && !empty($p['title'])); @endphp
@if($items->isNotEmpty())
<section class="surface rounded-xl p-4" data-io-hydrate @io-hydrate.window="$dispatch('promos-start')">
  <div class="flex items-center justify-between mb-2">
    <h3 class="font-semibold text-slate-900 dark:text-white">Promotions</h3>
  </div>
  <div x-data="{
      hidden:new Set(),
      key(id){ return `promo:dismissed:${id}`; },
      isHidden(id){ try{ return localStorage.getItem(this.key(id))==='1' || this.hidden.has(id); }catch(e){ return this.hidden.has(id); } },
      dismiss(id){ this.hidden.add(id); try{ localStorage.setItem(this.key(id), '1'); }catch(e){} }
  }" @promos-start.window="void 0" class="grid grid-cols-1 md:grid-cols-2 gap-3">
    @foreach($items as $p)
      <article x-show="!isHidden('{{ $p['id'] }}')" x-cloak class="rounded-lg border border-amber-200/50 bg-amber-50/50 dark:bg-amber-950/30 dark:border-amber-900/40 p-4 flex items-start gap-3">
        <div class="w-9 h-9 rounded-full bg-amber-500/15 text-amber-700 dark:text-amber-300 flex items-center justify-center shrink-0">
          <i data-lucide="percent" class="w-5 h-5"></i>
        </div>
        <div class="min-w-0 flex-1">
          <h4 class="font-medium text-slate-900 dark:text-white truncate">{{ $p['title'] }}</h4>
          @if(!empty($p['desc']))
          <p class="text-sm text-slate-700/80 dark:text-slate-300/90 line-clamp-2">{{ $p['desc'] }}</p>
          @endif
          <div class="mt-2 flex items-center gap-2">
            @if(!empty($p['href']) && !empty($p['cta']))
            <a href="{{ $p['href'] }}" class="btn btn-xs btn-primary">{{ $p['cta'] }}</a>
            @endif
            <button type="button" class="text-xs text-slate-500 hover:text-slate-700 dark:text-slate-400 dark:hover:text-slate-200" @click="dismiss('{{ $p['id'] }}')">Dismiss</button>
          </div>
        </div>
      </article>
    @endforeach
  </div>
</section>
@endif
