@props(['type' => 'info', 'message' => null])
@php($msg = $message ?? ($attributes->get('message')))
@php($base = 'rounded-lg px-4 py-2 text-sm flex items-start gap-2 border')
@php($classes = match($type){
  'success' => $base.' bg-emerald-50 text-emerald-800 border-emerald-200 dark:bg-emerald-500/10 dark:text-emerald-300 dark:border-emerald-600/40',
  'error' => $base.' bg-rose-50 text-rose-800 border-rose-200 dark:bg-rose-500/10 dark:text-rose-300 dark:border-rose-600/40',
  'warning' => $base.' bg-amber-50 text-amber-800 border-amber-200 dark:bg-amber-500/10 dark:text-amber-300 dark:border-amber-600/40',
  'info' => $base.' bg-indigo-50 text-indigo-800 border-indigo-200 dark:bg-indigo-500/10 dark:text-indigo-300 dark:border-indigo-600/40',
  default => $base.' bg-gray-50 text-gray-800 border-gray-200 dark:bg-slate-700/50 dark:text-slate-200 dark:border-slate-500/40'
})
<div {{ $attributes->merge(['class' => $classes, 'role' => 'status']) }}>
  {{ $msg }}
</div>