@props([
  'label' => null,
  'for' => null,
  'help' => null,
  'optional' => false,
  'errorKey' => null,
])
@php($key = $errorKey ?? $for)
<div {{ $attributes->merge(['class'=>'form-group']) }}>
  @if($label)
    <label @if($for) for="{{ $for }}" @endif class="form-label">{{ $label }} @if($optional)<span class="form-optional">@lang('Optional')</span>@endif</label>
  @endif
  <div class="form-control-slot">{{ $slot }}</div>
  @if($help)
    <p class="form-help">{!! $help !!}</p>
  @endif
  @if($key && $errors->has($key))
    <p class="form-error">{{ $errors->first($key) }}</p>
  @endif
</div>