@props([
    'src',
    'alt' => '',
    'class' => '',
    'width' => null,
    'height' => null,
    'sizes' => '100vw',
    'priority' => false,
    'placeholder' => null,
])

@php
    $w = $width ? (int) $width : null;
    $h = $height ? (int) $height : null;
    $fetch = $priority ? 'high' : null;

    // Resolve absolute URL for src if a local path was provided
    $isExternal = (bool) preg_match('/^(https?:)?\/\//i', (string) $src);
    $resolvedSrc = $isExternal ? $src : asset(ltrim((string) $src, '/'));

    // Derive local path info from URL or path safely (handles no-extension cases)
    $srcPath = parse_url($resolvedSrc, PHP_URL_PATH) ?: (string) $src;
    $ext = pathinfo($srcPath, PATHINFO_EXTENSION);
    $base = $ext ? substr($srcPath, 0, -(strlen($ext) + 1)) : $srcPath;

    $variants = [320,640,1024,1536];
    $mk = function(string $type) use ($variants, $base) {
        $parts = [];
        foreach ($variants as $ww) {
            $candidate = $base . '-' . $ww . '.' . $type;
            $full = public_path(ltrim($candidate, '/'));
            if (file_exists($full)) $parts[] = $candidate . ' ' . $ww . 'w';
        }
        return $parts ? implode(', ', $parts) : null;
    };
    $srcsetAvif = $mk('avif');
    $srcsetWebp = $mk('webp');

    // Optional LQIP background only if file exists
    $lqip = $placeholder ?? ($base . '-lqip.jpg');
    $lqipPath = public_path(ltrim($lqip, '/'));
    $bgStyle = file_exists($lqipPath) ? "background: url('{$lqip}') center/cover no-repeat;" : '';
    // Prebuild safe attribute strings
    $attrClass = !empty($class) ? ' class="'.e($class).'"' : '';
    $attrStyle = $bgStyle !== '' ? ' style="'.e($bgStyle).'"' : '';
@endphp

<picture>
    @if($srcsetAvif)
        <source type="image/avif" srcset="{{ $srcsetAvif }}" sizes="{{ $sizes }}" />
    @endif
    @if($srcsetWebp)
        <source type="image/webp" srcset="{{ $srcsetWebp }}" sizes="{{ $sizes }}" />
    @endif
    <img
        src="{{ $resolvedSrc }}"
        alt="{{ $alt }}"
        @if($w !== null) width="{{ $w }}" @endif
        @if($h !== null) height="{{ $h }}" @endif
        loading="{{ $priority ? 'eager' : 'lazy' }}"
        @if($fetch) fetchpriority="{{ $fetch }}" @endif
        decoding="async"
        sizes="{{ $sizes }}"{!! $attrClass !!}{!! $attrStyle !!} />
</picture>
