@php
  // Build responsive srcsets from manifest entry; gracefully degrade if variants missing.
  $avifSet = $webpSet = $jpgSet = '';
  $lqip = $thumb = null;
  $fallbackSrc = $fallback ? asset($fallback) : null;
  if ($entry) {
    $variants = $entry['variants'] ?? [];
    if (!empty($variants)) {
      usort($variants, fn($a,$b)=> ($a['width']??0) <=> ($b['width']??0));
      $avifSet = collect($variants)->filter(fn($v)=>!empty($v['avif']))->map(fn($v)=> asset($v['avif']).' '.($v['width']).'w')->join(', ');
      $webpSet = collect($variants)->filter(fn($v)=>!empty($v['webp']))->map(fn($v)=> asset($v['webp']).' '.($v['width']).'w')->join(', ');
      $jpgSet  = collect($variants)->filter(fn($v)=>!empty($v['jpg']))->map(fn($v)=> asset($v['jpg']).' '.($v['width']).'w')->join(', ');
      $largest = end($variants) ?: null;
      if ($largest && !empty($largest['jpg'])) {
        $fallbackSrc = asset($largest['jpg']);
      }
    }
    // If no variants but original exists in manifest, use it directly so image still displays
    if (empty($variants) && !empty($entry['original'])) {
      $fallbackSrc = asset($entry['original']);
    }
    if (isset($entry['lqip'])) $lqip = asset($entry['lqip']);
    if (isset($entry['thumb'])) $thumb = asset($entry['thumb']);
  }
  $sizesAttr = $sizes ?? ($type === 'slider' ? '(max-width: 768px) 100vw, 90vw' : '(max-width: 640px) 50vw, (max-width: 1024px) 33vw, 300px');
  $cls = $class ?? '';
@endphp

@if($entry)
<picture class="relative block {{$cls}}">
  @if($avifSet)<source type="image/avif" srcset="{{$avifSet}}" sizes="{{$sizesAttr}}" />@endif
  @if($webpSet)<source type="image/webp" srcset="{{$webpSet}}" sizes="{{$sizesAttr}}" />@endif
  <img
    @if(isset($fetchpriority)) fetchpriority="{{$fetchpriority}}" @endif
    @if($lqip) data-lqip="{{$lqip}}" @endif
    src="{{$fallbackSrc}}"
    @if($jpgSet) srcset="{{$jpgSet}}" sizes="{{$sizesAttr}}" @endif
    alt="{{$alt}}"
    loading="{{$loading}}"
    decoding="async"
    class="w-full h-auto {{$cls}} transition-opacity duration-300 opacity-0 js-rimg"
  />
</picture>
@else
  @if($fallbackSrc)
    <img src="{{$fallbackSrc}}" alt="{{$alt}}" class="{{$cls}}" loading="{{$loading}}" decoding="async" />
  @else
    <!-- responsive-image: no manifest entry and no fallback provided -->
  @endif
@endif

@once
  @push('scripts')
  <script>
  // Tiny progressive enhancement: fade in once loaded; optionally swap in LQIP as background until load.
  (function(){
    function enhance(img){
      if (img.dataset.lqip && !img.dataset.lqipApplied){
        img.style.background = 'url('+img.dataset.lqip+') center / cover no-repeat';
        img.dataset.lqipApplied = '1';
      }
      if (img.complete && img.naturalWidth){
        requestAnimationFrame(()=>{ img.classList.remove('opacity-0'); img.style.background='none'; });
      } else {
        img.addEventListener('load', ()=>{ img.classList.remove('opacity-0'); img.style.background='none'; }, { once: true });
        img.addEventListener('error', ()=>{ img.classList.remove('opacity-0'); }, { once: true });
      }
    }
    document.querySelectorAll('img.js-rimg').forEach(enhance);
    document.addEventListener('turbo:load', ()=> document.querySelectorAll('img.js-rimg').forEach(enhance));
  })();
  </script>
  @endpush
@endonce
