@props(['type' => 'success', 'message' => null])
@php($colors = [
  'success' => 'border-emerald-200 bg-emerald-50 text-emerald-800',
  'error' => 'border-rose-200 bg-rose-50 text-rose-800',
  'warning' => 'border-amber-200 bg-amber-50 text-amber-800',
  'info' => 'border-sky-200 bg-sky-50 text-sky-800',
])
<div x-data="{ open: true }" x-show="open" class="rounded border px-4 py-2 {{ $colors[$type] ?? $colors['info'] }}">
  <div class="flex items-start gap-3">
    <div class="flex-1">{{ $message ?? $slot }}</div>
    <button @click="open=false" aria-label="Close" class="opacity-70 hover:opacity-100"><i data-lucide="x" class="w-4 h-4"></i></button>
  </div>
</div>
