<x-app-layout>
    <x-customer.header />

    <div class="py-6">
        <div class="container-px max-w-7xl space-y-6">
            @isset($dbUnavailable)
            @if($dbUnavailable)
            <div class="rounded-md border border-amber-300/60 bg-amber-50 text-amber-900 dark:bg-amber-950/40 dark:text-amber-200 px-3 py-2">
                {{ __('Some data is temporarily unavailable. Parts of the dashboard may be limited.') }}
            </div>
            @endif
            @endisset
            
            <!-- Active Order (Phase 1 widget) -->
            @if($activeOrder)
                <x-customer.active-order :order="[
                    'id' => $activeOrder->id,
                    'status' => $activeOrder->status ?? $activeOrder->display_status,
                    'eta' => optional($activeOrder->created_at)->copy()->addMinutes((int) (config('app.avg_delivery_minutes', 30)))->toIso8601String(),
                    'track_url' => route('orders.show', $activeOrder),
                    'status_url' => route('orders.status.json', $activeOrder),
                ]" />
            @endif

            <!-- KPI tiles (Phase 1) -->
            <div x-data="{
                loading:true, err:null, data:null, announce:'', lastActiveId: undefined,
                async load(){
                    this.loading = true; this.err = null;
                    try{
                        const res = await fetch('{{ route('api.me.kpis') }}', {headers:{'Accept':'application/json'}});
                        this.data = await res.json();
                    }catch(e){ this.err = 'Failed to load KPIs'; this.data = null; }
                    finally{ this.loading = false; }
                }
            }" x-init="
                load();
                $watch('data', (val) => {
                    const curId = val && val.active_order ? val.active_order.id : null;
                    if (typeof $data.lastActiveId === 'undefined') { $data.lastActiveId = curId; return; }
                    if (curId !== $data.lastActiveId) {
                        $data.announce = curId ? `{{ __('Active order') }} #${curId}` : `{{ __('No active order') }}`;
                        $data.lastActiveId = curId;
                    }
                });
            " class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-4">
                <div class="sr-only" aria-live="polite" x-text="announce"></div>
                <!-- Skeletons -->
                <template x-if="loading">
                    <template x-for="i in 6">
                        <div class="surface rounded-xl p-4 animate-pulse">
                            <div class="w-10 h-10 rounded-lg bg-slate-200 dark:bg-slate-700 mb-3"></div>
                            <div class="h-3 w-20 bg-slate-200 dark:bg-slate-700 mb-2"></div>
                            <div class="h-5 w-24 bg-slate-200 dark:bg-slate-700"></div>
                        </div>
                    </template>
                </template>
                                <!-- Tiles -->
                                <template x-if="!loading && data">
                                        <template>
                                                <div class="surface rounded-xl p-4 flex items-center gap-3">
                                                    <div class="w-10 h-10 rounded-lg bg-primary/10 text-primary flex items-center justify-center shrink-0">
                                                        <i data-lucide="timer" class="w-5 h-5"></i>
                                                    </div>
                                                    <div class="min-w-0">
                                                        <div class="text-xs text-slate-500 dark:text-slate-400">{{ __('Active Order') }}</div>
                                                        <div class="text-lg font-semibold text-slate-900 dark:text-white" x-text="data.active_order ? ('#'+data.active_order.id) : '—'"></div>
                                                    </div>
                                                </div>
                                                                        <div class="surface rounded-xl p-4 flex items-center gap-3">
                                                    <div class="w-10 h-10 rounded-lg bg-primary/10 text-primary flex items-center justify-center shrink-0">
                                                        <i data-lucide="list-checks" class="w-5 h-5"></i>
                                                    </div>
                                                    <div class="min-w-0">
                                                        <div class="text-xs text-slate-500 dark:text-slate-400">{{ __('Total Orders') }}</div>
                                                                                @if(Route::has('orders.index'))
                                                                                    <a href="{{ route('orders.index') }}" class="block text-lg font-semibold text-slate-900 dark:text-white hover:underline" x-text="data.total_orders"></a>
                                                                                @else
                                                                                    <div class="text-lg font-semibold text-slate-900 dark:text-white" x-text="data.total_orders"></div>
                                                                                @endif
                                                    </div>
                                                </div>
                                                <div class="surface rounded-xl p-4 flex items-center gap-3">
                                                    <div class="w-10 h-10 rounded-lg bg-primary/10 text-primary flex items-center justify-center shrink-0">
                                                        <i data-lucide="clock" class="w-5 h-5"></i>
                                                    </div>
                                                    <div class="min-w-0">
                                                        <div class="text-xs text-slate-500 dark:text-slate-400">{{ __('Avg Delivery (min)') }}</div>
                                                        <div class="text-lg font-semibold text-slate-900 dark:text-white" x-text="data.avg_delivery_minutes ?? '—'"></div>
                                                    </div>
                                                </div>
                                                <div class="surface rounded-xl p-4 flex items-center gap-3">
                                                    <div class="w-10 h-10 rounded-lg bg-primary/10 text-primary flex items-center justify-center shrink-0">
                                                        <i data-lucide="trophy" class="w-5 h-5"></i>
                                                    </div>
                                                    <div class="min-w-0">
                                                        <div class="text-xs text-slate-500 dark:text-slate-400">{{ __('Rewards') }}</div>
                                                        <div class="text-lg font-semibold text-slate-900 dark:text-white">—</div>
                                                    </div>
                                                </div>
                                                                        <div class="surface rounded-xl p-4 flex items-center gap-3">
                                                    <div class="w-10 h-10 rounded-lg bg-primary/10 text-primary flex items-center justify-center shrink-0">
                                                        <i data-lucide="map-pin" class="w-5 h-5"></i>
                                                    </div>
                                                    <div class="min-w-0">
                                                        <div class="text-xs text-slate-500 dark:text-slate-400">{{ __('Addresses') }}</div>
                                                                                @if(Route::has('account.addresses.index'))
                                                                                    <a href="{{ route('account.addresses.index') }}" class="block text-lg font-semibold text-slate-900 dark:text-white hover:underline" x-text="data.addresses_count"></a>
                                                                                @else
                                                                                    <div class="text-lg font-semibold text-slate-900 dark:text-white" x-text="data.addresses_count"></div>
                                                                                @endif
                                                    </div>
                                                </div>
                                                <div class="surface rounded-xl p-4 flex items-center gap-3">
                                                    <div class="w-10 h-10 rounded-lg bg-primary/10 text-primary flex items-center justify-center shrink-0">
                                                        <i data-lucide="heart" class="w-5 h-5"></i>
                                                    </div>
                                                    <div class="min-w-0">
                                                        <div class="text-xs text-slate-500 dark:text-slate-400">{{ __('Favorites') }}</div>
                                                        <div class="text-lg font-semibold text-slate-900 dark:text-white" x-text="data.favorites_count"></div>
                                                    </div>
                                                </div>
                                        </template>
                                </template>
            </div>

            <div class="grid lg:grid-cols-3 gap-6">
                <!-- Personal Stats -->
                <div class="surface rounded-xl p-6">
                    <h3 class="font-semibold text-gray-900 dark:text-white mb-4">{{ __('Your Account') }}</h3>
                    <div class="space-y-3">
                        <div class="flex items-center justify-between">
                            <span class="text-sm text-gray-600 dark:text-gray-400">{{ __('Total Orders') }}</span>
                            <span class="font-semibold">{{ $personalStats['total_orders'] }}</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-sm text-gray-600 dark:text-gray-400">{{ __('Favorite Dishes') }}</span>
                            <span class="font-semibold">{{ $personalStats['favorite_dishes_count'] }}</span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-sm text-gray-600 dark:text-gray-400">{{ __('Saved Addresses') }}</span>
                            <span class="font-semibold">{{ $personalStats['saved_addresses_count'] }}</span>
                        </div>
                    </div>
                </div>

                <!-- Recent Orders -->
                <div class="lg:col-span-2 surface rounded-xl p-6" data-io-hydrate @io-hydrate.window="$dispatch('recent-start')" x-data="{loading:false}" @recent-start.window="void 0">
                    <div class="flex items-center justify-between mb-4">
                        <h3 class="font-semibold text-gray-900 dark:text-white">{{ __('Recent Orders') }}</h3>
                        <a href="{{ route('orders.index') }}" class="text-sm text-primary hover:text-primary-600">
                            {{ __('View All') }}
                        </a>
                    </div>
                    <!-- Skeleton (shows if no orders SSR and we want a light placeholder) -->
                    <template x-if="loading">
                        <div class="space-y-3">
                            <div class="flex items-center justify-between p-3 bg-gray-100/60 dark:bg-gray-700/40 rounded-lg animate-pulse">
                                <div class="flex items-center space-x-3">
                                    <div class="w-10 h-10 bg-slate-200 dark:bg-slate-700 rounded-lg"></div>
                                    <div>
                                        <div class="h-4 w-32 bg-slate-200 dark:bg-slate-700 mb-2"></div>
                                        <div class="h-3 w-24 bg-slate-200 dark:bg-slate-700"></div>
                                    </div>
                                </div>
                                <div class="h-7 w-16 bg-slate-200 dark:bg-slate-700 rounded"></div>
                            </div>
                            <div class="flex items-center justify-between p-3 bg-gray-100/60 dark:bg-gray-700/40 rounded-lg animate-pulse">
                                <div class="flex items-center space-x-3">
                                    <div class="w-10 h-10 bg-slate-200 dark:bg-slate-700 rounded-lg"></div>
                                    <div>
                                        <div class="h-4 w-28 bg-slate-200 dark:bg-slate-700 mb-2"></div>
                                        <div class="h-3 w-20 bg-slate-200 dark:bg-slate-700"></div>
                                    </div>
                                </div>
                                <div class="h-7 w-16 bg-slate-200 dark:bg-slate-700 rounded"></div>
                            </div>
                            <div class="flex items-center justify-between p-3 bg-gray-100/60 dark:bg-gray-700/40 rounded-lg animate-pulse">
                                <div class="flex items-center space-x-3">
                                    <div class="w-10 h-10 bg-slate-200 dark:bg-slate-700 rounded-lg"></div>
                                    <div>
                                        <div class="h-4 w-24 bg-slate-200 dark:bg-slate-700 mb-2"></div>
                                        <div class="h-3 w-16 bg-slate-200 dark:bg-slate-700"></div>
                                    </div>
                                </div>
                                <div class="h-7 w-16 bg-slate-200 dark:bg-slate-700 rounded"></div>
                            </div>
                        </div>
                    </template>
                    @if($recentOrders->count() > 0)
                        <div class="space-y-3">
                            @foreach($recentOrders as $order)
                            <div class="flex items-center justify-between p-3 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
                                <div class="flex items-center space-x-3">
                                    <div class="w-10 h-10 bg-primary/10 rounded-lg flex items-center justify-center">
                                        <span class="text-xs font-semibold text-primary">#{{ $order->id }}</span>
                                    </div>
                                    <div>
                                        <p class="font-medium text-gray-900 dark:text-white">
                                            {{ $order->items->count() }} {{ __('items') }}
                                        </p>
                                        <p class="text-sm text-gray-600 dark:text-gray-400">
                                            {{ $order->created_at->format('M j, Y') }} • ₦{{ number_format($order->total, 2) }}
                                        </p>
                                    </div>
                                </div>
                                <div class="flex items-center space-x-2">
                                    <x-status-badge :status="$order->status" />
                                    <a href="{{ route('orders.show', $order) }}" class="btn btn-outline text-xs">
                                        {{ __('View') }}
                                    </a>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-8">
                            <svg class="w-12 h-12 text-gray-300 dark:text-gray-600 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                            </svg>
                            <p class="text-gray-600 dark:text-gray-400">{{ __('No orders yet') }}</p>
                            <a href="{{ route('menu.index') }}" class="btn btn-primary mt-3">
                                {{ __('Start Ordering') }}
                            </a>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Favorite Dishes -->
            @if($favoriteDishes->count() > 0)
            <div class="surface rounded-xl p-6" data-io-hydrate @io-hydrate.window="$dispatch('favorites-start')">
                <div class="flex items-center justify-between mb-6">
                    <h3 class="font-semibold text-gray-900 dark:text-white">{{ __('Your Favorites') }}</h3>
                    <a href="{{ route('menu.index') }}" class="text-sm text-primary hover:text-primary-600">
                        {{ __('Browse Menu') }}
                    </a>
                </div>
                
                <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-4" x-data @favorites-start.window="void 0">
                    @foreach($favoriteDishes as $dish)
                    <div class="group">
                        <div class="relative aspect-square bg-gray-100 dark:bg-gray-700 rounded-lg overflow-hidden mb-3">
                            @php
                                $public = $dish->public_image_url;
                                $src = $public ?: asset('assets/placeholders/dish-placeholder.svg');
                                $base = $dish->image_base;
                                $manifestEntry = $base ? App\Support\ImageManifest::find('dish', $base) : null;
                            @endphp
                            @if($base && $manifestEntry)
                                <x-responsive-image
                                    type="dish"
                                    :base="$base"
                                    :alt="$dish->name"
                                    class="absolute inset-0 w-full h-full object-cover transition-transform duration-300 group-hover:scale-105"
                                    sizes="(max-width:768px) 50vw, 200px"
                                    :fallback="$src"
                                />
                            @else
                                <img src="{{ $src }}"
                                     alt="{{ $dish->name }}"
                                     loading="lazy"
                                     width="400" height="400"
                                     class="absolute inset-0 w-full h-full object-cover transition-transform duration-300 group-hover:scale-105">
                            @endif
                        </div>
                        <h4 class="font-medium text-sm text-gray-900 dark:text-white truncate">{{ $dish->name }}</h4>
                        <p class="text-sm text-primary font-semibold">₦{{ number_format($dish->price, 2) }}</p>
                        <form action="{{ route('cart.add') }}" method="POST" class="mt-2">
                            @csrf
                            <input type="hidden" name="dish_id" value="{{ $dish->id }}">
                            <button type="submit" class="w-full btn btn-outline text-xs">
                                {{ __('Add to Cart') }}
                            </button>
                        </form>
                    </div>
                    @endforeach
                </div>
            </div>
            @endif

            <!-- Saved Addresses -->
            @if($savedAddresses->count() > 0)
            <div class="surface rounded-xl p-6">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="font-semibold text-gray-900 dark:text-white">{{ __('Delivery Addresses') }}</h3>
                    <a href="{{ route('account.addresses.index') }}" class="text-sm text-primary hover:text-primary-600">
                        {{ __('Manage') }}
                    </a>
                </div>
                
                <div class="grid md:grid-cols-3 gap-4">
                    @foreach($savedAddresses as $address)
                    <div class="p-4 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
                        <div class="flex items-start justify-between">
                            <div class="flex-1">
                                <h4 class="font-medium text-gray-900 dark:text-white">
                                    {{ $address->label }}
                                    @if($address->is_primary)
                                        <span class="text-xs bg-primary text-white px-2 py-1 rounded-full ml-2">{{ __('Primary') }}</span>
                                    @endif
                                </h4>
                                <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">
                                    {{ Str::limit($address->full_address, 60) }}
                                </p>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
            @endif
        </div>
    </div>

    <div class="py-4">
        <div class="container-px max-w-7xl grid md:grid-cols-3 gap-6">
            <div class="md:col-span-2">
                <x-customer.promos :promos="[
                    ['id'=>'free-delivery','title'=>__('Free delivery over ₦:amount',['amount'=>number_format((int) (\App\Models\Setting::get('delivery.free_threshold', 20000)),0)]),'desc'=>__('Limited time offer. Automatic at checkout.'),'cta'=>__('Order now'),'href'=>route('menu.index')],
                    ['id'=>'new-user-5','title'=>__('New users get ₦500 off'),'desc'=>__('Use code WELCOME500 at checkout.')],
                ]" />
            </div>
            <div>
                <x-customer.loyalty :points="0" tier="Member" next-tier="Silver" :progress="0" :cta-href="route('orders.index')" :cta-text="__('See rewards')" />
            </div>
        </div>
    </div>
</x-app-layout>
<x-customer.mobile-bar />