@push('head')
<script>
window.MENU_URL = "{{ route('menu.index') }}";
window.searchBox = function(){
    return {
        q: '', open: false, all: [], results: [],
        async ensureData(){
            if(this.all.length) return;
            try{
                const res = await fetch('/menu.json', { headers: { 'Accept':'application/json' } });
                const data = await res.json();
                const list = [];
                (data.categories||[]).forEach(c => {
                    (c.dishes||[]).forEach(d => {
                        list.push({
                            k: `d${d.id}`,
                            name: d.name,
                            category: c.name,
                            price: d.price ? `₦${Number(d.price).toLocaleString()}` : '',
                            url: window.MENU_URL + '?category=' + encodeURIComponent(c.name) + '#cat'
                        });
                    });
                });
                this.all = list;
            } catch(e) { this.all = []; }
        },
        async onInput(){
            this.open = true;
            await this.ensureData();
            const q = this.q.trim().toLowerCase();
            if(!q){ this.results = []; return; }
            this.results = this.all.filter(x => x.name.toLowerCase().includes(q) || x.category.toLowerCase().includes(q)).slice(0, 8);
        },
        close(){ this.open = false; }
    };
}

// Hero background slideshow (cross-fade, pauses on hover, respects reduced motion)
window.heroSlides = function(list){
    const mql = window.matchMedia('(prefers-reduced-motion: reduce)');
    return {
        slides: Array.isArray(list) && list.length ? list : [],
        i: 0,
        timer: null,
        delay: 5000,
        enabled: !mql.matches,
        init(){
            if(this.slides.length === 0){ return; }
            if(this.enabled && this.slides.length > 1){ this.timer = setInterval(()=>this.next(), this.delay); }
        },
        restart(){
            if(this.timer){ clearInterval(this.timer); this.timer = null; }
            if(this.enabled && this.slides.length > 1){ this.timer = setInterval(()=>this.next(), this.delay); }
        },
        next(){ this.i = (this.i + 1) % this.slides.length; this.restart(); },
        prev(){ this.i = (this.i - 1 + this.slides.length) % this.slides.length; this.restart(); },
        goTo(n){ if(Number.isInteger(n)){ this.i = ((n % this.slides.length) + this.slides.length) % this.slides.length; this.restart(); } },
        pause(){ if(this.timer){ clearInterval(this.timer); this.timer = null; } },
        resume(){ if(this.enabled && !this.timer && this.slides.length > 1){ this.timer = setInterval(()=>this.next(), this.delay); } }
    };
}
</script>
@endpush

<x-app-layout>
    @push('head')
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@700;900&family=Cormorant+Garamond:wght@400;700&family=Inter:wght@400;500;700&display=swap" rel="stylesheet">
        <style>
            :root{ --charcoal:#36454f; --bonny-blue:#0077c8; --coral:#ff7f50; --pearl:#fdf4e3; --gold:#ffd700; }
            .font-display{ font-family:"Playfair Display","Cormorant Garamond",serif }
            .font-sans-alt{ font-family:"Inter","SF Pro Display",system-ui,-apple-system,sans-serif }
            .text-balance{ text-wrap:balance }
        </style>
        <script type="application/ld+json">
            {!! json_encode([
                '@context' => 'https://schema.org',
                '@type' => 'Restaurant',
                'name' => config('app.name', 'Bonny Delight'),
                'url' => url('/'),
                'servesCuisine' => ['Nigerian','African','Grill'],
                'image' => [asset('assets/images/jollof.jpg')],
                'priceRange' => '₦₦₦',
                'address' => ['@type' => 'PostalAddress', 'addressCountry' => 'NG'],
            ], JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) !!}
        </script>
    @endpush

    @php
        // Safe fallbacks (raw relative paths inside /public)
    // Use manifest slider entries if available
    $manifest = \App\Support\ImageManifest::get();
    if (empty($slides) && $manifest && !empty($manifest['slider'])) {
        $slides = collect($manifest['slider'])
            ->map(function($e){
                // prefer largest variant or original
                $vars = $e['variants'] ?? [];
                if ($vars) {
                    usort($vars, fn($a,$b)=>($b['width']??0) <=> ($a['width']??0));
                    $largest = $vars[0];
                    return asset($largest['jpg']);
                }
                return isset($e['original']) ? asset($e['original']) : null;
            })
            ->filter()->values()->all();
    }
    $slides = $slides ?? [asset('assets/images/jollof.jpg'),asset('assets/images/egusi.jpg'),asset('assets/images/suya.jpg'),asset('assets/images/efo_riro.jpg'),asset('assets/images/pepper_soup.jpg')];
        $categories = $categories ?? ['Jollof Rice','Suya','Egusi Soup','Grilled Fish'];
        $specials = ($specials ?? collect());
        $signature = ($signature ?? collect());
        $popular = $signature->isNotEmpty() ? $signature->take(6) : ($specials->isNotEmpty() ? $specials->take(6) : collect());
        $placeholderImg = '/assets/placeholders/dish-placeholder.svg';

    // Determine effective base path. The app is now flattened at project root (e.g. /bonny_delight),
    // but we keep this logic so deployments under a subdirectory continue to work without edits.
        $runtimeBase = rtrim(request()->getBaseUrl(), '/'); // request-detected base path
        $configBasePath = trim(parse_url(config('app.url'), PHP_URL_PATH) ?? '', '/'); // path portion of APP_URL if any
        $effectiveBase = $runtimeBase !== '' ? $runtimeBase : ($configBasePath !== '' ? '/' . $configBasePath : '');

        $makeUrl = function(string $p) use ($effectiveBase){
            // If already absolute (http(s) or protocol relative) return as-is
            if (preg_match('~^(?:https?:)?//~i', $p)) { return $p; }
            // Normalize to root-relative
            $p = '/' . ltrim($p, '/');
            if ($effectiveBase && $effectiveBase !== '/' && !str_starts_with($p, $effectiveBase.'/')) {
                return rtrim($effectiveBase, '/') . $p;
            }
            return $p;
        };

        // Normalize slide URLs (ensure absolute)
        // Slides now supplied as root-relative or absolute; no further expansion needed here.
        $heroImage = $slides[0] ?? asset('assets/images/jollof.jpg');
        $heroUrl = $makeUrl($heroImage);
        $slideUrls = collect($slides)->map(fn($p) => $makeUrl((string)$p))->filter()->unique()->values()->all();
        if (empty($slideUrls)) { $slideUrls = [$heroUrl]; }

        $freeThreshold = (float) \App\Models\Setting::get('delivery.free_threshold', 20000);
        $baseDeliveryFee = (float) \App\Models\Setting::get('delivery.fee_base', 1000);
    @endphp

    @push('head')
        <link rel="preload" as="image" href="{{ $heroUrl }}">
        @php $morePreloads = array_slice($slideUrls, 1, 2); @endphp
        @foreach($morePreloads as $p)
            <link rel="preload" as="image" href="{{ $p }}">
        @endforeach
    @endpush

    <div class="relative">
        <!-- Hero -->
    <section class="relative min-h-[70svh] min-h-[520px] w-full overflow-hidden isolate" data-hero style="background:#000 center/cover no-repeat {{ isset($slides[0]) ? 'url('.e($slides[0]).')' : '' }};">
            <script>console.info('Slider debug slides:', @json($slides));</script>
            <div class="absolute inset-0" x-data="window.heroSlides(@js($slideUrls))" x-init="init()" @mouseenter="pause()" @mouseleave="resume()" aria-hidden="true">
                <noscript><img src="{{ $heroUrl }}" alt="" class="absolute inset-0 w-full h-full object-cover"/></noscript>
                <template x-for="(url,idx) in slides" :key="idx">
                    <img :src="url" alt="" class="absolute inset-0 w-full h-full object-cover transition-all duration-[1500ms] ease-in-out opacity-0 scale-100" :class="idx===i ? 'opacity-100 scale-105' : ''" :loading="idx===i ? 'eager' : 'lazy'">
                </template>
                <!-- Controls -->
                <div class="absolute inset-y-0 left-0 right-0 flex items-center justify-between px-2 sm:px-4 z-10 pointer-events-none">
                    <button type="button" class="pointer-events-auto inline-flex items-center justify-center size-9 sm:size-10 rounded-full bg-white/20 hover:bg-white/30 text-white shadow ring-1 ring-white/30" @click="prev()" aria-label="Previous slide" @mouseenter.stop="pause()" @mouseleave.stop="resume()">
                        <i data-lucide="chevron-left" class="w-5 h-5"></i>
                    </button>
                    <button type="button" class="pointer-events-auto inline-flex items-center justify-center size-9 sm:size-10 rounded-full bg-white/20 hover:bg-white/30 text-white shadow ring-1 ring-white/30" @click="next()" aria-label="Next slide" @mouseenter.stop="pause()" @mouseleave.stop="resume()">
                        <i data-lucide="chevron-right" class="w-5 h-5"></i>
                    </button>
                </div>
                <!-- Indicators -->
                <div class="absolute bottom-3 sm:bottom-4 left-0 right-0 z-10 flex justify-center gap-1.5">
                    <template x-for="(u, idx) in slides" :key="'dot-'+idx">
                        <button type="button" class="h-1.5 rounded-full transition-colors" :class="idx===i ? 'bg-white w-6' : 'bg-white/60 hover:bg-white/80 w-2.5'" @click="goTo(idx)" :aria-label="'Go to slide ' + (idx+1)" :aria-current="idx===i ? 'true' : 'false'"></button>
                    </template>
                </div>
                <div class="absolute inset-0 bg-gradient-to-b from-black/60 via-black/40 to-black/70"></div>
            </div>

            <div class="relative z-10 max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 py-20 md:py-28 text-white text-center">
                <h1 class="font-display text-balance text-4xl sm:text-5xl md:text-6xl font-black leading-tight">Refined Nigerian Cuisine, Delivered</h1>
                <p class="mt-4 text-base md:text-lg text-white/90">Order chef-crafted meals from Bonny Delight. Fresh, fast, and beautifully served.</p>
                <div class="mt-8 flex flex-wrap items-center justify-center gap-3">
                    <a href="{{ route('menu.index') }}" class="inline-flex items-center justify-center rounded-full h-12 px-6 text-base font-semibold bg-[var(--bonny-blue)] text-white hover:bg-opacity-90">View Menu</a>
                    <a href="{{ route('menu.index') }}#all" class="inline-flex items-center justify-center rounded-full h-12 px-6 text-base font-semibold bg-[var(--coral)] text-white hover:bg-opacity-90">Order Now</a>
                </div>
                <p class="mt-3 text-sm text-white/80">Avg. delivery 25–35 min • From ₦{{ number_format($baseDeliveryFee, 0) }}</p>
                <div class="mt-4 inline-flex items-center gap-2 bg-white/15 text-white rounded-full px-4 py-2">
                    <i data-lucide="badge-check" class="w-4 h-4"></i>
                    <span class="text-sm">Free delivery over ₦{{ number_format($freeThreshold, 0) }}</span>
                </div>

                <!-- Hero search with live suggestions -->
                <div class="mt-8 max-w-xl mx-auto text-left" x-data="window.searchBox()">
                    <label for="hero-search" class="sr-only">Search dishes</label>
                    <div class="relative">
                        <i data-lucide="search" class="w-5 h-5 text-white/70 absolute left-3 top-1/2 -translate-y-1/2 pointer-events-none"></i>
                        <input id="hero-search" x-model="q" @input.debounce.300ms="onInput" @keydown.escape="close()" @focus="open=true" type="search" placeholder="Search dishes (e.g., jollof, suya)" class="w-full pl-10 pr-3 py-3 rounded-xl bg-white/90 text-[var(--charcoal)] placeholder:text-[var(--charcoal)]/50 focus:outline-none">
                        <!-- Results -->
                        <div x-show="open && results.length" @click.outside="close()" class="absolute z-20 mt-2 w-full rounded-xl bg-white text-[var(--charcoal)] shadow-lg ring-1 ring-black/5 max-h-80 overflow-auto">
                            <ul>
                                <template x-for="item in results" :key="item.k">
                                    <li>
                                        <a :href="item.url" class="flex items-center gap-3 px-3 py-2 hover:bg-[var(--pearl)]/60">
                                            <i data-lucide="utensils" class="w-4 h-4 text-[var(--bonny-blue)]"></i>
                                            <div class="text-sm">
                                                <div class="font-medium" x-text="item.name"></div>
                                                <div class="text-[var(--charcoal)]/70" x-text="item.category"></div>
                                            </div>
                                            <span class="ms-auto text-sm font-semibold" x-text="item.price"></span>
                                        </a>
                                    </li>
                                </template>
                                <template x-if="!results.length && q.length">
                                    <li class="px-3 py-2 text-sm text-[var(--charcoal)]/70">No matches</li>
                                </template>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Decorative food image clusters -->
            <div class="pointer-events-none absolute hidden md:block left-6 bottom-6 z-10 transform-gpu will-change-transform" aria-hidden="true" data-parallax="0.25">
                <div class="flex items-center gap-3">
                    <div class="rounded-2xl overflow-hidden shadow-lg ring-1 ring-white/20 rotate-[-3deg]">
                        <x-img src="{{ asset('assets/images/jollof.jpg') }}" alt="" class="w-28 h-20 lg:w-36 lg:h-28 object-cover" :width="320" :height="240" sizes="(min-width:1024px) 144px, 112px" />
                    </div>
                    <div class="rounded-2xl overflow-hidden shadow-lg ring-1 ring-white/20 rotate-[2deg] translate-y-3 hidden lg:block">
                        <x-img src="{{ asset('assets/images/pepper_soup.jpg') }}" alt="" class="w-24 h-16 lg:w-28 lg:h-20 object-cover" :width="256" :height="192" sizes="(min-width:1024px) 112px, 96px" />
                    </div>
                </div>
            </div>
            <div class="pointer-events-none absolute hidden md:block right-6 top-10 z-10 transform-gpu will-change-transform" aria-hidden="true" data-parallax="-0.18">
                <div class="rounded-2xl overflow-hidden shadow-lg ring-1 ring-white/20 rotate-[4deg]">
                    <x-img src="{{ asset('assets/images/suya.jpg') }}" alt="" class="w-24 h-20 lg:w-32 lg:h-24 object-cover" :width="256" :height="192" sizes="(min-width:1024px) 128px, 96px" />
                </div>
            </div>
            <div class="pointer-events-none absolute hidden lg:block right-40 bottom-8 z-10 transform-gpu will-change-transform" aria-hidden="true" data-parallax="0.12">
                <div class="rounded-2xl overflow-hidden shadow-lg ring-1 ring-white/20 rotate-[-2deg]">
                    <x-img src="{{ asset('assets/images/efo_riro.jpg') }}" alt="" class="w-24 h-20 lg:w-28 lg:h-20 object-cover" :width="256" :height="192" sizes="(min-width:1024px) 112px, 96px" />
                </div>
            </div>
        </section>

        <!-- Categories (chips) -->
        <section class="py-10 bg-white">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center mb-6">
                    <h2 class="font-display text-3xl md:text-4xl font-bold text-[var(--charcoal)]">Browse by Category</h2>
                </div>
                <div class="flex justify-center flex-wrap gap-3">
                    @foreach(($categories ?? []) as $c)
                        <a href="{{ route('menu.index', ['category' => $c]) }}#cat" class="px-5 py-2 text-sm font-medium rounded-full bg-[var(--pearl)] text-[var(--charcoal)] hover:bg-[var(--bonny-blue)]/10 transition">{{ $c }}</a>
                    @endforeach
                </div>
            </div>
        </section>

    <!-- Popular dishes -->
    <section id="popular" class="py-14 bg-white">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex items-end justify-between mb-6">
                    <h2 class="font-display text-3xl md:text-4xl font-bold text-[var(--charcoal)]">Popular Dishes</h2>
                    <a href="{{ route('menu.index') }}" class="text-[var(--bonny-blue)] hover:underline">View full menu</a>
                </div>
                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
                    @php $hasPopular = $popular->isNotEmpty(); @endphp
                    @foreach(($hasPopular ? $popular : collect(range(1,6))) as $dish)
                        @php
                            $img = asset(ltrim($placeholderImg,'/'));
                            $base = null;
                            if ($hasPopular && $dish->image) {
                                $public = $dish->public_image_url;
                                if ($public) { $img = $public; }
                                $candidateBase = $dish->image_base;
                                if ($candidateBase && App\Support\ImageManifest::find('dish', $candidateBase)) {
                                    $base = $candidateBase;
                                }
                            }
                            $name = $hasPopular ? $dish->name : 'Classic Jollof Rice';
                            $subtitle = $hasPopular ? (string)($dish->description ?? 'A staple of Nigerian cuisine.') : 'A staple of Nigerian cuisine.';
                            $price = $hasPopular ? number_format((float)($dish->price ?? 0), 2) : number_format(4500, 2);
                            $qtyInCart = $hasPopular && isset($dish->id) ? (int) (session('cart.items.'.$dish->id) ?? 0) : 0;
                        @endphp
                        <div class="group flex flex-col rounded-xl overflow-hidden bg-white shadow-sm ring-1 ring-black/5">
                            <div class="overflow-hidden">
                                @if($base)
                                    <x-responsive-image type="dish" :base="$base" :alt="$name" class="w-full aspect-[4/3] object-cover transition group-hover:scale-105" sizes="(min-width:1024px) 33vw, (min-width:640px) 50vw, 100vw" :fallback="$img" />
                                @else
                                    <img src="{{ $img }}" alt="{{ $name }}" class="w-full aspect-[4/3] object-cover transition group-hover:scale-105" width="640" height="480" loading="lazy" />
                                @endif
                            </div>
                            <div class="p-4 flex flex-col gap-2">
                                <div class="flex items-start justify-between gap-3">
                                    <div>
                                        <h3 class="text-lg font-semibold text-[var(--charcoal)]">{{ $name }}</h3>
                                        <p class="text-[var(--charcoal)]/70 text-sm line-clamp-2">{{ $subtitle }}</p>
                                    </div>
                                    <div class="shrink-0 text-right">
                                        <div class="text-base md:text-lg font-bold text-[var(--charcoal)]">₦{{ $price }}</div>
                                    </div>
                                </div>
                                <div class="mt-1">
                                    @if($hasPopular && isset($dish->id))
                                        @if($qtyInCart > 0)
                                            <div class="inline-flex items-center gap-2" aria-label="Update quantity for {{ $name }}">
                                                @if($qtyInCart > 1)
                                                    <form method="POST" action="{{ route('cart.update') }}">
                                                        @csrf
                                                        <input type="hidden" name="dish_id" value="{{ $dish->id }}">
                                                        <input type="hidden" name="quantity" value="{{ $qtyInCart - 1 }}">
                                                        <button type="submit" class="size-9 rounded-full bg-gray-200 text-gray-700 hover:bg-gray-300" title="Decrease">
                                                            <span class="sr-only">Decrease</span>
                                                            −
                                                        </button>
                                                    </form>
                                                @else
                                                    <form method="POST" action="{{ route('cart.remove') }}">
                                                        @csrf
                                                        <input type="hidden" name="dish_id" value="{{ $dish->id }}">
                                                        <button type="submit" class="size-9 rounded-full bg-gray-200 text-gray-700 hover:bg-gray-300" title="Remove">
                                                            <span class="sr-only">Remove</span>
                                                            −
                                                        </button>
                                                    </form>
                                                @endif
                                                <span class="min-w-[2ch] text-center text-sm font-semibold text-[var(--charcoal)]">{{ $qtyInCart }}</span>
                                                <form method="POST" action="{{ route('cart.update') }}">
                                                    @csrf
                                                    <input type="hidden" name="dish_id" value="{{ $dish->id }}">
                                                    <input type="hidden" name="quantity" value="{{ $qtyInCart + 1 }}">
                                                    <button type="submit" class="size-9 rounded-full bg-[var(--bonny-blue)] text-white hover:bg-opacity-90" title="Increase">
                                                        <span class="sr-only">Increase</span>
                                                        +
                                                    </button>
                                                </form>
                                            </div>
                                        @else
                                            <form method="POST" action="{{ route('cart.add') }}" class="inline-flex">
                                                @csrf
                                                <input type="hidden" name="dish_id" value="{{ $dish->id }}">
                                                <input type="hidden" name="quantity" value="1">
                                                <button type="submit" class="inline-flex items-center justify-center rounded-full h-9 px-4 text-sm font-semibold bg-[var(--bonny-blue)] text-white hover:bg-opacity-90">
                                                    Add
                                                </button>
                                            </form>
                                        @endif
                                    @else
                                        <a href="{{ route('menu.index') }}#all" class="inline-flex items-center justify-center rounded-full h-9 px-4 text-sm font-semibold bg-[var(--bonny-blue)] text-white hover:bg-opacity-90">Order</a>
                                    @endif
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>

        <!-- Advantages -->
        <section class="py-14 bg-[var(--pearl)]/80">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center mb-8">
                    <h2 class="font-display text-3xl md:text-4xl font-bold text-[var(--charcoal)]">Why Bonny Delight</h2>
                </div>
                <div class="grid grid-cols-1 sm:grid-cols-3 gap-6 text-center">
                    @php $adv = [
                        ['icon'=>'utensils-crossed','title'=>'Chef-crafted','desc'=>'Authentic Nigerian recipes with premium ingredients.'],
                        ['icon'=>'clock','title'=>'Fast Delivery','desc'=>'Hot and fresh to your room or doorstep.'],
                        ['icon'=>'leaf','title'=>'Fresh & Clean','desc'=>'Prepared with care in a hygienic kitchen.'],
                    ]; @endphp
                    @foreach($adv as $a)
                        <div class="flex flex-col items-center gap-3 p-6 rounded-xl bg-white/80 ring-1 ring-black/5">
                            <i data-lucide="{{ $a['icon'] }}" class="w-10 h-10 text-[var(--bonny-blue)]" aria-hidden="true"></i>
                            <h3 class="text-[var(--charcoal)] text-lg font-bold">{{ $a['title'] }}</h3>
                            <p class="text-[var(--charcoal)]/70 text-sm max-w-xs">{{ $a['desc'] }}</p>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
        
        <!-- Testimonials -->
        <section class="py-14 bg-white">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center mb-8">
                    <h2 class="font-display text-3xl md:text-4xl font-bold text-[var(--charcoal)]">Loved by diners</h2>
                    <p class="text-[var(--charcoal)]/70 max-w-2xl mx-auto">Real feedback from happy customers who enjoy fast, delicious meals.</p>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    @php $testi = [
                        ['n'=>'Ada','t'=>'“The jollof is perfect every time. Delivery is quick and food arrives hot.”'],
                        ['n'=>'Tunde','t'=>'“Best suya I’ve had in town. Ordering is so easy.”'],
                        ['n'=>'Zainab','t'=>'“Clean, tasty, and reliable. Great for late-night cravings.”'],
                    ]; @endphp
                    @foreach($testi as $x)
                        <figure class="rounded-xl p-6 ring-1 ring-black/5 bg-white shadow-sm">
                            <div class="flex items-center gap-2 text-amber-500 mb-2" aria-label="5 stars">
                                @for($i=0;$i<5;$i++)<i data-lucide="star" class="w-4 h-4 fill-current"></i>@endfor
                            </div>
                            <blockquote class="text-[var(--charcoal)]/80">{{ $x['t'] }}</blockquote>
                            <figcaption class="mt-3 text-sm font-semibold text-[var(--charcoal)]">— {{ $x['n'] }}</figcaption>
                        </figure>
                    @endforeach
                </div>
            </div>
        </section>

        @php
            // Cart count for sticky mobile bar
            $navCartItems = session('cart.items', []);
            $navCartCount = 0;
            if (is_array($navCartItems)) {
                foreach ($navCartItems as $it) {
                    if (is_array($it) && isset($it['qty'])) { $navCartCount += (int) $it['qty']; }
                    elseif (is_numeric($it)) { $navCartCount += (int) $it; }
                }
            }
        @endphp
        <!-- Sticky mobile action bar -->
        <div class="md:hidden fixed bottom-0 inset-x-0 z-40">
            <div class="mx-4 mb-4 rounded-2xl bg-[var(--charcoal)] text-white shadow-lg ring-1 ring-black/5 px-4 py-3 flex items-center gap-3">
                <a href="{{ route('menu.index') }}" class="flex-1 inline-flex items-center justify-center gap-2 rounded-xl bg-[var(--bonny-blue)] px-4 py-2.5 font-semibold hover:bg-opacity-90">
                    <i data-lucide="chef-hat" class="w-5 h-5"></i>
                    Start order
                </a>
                <a href="{{ route('cart.index') }}" class="inline-flex items-center gap-2 rounded-xl bg-white/10 px-3 py-2 font-medium hover:bg-white/15">
                    <i data-lucide="shopping-cart" class="w-5 h-5"></i>
                    <span class="text-sm">Cart</span>
                    @if($navCartCount)
                        <span class="ml-1 inline-flex items-center justify-center min-w-[1.5rem] h-6 rounded-full bg-[var(--coral)] text-white text-xs px-2">{{ $navCartCount }}</span>
                    @endif
                </a>
            </div>
        </div>

    <!-- End -->
    </div>
</x-app-layout>

@push('scripts')
<script>
// Light parallax for decorative hero images (respects prefers-reduced-motion)
(function(){
    const mql = window.matchMedia('(prefers-reduced-motion: reduce)');
    if(mql.matches) return;
    if((window.innerHeight||0) < 560) return;
    const hero = document.querySelector('[data-hero]');
    const els = Array.from(document.querySelectorAll('[data-parallax]'));
    if(!els.length) return;
    const speeds = els.map(el => parseFloat(el.getAttribute('data-parallax')) || 0.2);
    let ticking = false;
    let active = true;
    function update(){
        if(!active) { ticking = false; return; }
        const vh = window.innerHeight || 1;
        els.forEach((el, i) => {
            const rect = el.getBoundingClientRect();
            const rel = (rect.top - vh/2) / vh;
            const max = 24;
            const t = Math.max(-max, Math.min(max, rel * speeds[i] * 120));
            el.style.transform = `translateY(${t}px)`;
        });
        ticking = false;
    }
    function onScroll(){ if(!ticking){ ticking = true; requestAnimationFrame(update); } }
    if(hero && 'IntersectionObserver' in window){
        const io = new IntersectionObserver((entries)=>{
            active = entries.some(e => e.isIntersecting);
            if(active) onScroll();
        },{ rootMargin: '0px 0px 0px 0px', threshold: [0,0.01,1] });
        io.observe(hero);
        window.addEventListener('beforeunload', ()=> io.disconnect(), { once:true });
    }
    window.addEventListener('scroll', onScroll, { passive: true });
    window.addEventListener('resize', onScroll);
    update();
})();
</script>
@endpush

</x-app-layout>
