<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Admin — {{ config('app.name', 'Bonny Delight') }}</title>

  <meta name="application-name" content="{{ config('app.name', 'Bonny Delight') }}">
  <meta name="color-scheme" content="light dark">
  <meta name="theme-color" content="#0f172a">
  <meta name="theme-color" media="(prefers-color-scheme: light)" content="#ffffff">
  <meta name="theme-color" media="(prefers-color-scheme: dark)" content="#0f172a">
  <meta name="mobile-web-app-capable" content="yes">
  <meta name="apple-mobile-web-app-capable" content="yes">
  <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
  <meta name="apple-mobile-web-app-title" content="{{ config('app.name', 'Bonny Delight') }}">

  <!-- Icons / Favicons -->
  <link rel="apple-touch-icon" sizes="180x180" href="/icons/apple-touch-icon-180.png">
  <link rel="icon" type="image/png" sizes="32x32" href="/icons/favicon-32x32.png">
  <link rel="icon" type="image/png" sizes="16x16" href="/icons/favicon-16x16.png">
  <link rel="alternate icon" type="image/png" sizes="32x32" href="/icons/icon-32.png">
  <link rel="alternate icon" type="image/png" sizes="16x16" href="/icons/icon-16.png">
  <link rel="shortcut icon" href="/icons/favicon-32x32.png">

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;700&display=swap" rel="stylesheet">

    @stack('head')

  <script nonce="{{ $cspNonce ?? '' }}">
      // Early deterministic theme (admin)
      (function(){
        try{
          const root = document.documentElement;
          const saved = localStorage.getItem('theme');
          if (saved === 'dark') {
            root.classList.add('dark');
          } else if (saved === 'light') {
            root.classList.remove('dark');
          } else {
            const prefers = window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches;
            if (prefers) root.classList.add('dark'); else root.classList.remove('dark');
          }
        }catch(e){}
      })();
      function applyThemeMeta(dark){
        const metaTags = document.querySelectorAll('meta[name="theme-color"]');
        metaTags.forEach(m => { if (!m.getAttribute('media')) m.setAttribute('content', dark ? '#0f172a' : '#ffffff'); });
      }
      window.toggleTheme = function(){
        try{
          const root = document.documentElement;
          const nowDark = root.classList.toggle('dark');
          localStorage.setItem('theme', nowDark ? 'dark' : 'light');
          applyThemeMeta(nowDark);
        }catch(e){}
      };
      document.addEventListener('DOMContentLoaded', function(){
        applyThemeMeta(document.documentElement.classList.contains('dark'));
      });
    </script>

    @php
      $viteHot = file_exists(public_path('hot'));
      $viteManifest = file_exists(public_path('build/manifest.json'));
    @endphp
    @if($viteHot || $viteManifest)
      @vite(['resources/css/app.css', 'resources/js/admin.js'])
    @else
      <link rel="stylesheet" href="https://unpkg.com/aos@2.3.4/dist/aos.css">
      <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
      <script src="https://unpkg.com/lucide@0.469.0/dist/umd/lucide.js"></script>
      <script src="https://unpkg.com/aos@2.3.4/dist/aos.js"></script>
      <script>
        window.addEventListener('load', function(){
          try { window.lucide && window.lucide.createIcons?.({ icons: window.lucide.icons }); } catch(e) {}
          try { window.AOS && window.AOS.init?.({ once: true, duration: 300 }); } catch(e) {}
        });
      </script>
    @endif
  </head>
  <body class="font-sans antialiased bg-slate-50 dark:bg-slate-950 text-slate-900 dark:text-slate-100">
    <div x-data="{ open: false, collapsed: false }" x-init="(() => { try { collapsed = localStorage.getItem('admin:sidebar') === 'collapsed' } catch(e){} })()" class="min-h-screen flex">
      <!-- Sidebar -->
  <aside :class="collapsed ? 'w-16' : 'w-64'" class="hidden md:flex transition-[width] duration-200 border-r border-white/30 dark:border-slate-700/50 bg-white/80 dark:bg-slate-900/80 backdrop-blur supports-[backdrop-filter]:bg-white/60 dark:supports-[backdrop-filter]:bg-slate-900/60">
        <x-admin.sidebar />
      </aside>

      <!-- Mobile Sidebar Overlay -->
  <div class="md:hidden fixed inset-0 z-40 bg-black/40" x-show="open" x-transition.opacity @click="open=false"></div>
      <aside class="md:hidden fixed inset-y-0 left-0 z-50 w-72 border-r border-white/30 dark:border-slate-700/50 bg-white dark:bg-slate-900" x-show="open" x-transition @keydown.escape.window="open=false" role="dialog" aria-modal="true">
        <x-admin.sidebar />
      </aside>

      <!-- Main Content -->
    <div class="flex-1 min-w-0 flex flex-col">
        <!-- Topbar -->
        <x-admin.topbar>
          <button class="md:hidden inline-flex items-center justify-center w-10 h-10 rounded hover:bg-slate-100 dark:hover:bg-slate-800" @click="open = true" aria-label="Open menu">
            <i data-lucide="menu" class="w-5 h-5"></i>
          </button>
      <button class="hidden md:inline-flex items-center gap-2 px-3 py-2 rounded hover:bg-slate-100 dark:hover:bg-slate-800" @click="collapsed=!collapsed; localStorage.setItem('admin:sidebar', collapsed ? 'collapsed' : 'expanded')" aria-label="Toggle sidebar">
            <i data-lucide="panel-left" class="w-4 h-4"></i>
            <span class="text-sm">Sidebar</span>
          </button>
        </x-admin.topbar>

        <!-- Page Heading -->
        @if(isset($header) || $__env->hasSection('header'))
          <header class="px-4 sm:px-6 lg:px-8 py-4 border-b border-white/30 dark:border-slate-700/50 space-y-3">
            @hasSection('header')
              @yield('header')
            @elseif(isset($header))
              {{ $header }}
            @endif
            @if(session('status'))
              <x-toast type="success" :message="session('status')" />
            @endif
            @if(isset($errors) && $errors->any())
              <x-toast type="error">
                <ul class="list-disc pl-5">
                  @foreach($errors->all() as $e)
                    <li>{{ $e }}</li>
                  @endforeach
                </ul>
              </x-toast>
            @endif
          </header>
        @endif

        <!-- Page Content -->
        <main class="flex-1 px-4 sm:px-6 lg:px-8 py-6">
          @hasSection('content')
            @yield('content')
          @else
            {{ $slot ?? '' }}
          @endif
        </main>
      </div>
    </div>
  </body>
  @stack('scripts')
  <!-- Tailwind/Alpine/Lucide CDN fallbacks removed to enforce strict CSP. All assets must be bundled. -->
</html>
