<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ config('app.name', 'Laravel') }}</title>

    <!-- Icons / Favicons -->
    <link rel="apple-touch-icon" sizes="180x180" href="{{ asset('icons/apple-touch-icon-180.png') }}">
    <link rel="icon" type="image/png" sizes="32x32" href="{{ asset('icons/favicon-32x32.png') }}">
    <link rel="icon" type="image/png" sizes="16x16" href="{{ asset('icons/favicon-16x16.png') }}">
    <link rel="alternate icon" type="image/png" sizes="32x32" href="{{ asset('icons/icon-32.png') }}">
    <link rel="alternate icon" type="image/png" sizes="16x16" href="{{ asset('icons/icon-16.png') }}">
    <link rel="shortcut icon" href="{{ asset('icons/favicon-32x32.png') }}">

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Scripts: Vite with safe fallback if manifest is missing -->
        @php
            $viteHot = file_exists(public_path('hot'));
            $viteManifest = file_exists(public_path('build/manifest.json'));
        @endphp
        <!-- Always-on critical baseline so pages are styled even if Vite/Tailwind build is missing -->
    <style nonce="{{ $cspNonce ?? '' }}">
            :root { --brand-primary:#0077c8; --brand-primary-accent:#0069b0; --brand-secondary:#ff6a33; --brand-secondary-accent:#ee5920; --brand-danger:#dc2626; --color-bg:#f9f9f7; --color-surface:#ffffff; --color-surface-alt:#f2f4f7; --color-text:#1e293b; --color-text-muted:#64748b; --color-border:rgba(15,23,42,.12); }
            body { background:var(--color-bg); color:var(--color-text); font-family: system-ui,-apple-system,'Figtree',sans-serif; line-height:1.45; }
            .auth-card, .panel-soft { background:rgba(255,255,255,0.92); backdrop-filter:blur(6px); border:1px solid var(--color-border); border-radius:1rem; box-shadow:0 4px 14px -4px rgba(0,0,0,.12),0 2px 6px -2px rgba(0,0,0,.06); }
            .form-stack { display:flex; flex-direction:column; gap:1.05rem; }
            .form-group { display:flex; flex-direction:column; gap:.45rem; }
            .form-label { font-size:.7rem; font-weight:600; letter-spacing:.05em; text-transform:uppercase; color:var(--color-text-muted); }
            .form-error { font-size:.65rem; color:var(--brand-danger); }
            .input { width:100%; background:var(--color-surface-alt); border:1px solid var(--color-border); border-radius:.65rem; padding:.6rem .75rem; font-size:.875rem; }
            .input:focus { outline:2px solid var(--brand-primary); outline-offset:1px; }
            .btn { display:inline-flex; align-items:center; justify-content:center; gap:.5rem; font-weight:600; padding:.65rem 1rem; font-size:.875rem; border-radius:.75rem; border:1px solid transparent; cursor:pointer; text-decoration:none; line-height:1.25; transition:.25s; }
            .btn-primary { background:linear-gradient(90deg,var(--brand-primary),var(--brand-primary-accent)); color:#fff; }
            .btn-primary:hover { filter:brightness(1.05); }
            .btn-outline { background:transparent; border:1px solid var(--color-border); color:var(--color-text); }
            .btn-outline:hover { background:var(--color-surface-alt); }
            .btn-danger { background:var(--brand-danger); color:#fff; }
            .auth-actions { display:flex; flex-direction:column; gap:.75rem; margin-top:.75rem; }
            @media (min-width:480px){ .auth-actions { flex-direction:row; align-items:center; } }
            .heading-auth, .text-3xl { font-size:1.9rem; font-weight:800; letter-spacing:-.02em; line-height:1.15; margin:0 0 .6rem; }
            @media (min-width:640px){ .heading-auth, .text-3xl { font-size:2.15rem; } }
            .auth-subtext, .text-sm { font-size:.82rem; color:var(--color-text-muted); }
        </style>
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    </head>
    <body class="font-sans antialiased bg-app text-[rgb(var(--color-text))]">
        <div class="min-h-screen flex flex-col items-center justify-center relative py-10 px-4">
            <div aria-hidden="true" class="pointer-events-none absolute inset-0 overflow-hidden">
                <div class="absolute -top-32 -left-32 h-72 w-72 bg-gradient-to-tr from-indigo-400/25 via-emerald-300/25 to-cyan-300/25 blur-3xl rounded-full"></div>
                <div class="absolute -bottom-32 -right-32 h-80 w-80 bg-gradient-to-tr from-amber-300/30 via-pink-300/20 to-indigo-300/25 blur-3xl rounded-full"></div>
            </div>
            <a href="/" class="mb-6 inline-flex items-center gap-2 font-semibold text-primary">
                <x-application-logo class="w-12 h-12" />
                <span class="text-lg">{{ config('app.name', 'Bonny Delight') }}</span>
            </a>
            <div class="w-full max-w-md auth-card rounded-xl p-6 relative">
                {{ $slot }}
            </div>
        </div>
    </body>
</html>
