<nav x-data="{ open: false }" class="nav-bar sticky top-0 z-40">
    <!-- Primary Navigation Menu -->
    <div class="container-px max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between h-16">
            <div class="flex">
                <!-- Logo -->
                <div class="shrink-0 flex items-center">
                    <a href="{{ route('home') }}">
                        <x-application-logo class="block h-9 w-auto fill-current text-gray-800 dark:text-gray-200" />
                    </a>
                </div>

                <!-- Navigation Links -->
                <div class="hidden space-x-3 sm:-my-px sm:ms-10 sm:flex">
                    <x-nav-link :href="route('home')" :active="request()->routeIs('home')" class="group">
                        <i data-lucide="home" class="inline-block w-4 h-4 me-1 align-[-2px]"></i>
                        <span class="group-hover:translate-x-0.5 transition">{{ __('Home') }}</span>
                    </x-nav-link>
                    @auth
                        <x-nav-link :href="route('dashboard')" :active="request()->routeIs('dashboard')" class="group">
                            <i data-lucide="layout-dashboard" class="inline-block w-4 h-4 me-1 align-[-2px]"></i>
                            <span class="group-hover:translate-x-0.5 transition">Dashboard</span>
                        </x-nav-link>
                    @endauth
                    <x-nav-link :href="route('menu.index')" :active="request()->routeIs('menu.*')" class="group">
                        <i data-lucide="utensils" class="inline-block w-4 h-4 me-1 align-[-2px]"></i>
                        <span class="group-hover:translate-x-0.5 transition">{{ __('Menu') }}</span>
                    </x-nav-link>
                    <x-nav-link :href="route('contact.show')" :active="request()->routeIs('contact.*')" class="group">
                        <i data-lucide="phone" class="inline-block w-4 h-4 me-1 align-[-2px]"></i>
                        <span class="group-hover:translate-x-0.5 transition">{{ __('Contact') }}</span>
                    </x-nav-link>
                    <x-nav-link :href="route('cart.index')" :active="request()->routeIs('cart.*')" class="group relative" id="nav-cart-link">
                        <i data-lucide="shopping-cart" class="inline-block w-4 h-4 me-1 align-[-2px]"></i>
                        <span class="group-hover:translate-x-0.5 transition">{{ __('Cart') }}</span>
                        @php
                            $items = session('cart.items', []);
                            $count = 0;
                            if (is_array($items)) {
                                foreach ($items as $it) {
                                    // support structures like ['qty'=>x] or raw numeric values
                                    if (is_array($it) && isset($it['qty'])) { $count += (int) $it['qty']; }
                                    elseif (is_numeric($it)) { $count += (int) $it; }
                                }
                            }
                        @endphp
                        @if($count)
                            <span id="nav-cart-count" class="absolute -top-2 -right-3 text-[10px] bg-indigo-600 text-white rounded-full px-1.5 py-0.5 animate-[bounce_1.5s_infinite]">{{ $count }}</span>
                        @else
                            <span id="nav-cart-count" class="hidden absolute -top-2 -right-3 text-[10px] bg-indigo-600 text-white rounded-full px-1.5 py-0.5">0</span>
                        @endif
                    </x-nav-link>
                    @auth
                        <x-nav-link :href="route('orders.index')" :active="request()->routeIs('orders.*')" class="group">
                            <i data-lucide="receipt" class="inline-block w-4 h-4 me-1 align-[-2px]"></i>
                            <span class="group-hover:translate-x-0.5 transition">{{ __('My Orders') }}</span>
                        </x-nav-link>
                            <x-nav-link :href="route('account.addresses.index')" :active="request()->routeIs('account.addresses.*')" class="group">
                                <i data-lucide="map-pin" class="inline-block w-4 h-4 me-1 align-[-2px]"></i>
                                <span class="group-hover:translate-x-0.5 transition">{{ __('Addresses') }}</span>
                            </x-nav-link>
                    @endauth
                </div>
            </div>

            <!-- Settings Dropdown / Guest Links -->
            <div class="hidden sm:flex sm:items-center sm:ms-6">
                <button type="button" onclick="toggleTheme()" class="nav-pill" title="Toggle theme">
                    <i data-lucide="sun" data-theme-icon="sun" class="w-4 h-4 dark:hidden"></i>
                    <i data-lucide="moon" data-theme-icon="moon" class="w-4 h-4 hidden dark:inline"></i>
                </button>
                @auth
                    <x-dropdown align="right" width="48">
                        <x-slot name="trigger">
                            <button class="nav-pill nav-pill-active">
                                <div>{{ optional(Auth::user())->display_name ?? 'Account' }}</div>
                                <i data-lucide="chevron-down" class="w-4 h-4"></i>
                            </button>
                        </x-slot>

                        <x-slot name="content">
                            <x-dropdown-link :href="route('profile.edit')">
                                {{ __('Profile') }}
                            </x-dropdown-link>

                            <!-- Authentication -->
                            <x-dropdown-link :href="route('logout.get')">
                                {{ __('Log Out') }}
                            </x-dropdown-link>
                        </x-slot>
                    </x-dropdown>
                @endauth
                @guest
                    <div class="flex items-center gap-3">
                        <a href="{{ route('login') }}" class="text-sm font-medium text-gray-700 dark:text-gray-300 hover:underline">{{ __('Log in') }}</a>
                        <a href="{{ route('register') }}" class="btn-primary inline-flex items-center px-3 py-2 text-sm">{{ __('Register') }}</a>
                    </div>
                @endguest
            </div>

            <!-- Hamburger -->
            <div class="-me-2 flex items-center sm:hidden">
                <button @click="open = ! open" class="nav-pill">
                    <svg class="h-6 w-6" stroke="currentColor" fill="none" viewBox="0 0 24 24">
                        <path :class="{'hidden': open, 'inline-flex': ! open }" class="inline-flex" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        <path :class="{'hidden': ! open, 'inline-flex': open }" class="hidden" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
        </div>
    </div>

    <!-- Responsive Navigation Menu -->
    <div :class="{'block': open, 'hidden': ! open}" class="hidden sm:hidden">
        <div class="pt-2 pb-3 space-y-1">
            <x-responsive-nav-link :href="route('home')" :active="request()->routeIs('home') || request()->is('/')">
                {{ __('Home') }}
            </x-responsive-nav-link>
            @auth
                <x-responsive-nav-link :href="route('dashboard')" :active="request()->routeIs('dashboard')">
                    Dashboard
                </x-responsive-nav-link>
            @endauth
            <x-responsive-nav-link :href="route('menu.index')" :active="request()->routeIs('menu.*')">
                {{ __('Menu') }}
            </x-responsive-nav-link>
            <x-responsive-nav-link :href="route('contact.show')" :active="request()->routeIs('contact.*')">
                {{ __('Contact') }}
            </x-responsive-nav-link>
            <x-responsive-nav-link :href="route('cart.index')" :active="request()->routeIs('cart.*')">
                {{ __('Cart') }}
            </x-responsive-nav-link>
            @auth
                <x-responsive-nav-link :href="route('orders.index')" :active="request()->routeIs('orders.*')">
                    {{ __('My Orders') }}
                </x-responsive-nav-link>
                    <x-responsive-nav-link :href="route('account.addresses.index')" :active="request()->routeIs('account.addresses.*')">
                        {{ __('Addresses') }}
                    </x-responsive-nav-link>
            @endauth
        </div>

        <!-- Responsive Settings Options -->
        @auth
        <div class="pt-4 pb-1 border-t border-white/30 dark:border-slate-700/50">
                <div class="px-4">
                    <div class="font-medium text-base text-gray-800 dark:text-gray-200">{{ optional(Auth::user())->display_name ?? 'Account' }}</div>
                    <div class="font-medium text-sm text-gray-500">{{ optional(Auth::user())->email ?? '' }}</div>
                </div>

                <div class="mt-3 space-y-1">
                    <x-responsive-nav-link :href="route('profile.edit')">
                        {{ __('Profile') }}
                    </x-responsive-nav-link>

                    <!-- Authentication -->
                    <x-responsive-nav-link :href="route('logout.get')">
                        {{ __('Log Out') }}
                    </x-responsive-nav-link>
                </div>
            </div>
        @endauth
        @guest
        <div class="pt-4 pb-1 border-t border-white/30 dark:border-slate-700/50">
            <div class="mt-3 space-y-1">
                <x-responsive-nav-link :href="route('login')">
                    {{ __('Log in') }}
                </x-responsive-nav-link>
                <x-responsive-nav-link :href="route('register')">
                    {{ __('Register') }}
                </x-responsive-nav-link>
            </div>
        </div>
        @endguest
    </div>
</nav>
