<x-app-layout>
    @push('head')
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link rel="preload" as="style" href="https://fonts.googleapis.com/css2?display=swap&family=Plus+Jakarta+Sans:wght@400;500;700;800&family=Playfair+Display:wght@400;700">
        <link rel="stylesheet" href="https://fonts.googleapis.com/css2?display=swap&family=Plus+Jakarta+Sans:wght@400;500;700;800&family=Playfair+Display:wght@400;700" media="print" onload="this.media='all'">
        <style>
            .font-display{ font-family:"Playfair Display",serif; }
            .no-scrollbar::-webkit-scrollbar{ display:none; }
            .no-scrollbar{ -ms-overflow-style:none; scrollbar-width:none; }
        </style>
    @endpush

    <div class="bg-app">
        <a href="#all" class="sr-only focus:not-sr-only focus:absolute focus:top-16 focus:left-4 bg-white px-3 py-2 rounded shadow">Skip to menu</a>
        <div class="container-px py-10">
            @if(!empty($dbUnavailable))
                <div class="mb-6 rounded-lg border border-amber-300/60 bg-amber-50 text-amber-900 dark:border-amber-800 dark:bg-amber-900/20 dark:text-amber-200 px-4 py-3 flex items-start gap-3">
                    <i data-lucide="triangle-alert" class="w-5 h-5 mt-0.5"></i>
                    <div>
                        <div class="font-semibold">Some data is temporarily unavailable</div>
                        <p class="text-sm opacity-90">We couldn’t reach the database right now. You can still browse the site; menu items may be limited until the connection is restored.</p>
                    </div>
                </div>
            @endif
            <div class="text-center mb-10">
                <h1 class="heading-display text-4xl md:text-5xl font-bold">Explore Our Menu</h1>
                <p class="mt-4 text-lg text-muted max-w-2xl mx-auto">Discover a variety of delicious dishes, crafted with the freshest ingredients and culinary passion.</p>
            </div>

            <!-- Categories Pills -->
            <div class="sticky top-16 z-30 bg-app/80 backdrop-blur py-3 mb-6" role="navigation" aria-label="Menu categories">
                <div class="relative">
                    <div class="flex items-center overflow-x-auto pb-3 -mx-4 px-4 no-scrollbar">
                        <div class="flex items-center gap-2 whitespace-nowrap">
                            @php $sel = $selectedCategory ?? null; @endphp
                            <a href="#all" class="pill-filter {{ $sel ? '' : 'pill-filter-active' }}">All</a>
                            @foreach($categories as $cat)
                                @php $is = $sel && strcasecmp($sel, $cat->name) === 0; @endphp
                                <a href="#cat-{{ $cat->id }}" class="pill-filter {{ $is ? 'pill-filter-active' : '' }}">{{ $cat->name }}</a>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>

            <!-- Menu Grid per Category -->
            <div id="all" class="space-y-12" role="main" aria-label="Menu">
                @if(($categories ?? collect())->isEmpty())
                    <div class="text-center py-16">
                        <div class="mx-auto w-12 h-12 rounded-full bg-slate-200 dark:bg-slate-800 flex items-center justify-center mb-3">
                            <i data-lucide="utensils" class="w-6 h-6 text-slate-600 dark:text-slate-300"></i>
                        </div>
                        <h2 class="text-xl font-semibold mb-2">No menu items to display</h2>
                        <p class="text-sm text-muted max-w-md mx-auto">This can happen if the connection to the kitchen database is offline. Please try again in a moment.</p>
                    </div>
                @endif
                @foreach($categories as $category)
                    <section id="cat-{{ $category->id }}" class="scroll-mt-24" data-aos="fade-up">
                        <div class="flex items-center gap-3 mb-4">
                            <svg class="h-6 w-6 text-primary" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true"><path d="M3 3h7v7h7v7h4v4H3V3z"/></svg>
                            <h2 class="font-display text-2xl font-bold">{{ $category->name }}</h2>
                        </div>
                        @if($category->dishes->count())
                            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6">
                                @foreach($category->dishes as $dish)
                                    @php $out = \Illuminate\Support\Facades\Schema::hasColumn('dishes','stock') && isset($dish->stock) ? ((int)$dish->stock <= 0) : false; @endphp
                                    <div class="group card" data-aos="zoom-in">
                                        <div class="relative h-56">
                                            @php
                                                $public = $dish->public_image_url;
                                                $src = $public ?: asset('assets/placeholders/dish-placeholder.svg');
                                                $base = $dish->image_base;
                                                $manifestEntry = $base ? App\Support\ImageManifest::find('dish', $base) : null;
                                            @endphp
                                            @if($base && $manifestEntry)
                                                <x-responsive-image type="dish" :base="$base" :alt="$dish->name" class="w-full h-full object-cover transition-transform duration-300 group-hover:scale-110" sizes="(max-width:768px) 100vw, 320px" :fallback="$src" />
                                            @else
                                                <img src="{{ $src }}" alt="{{ $dish->name }}" class="w-full h-full object-cover transition-transform duration-300 group-hover:scale-110" width="640" height="320" loading="lazy" />
                                            @endif
                                            <div class="absolute inset-0 bg-gradient-to-t from-black/55 to-transparent"></div>
                                            @if($out)
                                                <div class="absolute inset-0 bg-black/60 flex items-center justify-center">
                                                    <span class="text-white font-bold text-sm uppercase tracking-wider">Out of Stock</span>
                                                </div>
                                            @endif
                                        </div>
                                        <div class="p-5 flex flex-col flex-grow {{ $out ? 'opacity-60' : '' }}">
                                            <h3 class="font-display text-xl font-bold mb-1">{{ $dish->name }}</h3>
                                            @if($dish->description)
                                                <p class="text-sm text-muted mb-4 flex-grow">{{ $dish->description }}</p>
                                            @endif
                                            <div class="flex items-center justify-between">
                                                <p class="text-2xl font-bold text-primary">₦{{ number_format((float)$dish->price, 2) }}</p>
                                                <form method="POST" action="{{ route('cart.add') }}">
                                                    @csrf
                                                    <input type="hidden" name="dish_id" value="{{ $dish->id }}">
                                                    <input type="hidden" name="quantity" value="1">
                                                    <button type="submit" {{ $out ? 'disabled' : '' }} class="flex items-center justify-center size-12 rounded-full {{ $out ? 'bg-gray-300 text-gray-500 cursor-not-allowed' : 'bg-primary text-white shadow-lg hover:brightness-110 transition-all transform group-hover:scale-110' }}">
                                                        <span class="sr-only">Add to cart</span>
                                                        <i data-lucide="plus" class="w-5 h-5"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @else
                            <p class="text-sm text-gray-600">No dishes in this category yet.</p>
                        @endif
                    </section>
                @endforeach
            </div>
            @push('head')
            <script>
                window.addEventListener('load', () => {
                    try {
                        const params = new URLSearchParams(window.location.search);
                        const sel = params.get('category');
                        if (sel) {
                            const pill = Array.from(document.querySelectorAll('[role="navigation"] a'))
                                .find(a => a.textContent.trim().toLowerCase() === sel.trim().toLowerCase());
                            if (pill) pill.scrollIntoView({ inline:'center', block:'nearest' });
                            const section = document.querySelector('[id^="cat-"]');
                            // If a selected pill exists, jump to its target section
                            const target = pill?.getAttribute('href');
                            if (target && target.startsWith('#')) {
                                const el = document.querySelector(target);
                                el?.scrollIntoView({ behavior: 'smooth', block: 'start' });
                            }
                        }
                    } catch(_) {}
                });
            </script>
            @endpush
        </div>
    </div>
</x-app-layout>
<x-customer.mobile-bar />
