<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
                {{ __('My Orders') }}
            </h2>
            <a href="{{ route('menu.index') }}" class="btn btn-primary hidden sm:inline-flex">{{ __('Start Order') }}</a>
        </div>
    </x-slot>

    <div class="py-6">
        <div class="container-px max-w-6xl">
            <div class="surface rounded-xl overflow-hidden">
                <div class="p-6 space-y-4">
                    <!-- Tabs + Search -->
                    <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-3">
                        @php $tabs = [
                            'all' => __('All'),
                            'active' => __('Active'),
                            'completed' => __('Completed'),
                            'cancelled' => __('Cancelled'),
                        ]; @endphp
                        <div class="inline-flex rounded-lg ring-1 ring-black/10 overflow-hidden">
                            @foreach($tabs as $key=>$label)
                                <a href="{{ route('orders.index', array_merge(request()->except('page'), ['status'=>$key ?: null])) }}"
                                   class="px-3 py-2 text-sm {{ ($currentTab ?? 'all') === $key ? 'bg-primary text-white' : 'bg-white dark:bg-slate-800 hover:bg-slate-50 dark:hover:bg-slate-700' }}">
                                    {{ $label }}
                                </a>
                            @endforeach
                        </div>
                        <form method="GET" action="{{ route('orders.index') }}" class="relative">
                            @foreach(request()->except(['q','page']) as $k=>$v)
                                <input type="hidden" name="{{ $k }}" value="{{ $v }}">
                            @endforeach
                            <input type="search" name="q" value="{{ $q ?? '' }}" placeholder="{{ __('Search by Order #') }}" class="input input-bordered md:w-64">
                            @if(($q ?? '') !== '')
                                <button type="button" onclick="this.form.q.value='';this.form.submit();" class="absolute right-2 top-1/2 -translate-y-1/2 text-slate-500 hover:text-slate-700">×</button>
                            @endif
                        </form>
                    </div>
                    @isset($dbUnavailable)
                        @if($dbUnavailable)
                            <div class="mb-4 rounded-md border border-amber-300/60 bg-amber-50 text-amber-900 dark:bg-amber-950/40 dark:text-amber-200 p-3">
                                {{ __('orders.order_history_unavailable') }}
                            </div>
                        @endif
                    @endisset
                    @if($orders->count() === 0)
                        <p>{{ __('You have not placed any orders yet.') }}</p>
                    @else
                        <div class="overflow-x-auto rounded-lg border border-subtle">
                            <table class="min-w-full text-sm">
                                <thead class="sticky top-0 z-10 bg-app-alt/95 dark:bg-slate-900/90 backdrop-blur text-xs uppercase tracking-wide text-muted">
                                    <tr class="text-[11px]">
                                        <th class="px-4 py-2 font-semibold text-left">{{ __('#') }}</th>
                                        <th class="px-4 py-2 font-semibold text-left">{{ __('Date') }}</th>
                                        <th class="px-4 py-2 font-semibold text-left">{{ __('Total') }}</th>
                                        <th class="px-4 py-2 font-semibold text-left">{{ __('Status') }}</th>
                                        <th class="px-4 py-2"><span class="sr-only">{{ __('Actions') }}</span></th>
                                    </tr>
                                </thead>
                                <tbody class="divide-y divide-gray-100/70 dark:divide-slate-700/60">
                                    @foreach($orders as $order)
                                        <tr>
                                            <td class="px-4 py-2">#{{ $order->id }}</td>
                                            <td class="px-4 py-2">{{ $order->created_at->format('d M Y H:i') }}</td>
                                            <td class="px-4 py-2">₦{{ number_format((float)$order->total, 2) }}</td>
                                            <td class="px-4 py-2"><x-status-badge :status="$order->status" /></td>
                                            <td class="px-4 py-2 text-right">
                                                <a href="{{ route('orders.show', $order) }}" class="btn btn-outline text-xs">{{ __('View') }}</a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <div class="mt-4">{{ $orders->links() }}</div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
<x-customer.mobile-bar />
