<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Order') }} #{{ $order->id }}
        </h2>
    </x-slot>

    <div class="py-6">
        <div class="container-px max-w-4xl">
            <div class="surface rounded-xl overflow-hidden">
                <div class="p-6">
                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                        <div>
                            <div class="text-sm text-muted">{{ __('Status') }}</div>
                            <div class="font-semibold"><x-status-badge :status="$order->status" /></div>
                        </div>
                        <div>
                            <div class="text-sm text-muted">{{ __('Payment method') }}</div>
                            <div class="font-semibold">{{ $order->payment_method }}</div>
                        </div>
                        <div>
                            <div class="text-sm text-muted">{{ __('Placed on') }}</div>
                            <div class="font-semibold">{{ $order->created_at->format('d M Y H:i') }}</div>
                        </div>
                        <div>
                            <div class="text-sm text-muted">{{ __('Delivery address') }}</div>
                            <div class="font-semibold">
                                    <div>{{ $order->display_delivery_address ?? '—' }}</div>
                            </div>
                        </div>
                    </div>

                    <h3 class="mt-6 mb-2 font-semibold">{{ __('Items') }}</h3>
                    <div class="overflow-x-auto mt-4 rounded-lg border border-subtle">
                        <table class="min-w-full text-sm">
                            <thead class="bg-white/70 dark:bg-slate-900/60 backdrop-blur">
                                <tr>
                                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">{{ __('Item') }}</th>
                                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">{{ __('Qty') }}</th>
                                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">{{ __('Price') }}</th>
                                    <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">{{ __('Total') }}</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-100/70 dark:divide-slate-700/60">
                                @foreach($order->items as $item)
                                    <tr>
                                        <td class="px-4 py-2">{{ $item->dish->name ?? ('#'.$item->dish_id) }}</td>
                                        <td class="px-4 py-2">{{ $item->quantity }}</td>
                                        <td class="px-4 py-2">₦{{ number_format((float)$item->price, 2) }}</td>
                                        <td class="px-4 py-2 text-right">₦{{ number_format((float)$item->price * (int)$item->quantity, 2) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-6 grid grid-cols-1 sm:grid-cols-3 gap-4 text-sm">
                        <div>
                            <div class="text-sm text-muted">{{ __('Subtotal') }}</div>
                            <div class="font-semibold">₦{{ number_format((float)$order->subtotal, 2) }}</div>
                        </div>
                        <div>
                            <div class="text-sm text-muted">{{ __('Delivery fee') }}</div>
                            <div class="font-semibold">₦{{ number_format((float)$order->delivery_fee, 2) }}</div>
                        </div>
                        <div>
                            <div class="text-sm text-muted">{{ __('Discount') }}</div>
                            <div class="font-semibold">₦{{ number_format((float)$order->discount, 2) }}</div>
                        </div>
                    </div>

                    <div class="mt-6 text-right text-lg font-bold">{{ __('Total') }}: ₦{{ number_format((float)$order->total, 2) }}</div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
<x-customer.mobile-bar />
