@extends('super-admin.layout')

@section('title', 'Super Admin Dashboard')
@section('subtitle', 'Comprehensive business overview and key metrics')

@section('content')
<div class="space-y-6">
    <!-- Key Metrics -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-6">
        <div class="surface rounded-xl p-6">
            <div class="flex items-center">
                <div class="p-2 bg-blue-500/10 rounded-lg">
                    <svg class="w-6 h-6 text-blue-600 dark:text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                    </svg>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-muted">Total Users</p>
                    <p class="text-2xl font-bold text-primary">{{ number_format($totalUsers) }}</p>
                    @if($userGrowth != 0)
                        <p class="text-sm {{ $userGrowth > 0 ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400' }}">
                            {{ $userGrowth > 0 ? '+' : '' }}{{ number_format($userGrowth, 1) }}% from last month
                        </p>
                    @endif
                </div>
            </div>
        </div>

        <div class="surface rounded-xl p-6">
            <div class="flex items-center">
                <div class="p-2 bg-purple-500/10 rounded-lg">
                    <svg class="w-6 h-6 text-purple-600 dark:text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>
                    </svg>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-muted">Admin Users</p>
                    <p class="text-2xl font-bold text-primary">{{ number_format($totalAdmins) }}</p>
                    <p class="text-sm text-muted">{{ number_format(($totalAdmins/$totalUsers)*100, 1) }}% of total</p>
                </div>
            </div>
        </div>

        <div class="surface rounded-xl p-6">
            <div class="flex items-center">
                <div class="p-2 bg-green-500/10 rounded-lg">
                    <svg class="w-6 h-6 text-green-600 dark:text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                    </svg>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-muted">Total Revenue</p>
                    <p class="text-2xl font-bold text-primary">₦{{ number_format($totalRevenue, 2) }}</p>
                    @if($revenueGrowth != 0)
                        <p class="text-sm {{ $revenueGrowth > 0 ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400' }}">
                            {{ $revenueGrowth > 0 ? '+' : '' }}{{ number_format($revenueGrowth, 1) }}% from last month
                        </p>
                    @endif
                </div>
            </div>
        </div>

        <div class="surface rounded-xl p-6">
            <div class="flex items-center">
                <div class="p-2 bg-orange-500/10 rounded-lg">
                    <svg class="w-6 h-6 text-orange-600 dark:text-orange-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                    </svg>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-muted">Total Orders</p>
                    <p class="text-2xl font-bold text-primary">{{ number_format($totalOrders) }}</p>
                    <p class="text-sm text-muted">All time</p>
                </div>
            </div>
        </div>

        <div class="surface rounded-xl p-6">
            <div class="flex items-center">
                <div class="p-2 bg-red-500/10 rounded-lg">
                    <svg class="w-6 h-6 text-red-600 dark:text-red-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6V4m0 2a2 2 0 100 4m0-4a2 2 0 110 4m-6 8a2 2 0 100-4m0 4a2 2 0 100 4m0-4v2m0-6V4m6 6v10m6-2a2 2 0 100-4m0 4a2 2 0 100 4m0-4v2m0-6V4"></path>
                    </svg>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-muted">Total Dishes</p>
                    <p class="text-2xl font-bold text-primary">{{ number_format($totalDishes) }}</p>
                    <p class="text-sm text-muted">Menu items</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts Row -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Daily Revenue Chart -->
        <div class="surface rounded-xl p-6">
            <h3 class="text-lg font-semibold text-primary mb-4">Daily Revenue (Last 30 Days)</h3>
            <div class="relative h-80">
                <canvas id="revenueChart"></canvas>
            </div>
        </div>

        <!-- Top Dishes Chart -->
        <div class="surface rounded-xl p-6">
            <h3 class="text-lg font-semibold text-primary mb-4">Top Selling Dishes</h3>
            <div class="relative h-80">
                <canvas id="dishesChart"></canvas>
            </div>
        </div>
    </div>

    <!-- Tables Row -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Recent Users -->
        <div class="surface rounded-xl">
            <div class="p-6 border-b border-soft">
                <h3 class="text-lg font-semibold text-primary">Recent Users</h3>
            </div>
            <div class="p-6">
                <div class="space-y-4">
                    @forelse($recentUsers as $user)
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="font-medium text-primary">{{ $user->name }}</p>
                                <p class="text-sm text-muted">{{ $user->email }}</p>
                            </div>
                            <div class="text-right">
                                <p class="text-sm text-muted">{{ $user->created_at->diffForHumans() }}</p>
                                @if($user->hasRole('Admin'))
                                    <span class="badge bg-purple-500/10 text-purple-600 dark:text-purple-400">Admin</span>
                                @elseif($user->hasRole('Super Admin'))
                                    <span class="badge bg-indigo-500/10 text-indigo-600 dark:text-indigo-400">Super Admin</span>
                                @else
                                    <span class="badge">Customer</span>
                                @endif
                            </div>
                        </div>
                    @empty
                        <p class="text-muted">No recent users</p>
                    @endforelse
                </div>
                <div class="mt-4">
                    <a href="{{ route('super-admin.users.index') }}" class="text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 text-sm font-medium transition-colors">View all users →</a>
                </div>
            </div>
        </div>

        <!-- Recent Orders -->
        <div class="surface rounded-xl">
            <div class="p-6 border-b border-soft">
                <h3 class="text-lg font-semibold text-primary">Recent Orders</h3>
            </div>
            <div class="p-6">
                <div class="space-y-4">
                    @forelse($recentOrders as $order)
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="font-medium text-primary">#{{ $order->id }} - {{ $order->user->name ?? 'Guest' }}</p>
                                <p class="text-sm text-muted">{{ $order->items->count() }} items - ₦{{ number_format($order->total, 2) }}</p>
                            </div>
                            <div class="text-right">
                                <p class="text-sm text-muted">{{ $order->created_at->diffForHumans() }}</p>
                                @if($order->status === 'Delivered')
                                    <span class="badge badge-status-delivered">{{ $order->status }}</span>
                                @elseif($order->status === 'In Kitchen')
                                    <span class="badge badge-status-in-kitchen">{{ $order->status }}</span>
                                @elseif($order->status === 'Ready')
                                    <span class="badge badge-status-ready">{{ $order->status }}</span>
                                @elseif($order->status === 'Out for Delivery')
                                    <span class="badge badge-status-out">{{ $order->status }}</span>
                                @elseif($order->status === 'Cancelled')
                                    <span class="badge badge-status-cancelled">{{ $order->status }}</span>
                                @else
                                    <span class="badge badge-status-received">{{ $order->status }}</span>
                                @endif
                            </div>
                        </div>
                    @empty
                        <p class="text-muted">No recent orders</p>
                    @endforelse
                </div>
                <div class="mt-4">
                    <a href="{{ route('super-admin.admin.orders.index') }}" class="text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 text-sm font-medium transition-colors">View all orders →</a>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="surface rounded-xl p-6">
        <h3 class="text-lg font-semibold text-primary mb-4">Quick Actions</h3>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
            <a href="{{ route('super-admin.users.index') }}" class="surface-alt rounded-xl p-4 hover:shadow-md transition-all hover:-translate-y-0.5">
                <div class="flex items-center">
                    <div class="p-2 bg-indigo-500/10 rounded-lg mr-3">
                        <svg class="w-6 h-6 text-indigo-600 dark:text-indigo-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                        </svg>
                    </div>
                    <div>
                        <p class="font-medium text-primary">Manage Users</p>
                        <p class="text-sm text-muted">Assign roles & permissions</p>
                    </div>
                </div>
            </a>
            
            <a href="{{ route('super-admin.reports.index') }}" class="surface-alt rounded-xl p-4 hover:shadow-md transition-all hover:-translate-y-0.5">
                <div class="flex items-center">
                    <div class="p-2 bg-green-500/10 rounded-lg mr-3">
                        <svg class="w-6 h-6 text-green-600 dark:text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                    </div>
                    <div>
                        <p class="font-medium text-primary">Generate Reports</p>
                        <p class="text-sm text-muted">Sales, customers & products</p>
                    </div>
                </div>
            </a>
            
            <a href="{{ route('super-admin.analytics.index') }}" class="surface-alt rounded-xl p-4 hover:shadow-md transition-all hover:-translate-y-0.5">
                <div class="flex items-center">
                    <div class="p-2 bg-purple-500/10 rounded-lg mr-3">
                        <svg class="w-6 h-6 text-purple-600 dark:text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                        </svg>
                    </div>
                    <div>
                        <p class="font-medium text-primary">View Analytics</p>
                        <p class="text-sm text-muted">Deep business insights</p>
                    </div>
                </div>
            </a>
            
            <a href="{{ route('super-admin.admin.dishes.index') }}" class="surface-alt rounded-xl p-4 hover:shadow-md transition-all hover:-translate-y-0.5">
                <div class="flex items-center">
                    <div class="p-2 bg-orange-500/10 rounded-lg mr-3">
                        <svg class="w-6 h-6 text-orange-600 dark:text-orange-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6V4m0 2a2 2 0 100 4m0-4a2 2 0 110 4m-6 8a2 2 0 100-4m0 4a2 2 0 100 4m0-4v2m0-6V4m6 6v10m6-2a2 2 0 100-4m0 4a2 2 0 100 4m0-4v2m0-6V4"></path>
                        </svg>
                    </div>
                    <div>
                        <p class="font-medium text-primary">Manage Menu</p>
                        <p class="text-sm text-muted">Add, edit & organize dishes</p>
                    </div>
                </div>
            </a>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Revenue Chart
    const revenueCtx = document.getElementById('revenueChart').getContext('2d');
    const revenueData = @json($dailyOrders->pluck('revenue'));
    const revenueLabels = @json($dailyOrders->pluck('date'));
    
    new Chart(revenueCtx, {
        type: 'line',
        data: {
            labels: revenueLabels,
            datasets: [{
                label: 'Daily Revenue',
                data: revenueData,
                borderColor: 'rgb(59, 130, 246)',
                backgroundColor: 'rgba(59, 130, 246, 0.1)',
                tension: 0.1,
                fill: true
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return '₦' + value.toLocaleString('en-NG', {minimumFractionDigits: 2});
                        }
                    }
                }
            },
            plugins: {
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return 'Revenue: ₦' + context.parsed.y.toLocaleString('en-NG', {minimumFractionDigits: 2});
                        }
                    }
                }
            }
        }
    });

    // Top Dishes Chart
    const dishesCtx = document.getElementById('dishesChart').getContext('2d');
    const dishNames = @json($topDishes->take(5)->pluck('name'));
    const dishSales = @json($topDishes->take(5)->pluck('total_sold'));
    
    new Chart(dishesCtx, {
        type: 'doughnut',
        data: {
            labels: dishNames,
            datasets: [{
                data: dishSales,
                backgroundColor: [
                    'rgba(59, 130, 246, 0.8)',
                    'rgba(16, 185, 129, 0.8)',
                    'rgba(245, 158, 11, 0.8)',
                    'rgba(239, 68, 68, 0.8)',
                    'rgba(139, 92, 246, 0.8)'
                ],
                borderWidth: 2,
                borderColor: '#fff'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom'
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return context.label + ': ' + context.parsed + ' sold';
                        }
                    }
                }
            }
        }
    });
});
</script>
@endpush