<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover">
    <meta name="format-detection" content="telephone=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>Super Admin - {{ config('app.name', 'Bonny Delight') }}</title>

    <!-- Meta -->
    <meta name="description" content="Super Admin Dashboard for {{ config('app.name', 'Bonny Delight') }}">
    <meta name="application-name" content="{{ config('app.name', 'Bonny Delight') }}">
    <meta name="color-scheme" content="light dark">
    <meta name="theme-color" content="#0f172a">
    <meta name="theme-color" media="(prefers-color-scheme: light)" content="#ffffff">
    <meta name="theme-color" media="(prefers-color-scheme: dark)" content="#0f172a">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;700&family=Playfair+Display:wght@700;900&display=swap" rel="stylesheet">

    <!-- Early theme to avoid FOUC -->
    <script>
        (function(){
            try {
                const root = document.documentElement;
                const saved = localStorage.getItem('theme');
                if (saved === 'dark') {
                    root.classList.add('dark');
                } else if (saved === 'light') {
                    root.classList.remove('dark');
                } else {
                    const prefers = window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches;
                    if (prefers) root.classList.add('dark'); else root.classList.remove('dark');
                }
            } catch(e) { /* silent */ }
        })();
    </script>

    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body class="font-sans antialiased bg-slate-50 dark:bg-slate-950 text-slate-900 dark:text-slate-100">
    <div class="relative min-h-screen">
        <!-- Decorative gradients -->
        <div aria-hidden="true" class="pointer-events-none absolute inset-0 overflow-hidden">
            <div class="absolute -top-24 -left-24 h-64 w-64 rounded-full bg-gradient-to-tr from-amber-300/30 via-pink-300/20 to-indigo-300/30 blur-3xl"></div>
            <div class="absolute -bottom-24 -right-24 h-72 w-72 rounded-full bg-gradient-to-tr from-indigo-400/20 via-emerald-300/20 to-cyan-300/20 blur-3xl"></div>
        </div>

        <div class="flex min-h-screen relative">
            <!-- Sidebar -->
            <aside class="w-64 bg-slate-900/95 dark:bg-slate-900/98 backdrop-blur text-white border-r border-slate-200/10 dark:border-slate-700/50">
                <div class="p-6 border-b border-slate-200/10 dark:border-slate-700/50">
                    <h1 class="text-xl font-bold text-white">Super Admin</h1>
                    <p class="text-slate-300 text-sm mt-1">{{ auth()->user()->name }}</p>
                    <button onclick="toggleTheme()" class="mt-2 p-1.5 rounded-lg bg-slate-800/50 hover:bg-slate-700/50 transition-colors" aria-label="Toggle theme">
                        <svg class="w-4 h-4 dark:hidden" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z"></path>
                        </svg>
                        <svg class="w-4 h-4 hidden dark:block" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364 6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 0l-.707.707M6.343 17.657l-.707.707M16 12a4 4 0 11-8 0 4 4 0 018 0z"></path>
                        </svg>
                    </button>
                </div>
                
                <nav class="mt-6">
                    <div class="px-6 py-2">
                        <h3 class="text-xs font-semibold text-slate-400 uppercase tracking-widest">Dashboard</h3>
                    </div>
                    <a href="{{ route('super-admin.dashboard') }}" class="flex items-center px-6 py-3 text-slate-300 hover:bg-slate-800/50 hover:text-white transition-colors {{ request()->routeIs('super-admin.dashboard') ? 'bg-slate-800/50 text-white border-r-2 border-indigo-400' : '' }}">
                        <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z"></path>
                        </svg>
                        Overview
                    </a>
                    
                    <div class="px-6 py-2 mt-6">
                        <h3 class="text-xs font-semibold text-slate-400 uppercase tracking-widest">Management</h3>
                    </div>
                    <a href="{{ route('super-admin.users.index') }}" class="flex items-center px-6 py-3 text-slate-300 hover:bg-slate-800/50 hover:text-white transition-colors {{ request()->routeIs('super-admin.users.*') ? 'bg-slate-800/50 text-white border-r-2 border-indigo-400' : '' }}">
                        <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                        </svg>
                        User Management
                    </a>
                    
                    <div class="px-6 py-2 mt-6">
                        <h3 class="text-xs font-semibold text-slate-400 uppercase tracking-widest">Analytics</h3>
                    </div>
                    <a href="{{ route('super-admin.analytics.index') }}" class="flex items-center px-6 py-3 text-slate-300 hover:bg-slate-800/50 hover:text-white transition-colors {{ request()->routeIs('super-admin.analytics.*') ? 'bg-slate-800/50 text-white border-r-2 border-indigo-400' : '' }}">
                        <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                        </svg>
                        Business Analytics
                    </a>
                    <a href="{{ route('super-admin.reports.index') }}" class="flex items-center px-6 py-3 text-slate-300 hover:bg-slate-800/50 hover:text-white transition-colors {{ request()->routeIs('super-admin.reports.*') ? 'bg-slate-800/50 text-white border-r-2 border-indigo-400' : '' }}">
                    <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                    Reports
                </a>
                
                <div class="px-6 py-2 mt-6">
                    <h3 class="text-xs font-semibold text-slate-400 uppercase tracking-widest">Admin Tools</h3>
                </div>
                <a href="{{ route('super-admin.admin.dashboard') }}" class="flex items-center px-6 py-3 text-slate-300 hover:bg-slate-800/50 hover:text-white transition-colors">
                    <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                    </svg>
                    Admin Panel
                </a>
                <a href="{{ route('super-admin.admin.dishes.index') }}" class="flex items-center px-6 py-3 text-slate-300 hover:bg-slate-800/50 hover:text-white transition-colors">
                    <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6V4m0 2a2 2 0 100 4m0-4a2 2 0 110 4m-6 8a2 2 0 100-4m0 4a2 2 0 100 4m0-4v2m0-6V4m6 6v10m6-2a2 2 0 100-4m0 4a2 2 0 100 4m0-4v2m0-6V4"></path>
                    </svg>
                    Manage Dishes
                </a>
                <a href="{{ route('super-admin.admin.orders.index') }}" class="flex items-center px-6 py-3 text-slate-300 hover:bg-slate-800/50 hover:text-white transition-colors">
                    <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                    </svg>
                    Manage Orders
                </a>
                
                <div class="px-6 py-2 mt-6">
                    <h3 class="text-xs font-semibold text-slate-400 uppercase tracking-widest">Account</h3>
                </div>
                <a href="{{ route('home') }}" class="flex items-center px-6 py-3 text-slate-300 hover:bg-slate-800/50 hover:text-white transition-colors">
                    <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                    </svg>
                    View Site
                </a>
                <a href="{{ route('logout.get') }}" class="flex items-center w-full px-6 py-3 text-slate-300 hover:bg-red-600/50 hover:text-white transition-colors text-left">
                    <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path>
                    </svg>
                    Logout
                </a>
            </nav>
        </aside>

        <!-- Main Content -->
        <div class="lg:pl-64">
            <!-- Header -->
            <header class="bg-white/50 dark:bg-slate-800/50 backdrop-blur-xl shadow-sm border-b border-slate-200 dark:border-slate-700">
                <div class="px-6 py-4">
                    <div class="flex items-center justify-between">
                        <div>
                            <h1 class="text-2xl font-bold text-slate-900 dark:text-white">@yield('title', 'Super Admin Dashboard')</h1>
                            <p class="text-slate-600 dark:text-slate-400 mt-1">@yield('subtitle', 'Complete business oversight and management')</p>
                        </div>
                        
                        <div class="flex items-center space-x-4">
                            <!-- Mobile menu button -->
                            <button @click="sidebarOpen = !sidebarOpen" class="lg:hidden inline-flex items-center justify-center p-2 rounded-md text-slate-600 hover:text-slate-900 dark:text-slate-400 dark:hover:text-slate-200 hover:bg-slate-100 dark:hover:bg-slate-800 focus:outline-none focus:ring-2 focus:ring-inset focus:ring-orange-500">
                                <svg class="block h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                                </svg>
                            </button>
                            
                            <!-- User Menu -->
                            <div class="flex items-center space-x-3">
                                <div class="hidden md:block text-right">
                                    <p class="text-sm font-medium text-slate-900 dark:text-white">{{ auth()->user()->name }}</p>
                                    <p class="text-xs text-slate-500 dark:text-slate-400">Super Administrator</p>
                                </div>
                                <div class="w-8 h-8 bg-gradient-to-br from-orange-400 to-orange-600 rounded-full flex items-center justify-center text-white font-semibold text-sm">
                                    {{ substr(auth()->user()->name, 0, 1) }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </header>

            <!-- Content -->
            <main class="flex-1 bg-slate-50/30 dark:bg-slate-900/30 min-h-screen">
                <div class="p-6">
                    @if(session('success'))
                        <div class="mb-6 bg-emerald-50 dark:bg-emerald-900/20 border border-emerald-200 dark:border-emerald-800 rounded-lg p-4">
                            <div class="flex">
                                <div class="flex-shrink-0">
                                    <svg class="h-5 w-5 text-emerald-400" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                    </svg>
                                </div>
                                <div class="ml-3">
                                    <p class="text-sm font-medium text-emerald-800 dark:text-emerald-200">{{ session('success') }}</p>
                                </div>
                            </div>
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="mb-6 bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 rounded-lg p-4">
                            <div class="flex">
                                <div class="flex-shrink-0">
                                    <svg class="h-5 w-5 text-red-400" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"></path>
                                    </svg>
                                </div>
                                <div class="ml-3">
                                    <p class="text-sm font-medium text-red-800 dark:text-red-200">{{ session('error') }}</p>
                                </div>
                            </div>
                        </div>
                    @endif

                    @yield('content')
                </div>
            </main>
        </div>
    </div>

    <!-- Scripts -->
    @vite(['resources/js/app.js'])
    @stack('scripts')
</body>
</html>