@extends('super-admin.layout')

@section('title', 'Customer Report')
@section('subtitle', $summary['period'])

@section('content')
<div class="space-y-6">
    <!-- Report Summary -->
    <div class="surface rounded-xl p-6">
        <h3 class="text-lg font-semibold text-primary mb-4">Customer Summary</h3>
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
            <div class="text-center p-4 bg-blue-500/10 rounded-lg">
                <div class="text-2xl font-bold text-blue-600 dark:text-blue-400">{{ number_format($summary['total_customers']) }}</div>
                <div class="text-sm text-muted">Active Customers</div>
            </div>
            <div class="text-center p-4 bg-green-500/10 rounded-lg">
                <div class="text-2xl font-bold text-green-600 dark:text-green-400">{{ number_format($summary['new_customers']) }}</div>
                <div class="text-sm text-muted">New Customers</div>
            </div>
            <div class="text-center p-4 bg-purple-500/10 rounded-lg">
                <div class="text-2xl font-bold text-purple-600 dark:text-purple-400">₦{{ number_format($summary['total_revenue'], 0) }}</div>
                <div class="text-sm text-muted">Total Revenue</div>
            </div>
            <div class="text-center p-4 bg-indigo-500/10 rounded-lg">
                <div class="text-2xl font-bold text-indigo-600 dark:text-indigo-400">₦{{ number_format($summary['avg_customer_value'], 0) }}</div>
                <div class="text-sm text-muted">Avg Customer Value</div>
            </div>
        </div>
        
        <!-- Additional Metrics -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mt-6">
            <div class="text-center p-4 border border-soft rounded-lg">
                <div class="text-xl font-bold text-primary">{{ number_format($summary['avg_order_frequency'], 1) }}</div>
                <div class="text-sm text-muted">Avg Order Frequency</div>
            </div>
            <div class="text-center p-4 border border-soft rounded-lg">
                <div class="text-xl font-bold text-primary">₦{{ number_format($summary['avg_order_value'], 0) }}</div>
                <div class="text-sm text-muted">Avg Order Value</div>
            </div>
            <div class="text-center p-4 border border-soft rounded-lg">
                <div class="text-xl font-bold text-primary">{{ number_format($summary['customer_retention_rate'], 1) }}%</div>
                <div class="text-sm text-muted">Retention Rate</div>
            </div>
        </div>
    </div>
    
    <!-- Export Options -->
    <div class="surface rounded-xl p-6">
        <h3 class="text-lg font-semibold text-primary mb-4">Export Options</h3>
        <div class="flex flex-wrap gap-3">
            <a href="{{ request()->fullUrlWithQuery(['format' => 'pdf']) }}" 
               class="btn btn-outline text-red-600 border-red-300 hover:bg-red-50 dark:hover:bg-red-900/20">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                </svg>
                Download PDF
            </a>
            <a href="{{ request()->fullUrlWithQuery(['format' => 'csv']) }}" 
               class="btn btn-outline text-green-600 border-green-300 hover:bg-green-50 dark:hover:bg-green-900/20">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                </svg>
                Download CSV
            </a>
        </div>
    </div>
    
    <!-- Customer Segmentation -->
    <div class="surface rounded-xl p-6">
        <h3 class="text-lg font-semibold text-primary mb-4">Customer Segmentation</h3>
        <div class="grid grid-cols-2 md:grid-cols-5 gap-4">
            <div class="text-center p-4 bg-cyan-500/10 rounded-lg">
                <div class="text-xl font-bold text-cyan-600 dark:text-cyan-400">{{ $segmentation['new_customers'] }}</div>
                <div class="text-sm text-muted">New Customers</div>
            </div>
            <div class="text-center p-4 bg-blue-500/10 rounded-lg">
                <div class="text-xl font-bold text-blue-600 dark:text-blue-400">{{ $segmentation['returning_customers'] }}</div>
                <div class="text-sm text-muted">Returning</div>
            </div>
            <div class="text-center p-4 bg-purple-500/10 rounded-lg">
                <div class="text-xl font-bold text-purple-600 dark:text-purple-400">{{ $segmentation['loyal_customers'] }}</div>
                <div class="text-sm text-muted">Loyal</div>
            </div>
            <div class="text-center p-4 bg-green-500/10 rounded-lg">
                <div class="text-xl font-bold text-green-600 dark:text-green-400">{{ $segmentation['high_value'] }}</div>
                <div class="text-sm text-muted">High Value</div>
            </div>
            <div class="text-center p-4 bg-orange-500/10 rounded-lg">
                <div class="text-xl font-bold text-orange-600 dark:text-orange-400">{{ $segmentation['at_risk'] }}</div>
                <div class="text-sm text-muted">At Risk</div>
            </div>
        </div>
    </div>
    
    <!-- Order Frequency Analysis -->
    <div class="surface rounded-xl p-6">
        <h3 class="text-lg font-semibold text-primary mb-4">Order Frequency Distribution</h3>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-soft">
                        <th class="text-left py-3 text-primary">Frequency</th>
                        <th class="text-right py-3 text-primary">Customers</th>
                        <th class="text-right py-3 text-primary">Total Revenue</th>
                        <th class="text-right py-3 text-primary">Avg Value</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($frequencyAnalysis as $frequency => $data)
                    <tr class="border-b border-soft/50">
                        <td class="py-3 font-medium text-primary">{{ $frequency }}</td>
                        <td class="py-3 text-right text-muted">{{ number_format($data['count']) }}</td>
                        <td class="py-3 text-right text-primary">₦{{ number_format($data['total_revenue'], 0) }}</td>
                        <td class="py-3 text-right text-muted">₦{{ number_format($data['avg_value'], 0) }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    
    <!-- Top Customers -->
    <div class="surface rounded-xl overflow-hidden">
        <div class="px-6 py-4 border-b border-soft">
            <h3 class="text-lg font-semibold text-primary">Top Customers by Value</h3>
        </div>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-slate-50 dark:bg-slate-800">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-muted uppercase tracking-wider">Customer</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-muted uppercase tracking-wider">Contact</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-muted uppercase tracking-wider">Orders</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-muted uppercase tracking-wider">Total Spent</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-muted uppercase tracking-wider">Avg Order</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-muted uppercase tracking-wider">Lifetime Value</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-muted uppercase tracking-wider">Last Order</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-soft">
                    @foreach($customers->take(50) as $customer)
                    <tr class="hover:bg-slate-50 dark:hover:bg-slate-800">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm font-medium text-primary">{{ $customer['name'] }}</div>
                            <div class="text-xs text-muted">Joined {{ \Carbon\Carbon::parse($customer['registration_date'])->format('M d, Y') }}</div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm text-primary">{{ $customer['email'] }}</div>
                            <div class="text-xs text-muted">{{ $customer['phone'] }}</div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-right text-primary font-medium">{{ number_format($customer['total_orders']) }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-right text-primary font-medium">₦{{ number_format($customer['total_spent'], 0) }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-right text-muted">₦{{ number_format($customer['avg_order_value'], 0) }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-right text-primary font-bold">₦{{ number_format($customer['lifetime_value'], 0) }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-muted">
                            @if($customer['last_order'])
                                {{ \Carbon\Carbon::parse($customer['last_order'])->format('M d, Y') }}
                                @if($customer['days_since_last_order'])
                                    <div class="text-xs {{ $customer['days_since_last_order'] > 30 ? 'text-red-500' : 'text-green-500' }}">
                                        {{ $customer['days_since_last_order'] }} days ago
                                    </div>
                                @endif
                            @else
                                <span class="text-gray-400">Never</span>
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        @if($customers->count() > 50)
        <div class="px-6 py-3 bg-slate-50 dark:bg-slate-800 text-center text-sm text-muted">
            Showing top 50 customers of {{ $customers->count() }} total customers
        </div>
        @endif
    </div>
    
    <!-- New Customers -->
    @if($newCustomers->count() > 0)
    <div class="surface rounded-xl overflow-hidden">
        <div class="px-6 py-4 border-b border-soft">
            <h3 class="text-lg font-semibold text-primary">New Customers in Period</h3>
        </div>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-slate-50 dark:bg-slate-800">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-muted uppercase tracking-wider">Customer</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-muted uppercase tracking-wider">Registration</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-muted uppercase tracking-wider">First Order</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-muted uppercase tracking-wider">Orders</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-muted uppercase tracking-wider">Total Spent</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-muted uppercase tracking-wider">Days to First Order</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-soft">
                    @foreach($newCustomers->take(20) as $customer)
                    <tr class="hover:bg-slate-50 dark:hover:bg-slate-800">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm font-medium text-primary">{{ $customer['name'] }}</div>
                            <div class="text-xs text-muted">{{ $customer['email'] }}</div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-muted">{{ \Carbon\Carbon::parse($customer['registration_date'])->format('M d, Y') }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-muted">
                            @if($customer['first_order_date'])
                                {{ \Carbon\Carbon::parse($customer['first_order_date'])->format('M d, Y') }}
                            @else
                                <span class="text-orange-500">No orders yet</span>
                            @endif
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-right text-primary">{{ number_format($customer['orders_count']) }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-right text-primary font-medium">₦{{ number_format($customer['total_spent'], 0) }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-right text-muted">
                            @if($customer['days_to_first_order'] !== null)
                                {{ $customer['days_to_first_order'] }} days
                            @else
                                <span class="text-gray-400">-</span>
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    @endif
</div>
@endsection