@extends('super-admin.layout')

@section('title', 'Reports')
@section('subtitle', 'Generate comprehensive business reports')

@section('content')
<div class="space-y-6">
    <!-- Report Types -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        <!-- Sales Report -->
        <div class="surface rounded-xl p-6">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-lg font-semibold text-primary">Sales Reports</h3>
                <div class="p-2 bg-green-500/10 rounded-lg">
                    <svg class="w-6 h-6 text-green-600 dark:text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                </div>
            </div>
            <p class="text-muted mb-4">Comprehensive sales analysis including order trends, revenue breakdown, and performance metrics.</p>
            <button onclick="openReportModal('sales')" class="btn btn-primary w-full">
                Generate Sales Report
            </button>
        </div>

        <!-- Customer Report -->
        <div class="surface rounded-xl p-6">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-lg font-semibold text-primary">Customer Reports</h3>
                <div class="p-2 bg-blue-500/10 rounded-lg">
                    <svg class="w-6 h-6 text-blue-600 dark:text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                    </svg>
                </div>
            </div>
            <p class="text-muted mb-4">Customer behavior analysis, lifetime value, purchase patterns, and segmentation insights.</p>
            <button onclick="openReportModal('customers')" class="btn btn-primary w-full">
                Generate Customer Report
            </button>
        </div>

        <!-- Product Report -->
        <div class="surface rounded-xl p-6">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-lg font-semibold text-primary">Product Reports</h3>
                <div class="p-2 bg-purple-500/10 rounded-lg">
                    <svg class="w-6 h-6 text-purple-600 dark:text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6V4m0 2a2 2 0 100 4m0-4a2 2 0 110 4m-6 8a2 2 0 100-4m0 4a2 2 0 100 4m0-4v2m0-6V4m6 6v10m6-2a2 2 0 100-4m0 4a2 2 0 100 4m0-4v2m0-6V4"></path>
                    </svg>
                </div>
            </div>
            <p class="text-muted mb-4">Product performance analysis, inventory trends, bestsellers, and category comparisons.</p>
            <button onclick="openReportModal('products')" class="btn btn-primary w-full">
                Generate Product Report
            </button>
        </div>

        <!-- Inventory Report -->
        <div class="surface rounded-xl p-6">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-lg font-semibold text-primary">Inventory Reports</h3>
                <div class="p-2 bg-orange-500/10 rounded-lg">
                    <svg class="w-6 h-6 text-orange-600 dark:text-orange-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                    </svg>
                </div>
            </div>
            <p class="text-muted mb-4">Stock levels, low inventory alerts, sales velocity, and inventory valuation reports.</p>
            <button onclick="openReportModal('inventory')" class="btn btn-primary w-full">
                Generate Inventory Report
            </button>
        </div>

        <!-- Performance Report -->
        <div class="surface rounded-xl p-6">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-lg font-semibold text-primary">Performance Reports</h3>
                <div class="p-2 bg-indigo-500/10 rounded-lg">
                    <svg class="w-6 h-6 text-indigo-600 dark:text-indigo-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                    </svg>
                </div>
            </div>
            <p class="text-muted mb-4">Order processing times, peak hours analysis, efficiency metrics, and operational insights.</p>
            <button onclick="openReportModal('performance')" class="btn btn-primary w-full">
                Generate Performance Report
            </button>
        </div>

        <!-- Revenue Report (Alias for Sales) -->
        <div class="surface rounded-xl p-6">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-lg font-semibold text-primary">Revenue Analysis</h3>
                <div class="p-2 bg-emerald-500/10 rounded-lg">
                    <svg class="w-6 h-6 text-emerald-600 dark:text-emerald-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                    </svg>
                </div>
            </div>
            <p class="text-muted mb-4">Detailed revenue analysis, profit margins, financial trends, and revenue streams breakdown.</p>
            <button onclick="openReportModal('sales')" class="btn btn-primary w-full">
                Generate Revenue Report
            </button>
        </div>
    </div>

    <!-- Quick Reports -->
    <div class="surface rounded-xl p-6">
        <h3 class="text-lg font-semibold text-primary mb-4">Quick Reports</h3>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
            <button onclick="generateQuickReport('today')" class="p-4 text-left border border-soft rounded-lg hover:bg-slate-100 dark:hover:bg-slate-800 transition-colors">
                <div class="text-sm font-medium text-primary">Today's Sales</div>
                <div class="text-sm text-muted">Quick overview of today's performance</div>
            </button>
            <button onclick="generateQuickReport('week')" class="p-4 text-left border border-soft rounded-lg hover:bg-slate-100 dark:hover:bg-slate-800 transition-colors">
                <div class="text-sm font-medium text-primary">This Week</div>
                <div class="text-sm text-muted">Weekly performance summary</div>
            </button>
            <button onclick="generateQuickReport('month')" class="p-4 text-left border border-soft rounded-lg hover:bg-slate-100 dark:hover:bg-slate-800 transition-colors">
                <div class="text-sm font-medium text-primary">This Month</div>
                <div class="text-sm text-muted">Monthly business overview</div>
            </button>
            <button onclick="generateQuickReport('top-customers')" class="p-4 text-left border border-soft rounded-lg hover:bg-slate-100 dark:hover:bg-slate-800 transition-colors">
                <div class="text-sm font-medium text-primary">Top Customers</div>
                <div class="text-sm text-muted">Best customers by value</div>
            </button>
            <button onclick="generateQuickReport('inventory-check')" class="p-4 text-left border border-soft rounded-lg hover:bg-slate-100 dark:hover:bg-slate-800 transition-colors">
                <div class="text-sm font-medium text-primary">Inventory Status</div>
                <div class="text-sm text-muted">Current stock levels and alerts</div>
            </button>
            <button onclick="generateQuickReport('performance-summary')" class="p-4 text-left border border-soft rounded-lg hover:bg-slate-100 dark:hover:bg-slate-800 transition-colors">
                <div class="text-sm font-medium text-primary">Performance Summary</div>
                <div class="text-sm text-muted">Operational efficiency metrics</div>
            </button>
        </div>
    </div>

    <!-- Recent Reports -->
    <div class="surface rounded-xl p-6">
        <h3 class="text-lg font-semibold text-primary mb-4">Recent Reports</h3>
        <div class="space-y-3">
            <div class="flex items-center justify-between p-3 border border-soft rounded-lg">
                <div>
                    <div class="font-medium text-primary">Sales Report - Last 30 Days</div>
                    <div class="text-sm text-muted">Generated 2 hours ago</div>
                </div>
                <div class="flex space-x-2">
                    <button class="text-indigo-600 dark:text-indigo-400 hover:text-indigo-700 dark:hover:text-indigo-300 text-sm">Download</button>
                    <button class="text-green-600 dark:text-green-400 hover:text-green-700 dark:hover:text-green-300 text-sm">View</button>
                </div>
            </div>
            
            <div class="flex items-center justify-between p-3 border border-soft rounded-lg">
                <div>
                    <div class="font-medium text-primary">Customer Analysis - Q4 2024</div>
                    <div class="text-sm text-muted">Generated yesterday</div>
                </div>
                <div class="flex space-x-2">
                    <button class="text-indigo-600 dark:text-indigo-400 hover:text-indigo-700 dark:hover:text-indigo-300 text-sm">Download</button>
                    <button class="text-green-600 dark:text-green-400 hover:text-green-700 dark:hover:text-green-300 text-sm">View</button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Report Generation Modal -->
<div id="reportModal" class="fixed inset-0 bg-black bg-opacity-50 hidden items-center justify-center z-50">
    <div class="surface rounded-xl shadow-xl p-6 w-full max-w-md mx-4">
        <div class="flex items-center justify-between mb-4">
            <h3 id="modalTitle" class="text-lg font-semibold text-primary">Generate Report</h3>
            <button onclick="closeReportModal()" class="text-muted hover:text-primary">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </div>
        
        <form id="reportForm" method="GET">
            <div class="space-y-4">
                <div>
                    <label for="start_date" class="block text-sm font-medium text-primary mb-1">Start Date</label>
                    <input type="date" id="start_date" name="start_date" required
                           class="w-full px-3 py-2 border border-soft rounded-lg focus:ring-2 focus:ring-indigo-500 focus:border-transparent bg-white dark:bg-slate-800 text-primary">
                </div>
                
                <div>
                    <label for="end_date" class="block text-sm font-medium text-primary mb-1">End Date</label>
                    <input type="date" id="end_date" name="end_date" required
                           class="w-full px-3 py-2 border border-soft rounded-lg focus:ring-2 focus:ring-indigo-500 focus:border-transparent bg-white dark:bg-slate-800 text-primary">
                </div>
                
                <div>
                    <label for="format" class="block text-sm font-medium text-primary mb-1">Format</label>
                    <select id="format" name="format" class="w-full px-3 py-2 border border-soft rounded-lg focus:ring-2 focus:ring-indigo-500 focus:border-transparent bg-white dark:bg-slate-800 text-primary">
                        <option value="view">View in Browser</option>
                        <option value="pdf">Download PDF</option>
                        <option value="csv">Download CSV</option>
                    </select>
                </div>
            </div>
            
            <div class="flex space-x-3 mt-6">
                <button type="button" onclick="closeReportModal()" 
                        class="flex-1 btn btn-outline">
                    Cancel
                </button>
                <button type="submit" 
                        class="flex-1 btn btn-primary">
                    Generate Report
                </button>
            </div>
        </form>
    </div>
</div>
@endsection

@push('scripts')
<script>
let currentReportType = '';

function openReportModal(type) {
    currentReportType = type;
    document.getElementById('modalTitle').textContent = `Generate ${type.charAt(0).toUpperCase() + type.slice(1)} Report`;
    document.getElementById('reportModal').classList.remove('hidden');
    document.getElementById('reportModal').classList.add('flex');
    
    // Set default dates (last 30 days)
    const endDate = new Date();
    const startDate = new Date();
    startDate.setDate(startDate.getDate() - 30);
    
    document.getElementById('start_date').value = startDate.toISOString().split('T')[0];
    document.getElementById('end_date').value = endDate.toISOString().split('T')[0];
}

function closeReportModal() {
    document.getElementById('reportModal').classList.add('hidden');
    document.getElementById('reportModal').classList.remove('flex');
}

document.getElementById('reportForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const params = new URLSearchParams(formData);
    
    const baseUrl = '{{ url("/super-admin/reports") }}';
    const url = `${baseUrl}/${currentReportType}?${params.toString()}`;
    
    if (formData.get('format') === 'view') {
        window.open(url, '_blank');
    } else {
        // For PDF/CSV downloads, navigate to the URL
        window.location.href = url;
    }
    
    closeReportModal();
});

function generateQuickReport(type) {
    let url = '';
    const today = new Date();
    const baseUrl = '{{ url("/super-admin/reports") }}';
    
    switch(type) {
        case 'today':
            const todayStr = today.toISOString().split('T')[0];
            url = `${baseUrl}/sales?start_date=${todayStr}&end_date=${todayStr}&format=view`;
            break;
        case 'week':
            const weekStart = new Date(today);
            weekStart.setDate(today.getDate() - 7);
            url = `${baseUrl}/sales?start_date=${weekStart.toISOString().split('T')[0]}&end_date=${today.toISOString().split('T')[0]}&format=view`;
            break;
        case 'month':
            const monthStart = new Date(today);
            monthStart.setDate(today.getDate() - 30);
            url = `${baseUrl}/sales?start_date=${monthStart.toISOString().split('T')[0]}&end_date=${today.toISOString().split('T')[0]}&format=view`;
            break;
        case 'top-customers':
            const monthAgo = new Date(today);
            monthAgo.setDate(today.getDate() - 30);
            url = `${baseUrl}/customers?start_date=${monthAgo.toISOString().split('T')[0]}&end_date=${today.toISOString().split('T')[0]}&format=view`;
            break;
        case 'inventory-check':
            url = `${baseUrl}/inventory?start_date=${today.toISOString().split('T')[0]}&end_date=${today.toISOString().split('T')[0]}&format=view`;
            break;
        case 'performance-summary':
            const weekAgo = new Date(today);
            weekAgo.setDate(today.getDate() - 7);
            url = `${baseUrl}/performance?start_date=${weekAgo.toISOString().split('T')[0]}&end_date=${today.toISOString().split('T')[0]}&format=view`;
            break;
    }
    
    if (url) {
        window.open(url, '_blank');
    }
}

// Close modal when clicking outside
document.getElementById('reportModal').addEventListener('click', function(e) {
    if (e.target === this) {
        closeReportModal();
    }
});
</script>
@endpush