@extends('super-admin.layout')

@section('title', 'Inventory Report')
@section('subtitle', 'Current inventory status and stock analysis')

@section('content')
<div class="space-y-6">
    <!-- Report Summary -->
    <div class="surface rounded-xl p-6">
        <h3 class="text-lg font-semibold text-primary mb-4">Inventory Summary</h3>
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
            <div class="text-center p-4 bg-blue-500/10 rounded-lg">
                <div class="text-2xl font-bold text-blue-600 dark:text-blue-400">{{ number_format($summary['total_dishes']) }}</div>
                <div class="text-sm text-muted">Total Dishes</div>
            </div>
            <div class="text-center p-4 bg-green-500/10 rounded-lg">
                <div class="text-2xl font-bold text-green-600 dark:text-green-400">{{ number_format($summary['total_stock_units']) }}</div>
                <div class="text-sm text-muted">Stock Units</div>
            </div>
            <div class="text-center p-4 bg-purple-500/10 rounded-lg">
                <div class="text-2xl font-bold text-purple-600 dark:text-purple-400">₦{{ number_format($summary['total_stock_value'], 0) }}</div>
                <div class="text-sm text-muted">Stock Value</div>
            </div>
            <div class="text-center p-4 bg-indigo-500/10 rounded-lg">
                <div class="text-2xl font-bold text-indigo-600 dark:text-indigo-400">{{ number_format($summary['avg_daily_velocity'], 1) }}</div>
                <div class="text-sm text-muted">Avg Daily Velocity</div>
            </div>
        </div>
        
        <!-- Stock Alerts -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mt-6">
            <div class="text-center p-4 border border-red-300 rounded-lg bg-red-50 dark:bg-red-900/20">
                <div class="text-xl font-bold text-red-600">{{ $summary['critical_stock_items'] }}</div>
                <div class="text-sm text-muted">Critical Stock (≤5)</div>
            </div>
            <div class="text-center p-4 border border-orange-300 rounded-lg bg-orange-50 dark:bg-orange-900/20">
                <div class="text-xl font-bold text-orange-600">{{ $summary['low_stock_items'] }}</div>
                <div class="text-sm text-muted">Low Stock (≤10)</div>
            </div>
            <div class="text-center p-4 border border-yellow-300 rounded-lg bg-yellow-50 dark:bg-yellow-900/20">
                <div class="text-xl font-bold text-yellow-600">{{ $summary['warning_stock_items'] }}</div>
                <div class="text-sm text-muted">Warning Stock (≤20)</div>
            </div>
        </div>
    </div>
    
    <!-- Export Options -->
    <div class="surface rounded-xl p-6">
        <h3 class="text-lg font-semibold text-primary mb-4">Export Options</h3>
        <div class="flex flex-wrap gap-3">
            <a href="{{ request()->fullUrlWithQuery(['format' => 'pdf']) }}" 
               class="btn btn-outline text-red-600 border-red-300 hover:bg-red-50 dark:hover:bg-red-900/20">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                </svg>
                Download PDF
            </a>
            <a href="{{ request()->fullUrlWithQuery(['format' => 'csv']) }}" 
               class="btn btn-outline text-green-600 border-green-300 hover:bg-green-50 dark:hover:bg-green-900/20">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                </svg>
                Download CSV
            </a>
        </div>
    </div>
    
    <!-- Critical Stock Alerts -->
    @if($stockAlerts['critical']->count() > 0)
    <div class="surface rounded-xl p-6 border-l-4 border-red-500">
        <h3 class="text-lg font-semibold text-primary mb-4">
            <span class="inline-flex items-center">
                <svg class="w-5 h-5 mr-2 text-red-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L4.082 15.5c-.77.833.192 2.5 1.732 2.5z"></path>
                </svg>
                Critical Stock Alert - Immediate Action Required
            </span>
        </h3>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-soft">
                        <th class="text-left py-3 text-primary">Dish</th>
                        <th class="text-left py-3 text-primary">Category</th>
                        <th class="text-right py-3 text-primary">Current Stock</th>
                        <th class="text-right py-3 text-primary">Daily Velocity</th>
                        <th class="text-right py-3 text-primary">Days Until Stockout</th>
                        <th class="text-right py-3 text-primary">Stock Value</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($stockAlerts['critical'] as $item)
                    <tr class="border-b border-soft/50 bg-red-50 dark:bg-red-900/10">
                        <td class="py-3 font-medium text-red-700 dark:text-red-400">{{ $item['name'] }}</td>
                        <td class="py-3 text-muted">{{ $item['category'] }}</td>
                        <td class="py-3 text-right font-bold text-red-600">{{ $item['current_stock'] }}</td>
                        <td class="py-3 text-right text-muted">{{ $item['daily_velocity'] }}</td>
                        <td class="py-3 text-right">
                            @if($item['estimated_stockout_days'])
                                <span class="font-bold text-red-600">{{ $item['estimated_stockout_days'] }} days</span>
                            @else
                                <span class="text-gray-400">-</span>
                            @endif
                        </td>
                        <td class="py-3 text-right text-muted">₦{{ number_format($item['stock_value'], 0) }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    @endif
    
    <!-- Category Inventory Overview -->
    <div class="surface rounded-xl p-6">
        <h3 class="text-lg font-semibold text-primary mb-4">Inventory by Category</h3>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-soft">
                        <th class="text-left py-3 text-primary">Category</th>
                        <th class="text-right py-3 text-primary">Total Items</th>
                        <th class="text-right py-3 text-primary">Stock Units</th>
                        <th class="text-right py-3 text-primary">Stock Value</th>
                        <th class="text-right py-3 text-primary">Avg Velocity</th>
                        <th class="text-right py-3 text-primary">Critical Items</th>
                        <th class="text-right py-3 text-primary">Low Items</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($categoryInventory as $category)
                    <tr class="border-b border-soft/50">
                        <td class="py-3 font-medium text-primary">{{ $category['category'] }}</td>
                        <td class="py-3 text-right text-muted">{{ $category['total_items'] }}</td>
                        <td class="py-3 text-right text-primary">{{ number_format($category['total_stock']) }}</td>
                        <td class="py-3 text-right text-primary font-medium">₦{{ number_format($category['total_value'], 0) }}</td>
                        <td class="py-3 text-right text-muted">{{ number_format($category['avg_velocity'], 1) }}</td>
                        <td class="py-3 text-right">
                            @if($category['critical_items'] > 0)
                                <span class="font-bold text-red-600">{{ $category['critical_items'] }}</span>
                            @else
                                <span class="text-gray-400">0</span>
                            @endif
                        </td>
                        <td class="py-3 text-right">
                            @if($category['low_items'] > 0)
                                <span class="font-bold text-orange-600">{{ $category['low_items'] }}</span>
                            @else
                                <span class="text-gray-400">0</span>
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    
    <!-- Full Inventory Report -->
    <div class="surface rounded-xl overflow-hidden">
        <div class="px-6 py-4 border-b border-soft">
            <h3 class="text-lg font-semibold text-primary">Complete Inventory Status</h3>
        </div>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-slate-50 dark:bg-slate-800">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-muted uppercase tracking-wider">Dish</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-muted uppercase tracking-wider">Category</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-muted uppercase tracking-wider">Stock</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-muted uppercase tracking-wider">Status</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-muted uppercase tracking-wider">Sold (Period)</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-muted uppercase tracking-wider">Daily Velocity</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-muted uppercase tracking-wider">Est. Stockout</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-muted uppercase tracking-wider">Stock Value</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-soft">
                    @foreach($inventory as $item)
                    <tr class="hover:bg-slate-50 dark:hover:bg-slate-800 
                        {{ $item['stock_status'] === 'critical' ? 'bg-red-50 dark:bg-red-900/10' : 
                           ($item['stock_status'] === 'low' ? 'bg-orange-50 dark:bg-orange-900/10' : 
                           ($item['stock_status'] === 'warning' ? 'bg-yellow-50 dark:bg-yellow-900/10' : '')) }}">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm font-medium text-primary">{{ $item['name'] }}</div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-muted">{{ $item['category'] }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-right">
                            <span class="font-bold {{ $item['stock_status'] === 'critical' ? 'text-red-600' : 
                                                       ($item['stock_status'] === 'low' ? 'text-orange-600' : 
                                                       ($item['stock_status'] === 'warning' ? 'text-yellow-600' : 'text-green-600')) }}">
                                {{ $item['current_stock'] }}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            @if($item['stock_status'] === 'critical')
                                <span class="px-2 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-800 dark:bg-red-900/30 dark:text-red-400">Critical</span>
                            @elseif($item['stock_status'] === 'low')
                                <span class="px-2 py-1 text-xs font-semibold rounded-full bg-orange-100 text-orange-800 dark:bg-orange-900/30 dark:text-orange-400">Low</span>
                            @elseif($item['stock_status'] === 'warning')
                                <span class="px-2 py-1 text-xs font-semibold rounded-full bg-yellow-100 text-yellow-800 dark:bg-yellow-900/30 dark:text-yellow-400">Warning</span>
                            @else
                                <span class="px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800 dark:bg-green-900/30 dark:text-green-400">Good</span>
                            @endif
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-right text-muted">{{ $item['sold_in_period'] }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-right text-muted">{{ $item['daily_velocity'] }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-right">
                            @if($item['estimated_stockout_days'])
                                <span class="font-medium {{ $item['estimated_stockout_days'] <= 7 ? 'text-red-600' : 
                                                             ($item['estimated_stockout_days'] <= 14 ? 'text-orange-600' : 'text-primary') }}">
                                    {{ $item['estimated_stockout_days'] }} days
                                </span>
                            @else
                                <span class="text-gray-400">-</span>
                            @endif
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-right text-primary font-medium">₦{{ number_format($item['stock_value'], 0) }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection