@extends('super-admin.layout')

@section('title', 'Product Report')
@section('subtitle', $summary['period'])

@section('content')
<div class="space-y-6">
    <!-- Report Summary -->
    <div class="surface rounded-xl p-6">
        <h3 class="text-lg font-semibold text-primary mb-4">Product Performance Summary</h3>
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
            <div class="text-center p-4 bg-blue-500/10 rounded-lg">
                <div class="text-2xl font-bold text-blue-600 dark:text-blue-400">{{ number_format($summary['total_products']) }}</div>
                <div class="text-sm text-muted">Products Sold</div>
            </div>
            <div class="text-center p-4 bg-green-500/10 rounded-lg">
                <div class="text-2xl font-bold text-green-600 dark:text-green-400">{{ number_format($summary['total_items_sold']) }}</div>
                <div class="text-sm text-muted">Items Sold</div>
            </div>
            <div class="text-center p-4 bg-purple-500/10 rounded-lg">
                <div class="text-2xl font-bold text-purple-600 dark:text-purple-400">₦{{ number_format($summary['total_revenue'], 0) }}</div>
                <div class="text-sm text-muted">Total Revenue</div>
            </div>
            <div class="text-center p-4 bg-indigo-500/10 rounded-lg">
                <div class="text-2xl font-bold text-indigo-600 dark:text-indigo-400">₦{{ number_format($summary['avg_revenue_per_product'], 0) }}</div>
                <div class="text-sm text-muted">Avg Revenue/Product</div>
            </div>
        </div>
        
        <!-- Inventory Alerts -->
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mt-6">
            <div class="text-center p-4 border border-soft rounded-lg">
                <div class="text-xl font-bold text-primary">{{ number_format($summary['avg_items_per_product'], 1) }}</div>
                <div class="text-sm text-muted">Avg Items/Product</div>
            </div>
            <div class="text-center p-4 border border-orange-300 rounded-lg bg-orange-50 dark:bg-orange-900/20">
                <div class="text-xl font-bold text-orange-600">{{ $summary['low_stock_items'] }}</div>
                <div class="text-sm text-muted">Low Stock Items</div>
            </div>
            <div class="text-center p-4 border border-red-300 rounded-lg bg-red-50 dark:bg-red-900/20">
                <div class="text-xl font-bold text-red-600">{{ $summary['critical_stock_items'] }}</div>
                <div class="text-sm text-muted">Critical Stock</div>
            </div>
            <div class="text-center p-4 border border-soft rounded-lg">
                <div class="text-xl font-bold text-primary">{{ $summary['top_category'] }}</div>
                <div class="text-sm text-muted">Top Category</div>
            </div>
        </div>
    </div>
    
    <!-- Export Options -->
    <div class="surface rounded-xl p-6">
        <h3 class="text-lg font-semibold text-primary mb-4">Export Options</h3>
        <div class="flex flex-wrap gap-3">
            <a href="{{ request()->fullUrlWithQuery(['format' => 'pdf']) }}" 
               class="btn btn-outline text-red-600 border-red-300 hover:bg-red-50 dark:hover:bg-red-900/20">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                </svg>
                Download PDF
            </a>
            <a href="{{ request()->fullUrlWithQuery(['format' => 'csv']) }}" 
               class="btn btn-outline text-green-600 border-green-300 hover:bg-green-50 dark:hover:bg-green-900/20">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                </svg>
                Download CSV
            </a>
        </div>
    </div>
    
    <!-- Category Performance -->
    <div class="surface rounded-xl p-6">
        <h3 class="text-lg font-semibold text-primary mb-4">Performance by Category</h3>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-soft">
                        <th class="text-left py-3 text-primary">Category</th>
                        <th class="text-right py-3 text-primary">Revenue</th>
                        <th class="text-right py-3 text-primary">Items Sold</th>
                        <th class="text-right py-3 text-primary">Unique Dishes</th>
                        <th class="text-right py-3 text-primary">Orders</th>
                        <th class="text-right py-3 text-primary">Avg Price</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($categoryPerformance as $category)
                    <tr class="border-b border-soft/50">
                        <td class="py-3 font-medium text-primary">{{ $category->name }}</td>
                        <td class="py-3 text-right text-primary font-medium">₦{{ number_format($category->revenue, 0) }}</td>
                        <td class="py-3 text-right text-muted">{{ number_format($category->items_sold) }}</td>
                        <td class="py-3 text-right text-muted">{{ number_format($category->unique_dishes) }}</td>
                        <td class="py-3 text-right text-muted">{{ number_format($category->orders_count) }}</td>
                        <td class="py-3 text-right text-muted">₦{{ number_format($category->avg_price, 0) }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    
    <!-- Low Stock Alert -->
    @if($lowStockDishes->count() > 0)
    <div class="surface rounded-xl p-6 border-l-4 border-orange-500">
        <h3 class="text-lg font-semibold text-primary mb-4">
            <span class="inline-flex items-center">
                <svg class="w-5 h-5 mr-2 text-orange-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L4.082 15.5c-.77.833.192 2.5 1.732 2.5z"></path>
                </svg>
                Low Stock Alert
            </span>
        </h3>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-soft">
                        <th class="text-left py-3 text-primary">Dish</th>
                        <th class="text-left py-3 text-primary">Category</th>
                        <th class="text-right py-3 text-primary">Current Stock</th>
                        <th class="text-right py-3 text-primary">Sold in Period</th>
                        <th class="text-right py-3 text-primary">Daily Velocity</th>
                        <th class="text-right py-3 text-primary">Est. Days Left</th>
                        <th class="text-left py-3 text-primary">Status</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($lowStockDishes as $dish)
                    <tr class="border-b border-soft/50">
                        <td class="py-3 font-medium text-primary">{{ $dish->name }}</td>
                        <td class="py-3 text-muted">{{ $dish->category->name }}</td>
                        <td class="py-3 text-right font-medium {{ $dish->stock <= 5 ? 'text-red-600' : ($dish->stock <= 10 ? 'text-orange-600' : 'text-primary') }}">
                            {{ $dish->stock }}
                        </td>
                        <td class="py-3 text-right text-muted">{{ $dish->sold_in_period }}</td>
                        <td class="py-3 text-right text-muted">{{ number_format($dish->daily_velocity, 1) }}</td>
                        <td class="py-3 text-right text-muted">
                            @if($dish->estimated_days_until_stockout)
                                {{ number_format($dish->estimated_days_until_stockout) }} days
                            @else
                                <span class="text-gray-400">-</span>
                            @endif
                        </td>
                        <td class="py-3">
                            @if($dish->stock <= 5)
                                <span class="px-2 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-800 dark:bg-red-900/30 dark:text-red-400">Critical</span>
                            @elseif($dish->stock <= 10)
                                <span class="px-2 py-1 text-xs font-semibold rounded-full bg-orange-100 text-orange-800 dark:bg-orange-900/30 dark:text-orange-400">Low</span>
                            @else
                                <span class="px-2 py-1 text-xs font-semibold rounded-full bg-yellow-100 text-yellow-800 dark:bg-yellow-900/30 dark:text-yellow-400">Warning</span>
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    @endif
    
    <!-- Product Performance Trends -->
    <div class="surface rounded-xl p-6">
        <h3 class="text-lg font-semibold text-primary mb-4">Performance Trends</h3>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="border-b border-soft">
                        <th class="text-left py-3 text-primary">Dish</th>
                        <th class="text-left py-3 text-primary">Category</th>
                        <th class="text-right py-3 text-primary">Daily Sales</th>
                        <th class="text-right py-3 text-primary">Daily Revenue</th>
                        <th class="text-right py-3 text-primary">Revenue/Item</th>
                        <th class="text-right py-3 text-primary">Market Share</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($performanceTrends->take(20) as $trend)
                    <tr class="border-b border-soft/50">
                        <td class="py-3 font-medium text-primary">{{ $trend['name'] }}</td>
                        <td class="py-3 text-muted">{{ $trend['category'] }}</td>
                        <td class="py-3 text-right text-muted">{{ $trend['daily_sales'] }}</td>
                        <td class="py-3 text-right text-primary">₦{{ number_format($trend['daily_revenue'], 0) }}</td>
                        <td class="py-3 text-right text-muted">₦{{ number_format($trend['revenue_per_item'], 0) }}</td>
                        <td class="py-3 text-right text-primary font-medium">{{ $trend['market_share'] }}%</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    
    <!-- All Products Performance -->
    <div class="surface rounded-xl overflow-hidden">
        <div class="px-6 py-4 border-b border-soft">
            <h3 class="text-lg font-semibold text-primary">All Products Performance</h3>
        </div>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-slate-50 dark:bg-slate-800">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-muted uppercase tracking-wider">Product</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-muted uppercase tracking-wider">Category</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-muted uppercase tracking-wider">Price</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-muted uppercase tracking-wider">Stock</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-muted uppercase tracking-wider">Sold</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-muted uppercase tracking-wider">Revenue</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-muted uppercase tracking-wider">Orders</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-muted uppercase tracking-wider">Performance</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-soft">
                    @foreach($products as $product)
                    <tr class="hover:bg-slate-50 dark:hover:bg-slate-800">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm font-medium text-primary">{{ $product->name }}</div>
                            <div class="text-xs text-muted">
                                First Sale: {{ \Carbon\Carbon::parse($product->first_sale)->format('M d, Y') }}
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-muted">{{ $product->category }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-right text-muted">₦{{ number_format($product->price, 0) }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-right">
                            <span class="font-medium {{ $product->stock <= 5 ? 'text-red-600' : ($product->stock <= 10 ? 'text-orange-600' : 'text-primary') }}">
                                {{ $product->stock }}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-right text-primary font-medium">{{ number_format($product->total_sold) }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-right text-primary font-bold">₦{{ number_format($product->total_revenue, 0) }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-right text-muted">{{ number_format($product->orders_count) }}</td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            @php
                                $performance = $product->total_revenue / max($summary['total_revenue'], 1) * 100;
                            @endphp
                            <div class="flex items-center">
                                <div class="flex-1 bg-gray-200 dark:bg-gray-700 rounded-full h-2 mr-2">
                                    <div class="bg-blue-600 h-2 rounded-full" style="width: {{ min($performance * 10, 100) }}%"></div>
                                </div>
                                <span class="text-xs text-muted">{{ number_format($performance, 1) }}%</span>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection