@extends('super-admin.layout')

@section('title', 'Manage User Roles')
@section('subtitle', "Editing roles for {$user->name}")

@section('content')
<div class="space-y-6">
    <!-- User Information (Read-only) -->
    <div class="surface rounded-xl p-6 border-l-4 border-indigo-500">
        <div class="flex items-center justify-between">
            <div class="flex items-center space-x-4">
                <div class="h-16 w-16 rounded-full bg-gradient-to-br from-indigo-400 to-indigo-600 flex items-center justify-center">
                    <span class="text-xl font-bold text-white">
                        {{ strtoupper(substr($user->name, 0, 2)) }}
                    </span>
                </div>
                <div>
                    <h2 class="text-xl font-bold text-primary">{{ $user->name }}</h2>
                    <p class="text-sm text-muted">{{ $user->email }}</p>
                    <p class="text-xs text-muted mt-1">
                        Member since {{ $user->created_at->format('M d, Y') }}
                    </p>
                </div>
            </div>
            <div class="text-right">
                @if($user->is_active ?? true)
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-green-500/10 text-green-600 dark:text-green-400">
                        <svg class="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        Active
                    </span>
                @else
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-red-500/10 text-red-600 dark:text-red-400">
                        <svg class="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
                        </svg>
                        Inactive
                    </span>
                @endif
            </div>
        </div>
    </div>

    <!-- Role Management Form -->
    <div class="surface rounded-xl p-6">
        <div class="flex items-center justify-between mb-6">
            <div>
                <h3 class="text-lg font-semibold text-primary">Manage User Roles</h3>
                <p class="text-sm text-muted mt-1">Assign or remove roles to control user permissions</p>
            </div>
            <a href="{{ route('super-admin.users.index') }}" 
               class="btn btn-outline">
                <svg class="w-4 h-4 mr-2 inline-block" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
                </svg>
                Back to Users
            </a>
        </div>
        
        <form method="POST" action="{{ route('super-admin.users.update', $user) }}" class="space-y-6">
            @csrf
            @method('PUT')
            
            <div class="bg-slate-50 dark:bg-slate-800/50 rounded-lg p-6 border border-slate-200 dark:border-slate-700">
                <label class="block text-sm font-medium text-primary mb-4">
                    <svg class="w-5 h-5 inline-block mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"/>
                    </svg>
                    Select Roles
                </label>
                <div class="space-y-3">
                    @foreach($roles as $role)
                        <label class="flex items-center p-4 rounded-lg border border-slate-200 dark:border-slate-700 hover:bg-white dark:hover:bg-slate-800 cursor-pointer transition-all {{ $user->hasRole($role->name) ? 'bg-indigo-50 dark:bg-indigo-900/20 border-indigo-300 dark:border-indigo-700' : 'bg-white dark:bg-slate-800/50' }}">
                            <input type="checkbox" name="roles[]" value="{{ $role->name }}" 
                                   {{ $user->hasRole($role->name) ? 'checked' : '' }}
                                   class="rounded border-slate-300 dark:border-slate-600 text-indigo-600 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50 h-5 w-5">
                            <div class="ml-3 flex-1">
                                <span class="text-sm font-medium text-primary">{{ $role->name }}</span>
                                <p class="text-xs text-muted mt-0.5">
                                    @if($role->name === 'Super Admin')
                                        Full system access with all privileges
                                    @elseif($role->name === 'Admin')
                                        Administrative access to manage content and users
                                    @elseif($role->name === 'Customer')
                                        Basic user access for placing orders
                                    @else
                                        {{ $role->name }} role permissions
                                    @endif
                                </p>
                            </div>
                            @if($user->hasRole($role->name))
                                <svg class="w-5 h-5 text-indigo-600 dark:text-indigo-400" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                                </svg>
                            @endif
                        </label>
                    @endforeach
                </div>
                @error('roles')
                    <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                @enderror
                
                @if($user->roles->isEmpty())
                    <div class="mt-4 p-3 bg-yellow-50 dark:bg-yellow-900/20 border border-yellow-200 dark:border-yellow-800 rounded-lg">
                        <p class="text-sm text-yellow-800 dark:text-yellow-200">
                            <svg class="w-4 h-4 inline-block mr-1" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                            </svg>
                            This user currently has no roles assigned. They will have default Customer permissions.
                        </p>
                    </div>
                @endif
            </div>
            
            <div class="flex items-center justify-between pt-4 border-t border-soft">
                <a href="{{ route('super-admin.users.index') }}" 
                   class="btn btn-outline">
                    Cancel
                </a>
                <button type="submit" 
                        class="btn btn-primary">
                    <svg class="w-4 h-4 mr-2 inline-block" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                    </svg>
                    Update Roles
                </button>
            </div>
        </form>
    </div>

    <!-- Current Permissions Info -->
    <div class="surface rounded-xl p-6">
        <h3 class="text-lg font-semibold text-primary mb-4">Current Role Assignment</h3>
        <div class="flex flex-wrap gap-2">
            @forelse($user->roles as $role)
                <span class="inline-flex items-center px-4 py-2 rounded-lg text-sm font-medium {{ $role->name === 'Super Admin' ? 'bg-indigo-500/10 text-indigo-600 dark:text-indigo-400 border border-indigo-200 dark:border-indigo-800' : ($role->name === 'Admin' ? 'bg-purple-500/10 text-purple-600 dark:text-purple-400 border border-purple-200 dark:border-purple-800' : 'bg-slate-500/10 text-slate-600 dark:text-slate-400 border border-slate-200 dark:border-slate-700') }}">
                    <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M9 6a3 3 0 11-6 0 3 3 0 016 0zM17 6a3 3 0 11-6 0 3 3 0 016 0zM12.93 17c.046-.327.07-.66.07-1a6.97 6.97 0 00-1.5-4.33A5 5 0 0119 16v1h-6.07zM6 11a5 5 0 015 5v1H1v-1a5 5 0 015-5z"/>
                    </svg>
                    {{ $role->name }}
                </span>
            @empty
                <span class="inline-flex items-center px-4 py-2 rounded-lg text-sm font-medium bg-slate-500/10 text-slate-600 dark:text-slate-400 border border-slate-200 dark:border-slate-700">
                    <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M9 6a3 3 0 11-6 0 3 3 0 016 0zM17 6a3 3 0 11-6 0 3 3 0 016 0zM12.93 17c.046-.327.07-.66.07-1a6.97 6.97 0 00-1.5-4.33A5 5 0 0119 16v1h-6.07zM6 11a5 5 0 015 5v1H1v-1a5 5 0 015-5z"/>
                    </svg>
                    Customer (Default)
                </span>
            @endforelse
        </div>
    </div>
</div>
@endsection