@extends('super-admin.layout')

@section('title', 'User Management')
@section('subtitle', 'Manage user accounts and assign roles')

@section('content')
<div class="space-y-6">
    <!-- Filters and Search -->
    <div class="surface rounded-xl p-6">
        <form method="GET" action="{{ route('super-admin.users.index') }}" class="flex flex-wrap gap-4">
            <div class="flex-1 min-w-64">
                <label for="search" class="block text-sm font-medium text-muted mb-1">Search Users</label>
                <input type="text" id="search" name="search" value="{{ request('search') }}" 
                       placeholder="Search by name or email..."
                       class="w-full px-3 py-2 border border-soft rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent bg-white dark:bg-slate-800 text-primary">
            </div>
            <div class="min-w-48">
                <label for="role" class="block text-sm font-medium text-muted mb-1">Filter by Role</label>
                <select name="role" id="role" class="w-full px-3 py-2 border border-soft rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent bg-white dark:bg-slate-800 text-primary">
                    <option value="">All Roles</option>
                    @foreach($roles as $role)
                        <option value="{{ $role->name }}" {{ request('role') === $role->name ? 'selected' : '' }}>
                            {{ $role->name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="flex items-end">
                <button type="submit" class="btn btn-primary">
                    Search
                </button>
                @if(request()->hasAny(['search', 'role']))
                    <a href="{{ route('super-admin.users.index') }}" class="ml-2 btn btn-outline">
                        Clear
                    </a>
                @endif
            </div>
        </form>
    </div>

    <!-- Users Table -->
    <div class="surface rounded-xl overflow-hidden">
        <div class="px-6 py-4 border-b border-soft">
            <h3 class="text-lg font-semibold text-primary">Users ({{ $users->total() }})</h3>
        </div>
        
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-slate-200 dark:divide-slate-700">
                <thead class="bg-slate-50/50 dark:bg-slate-800/50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-muted uppercase tracking-wider">User</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-muted uppercase tracking-wider">Roles</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-muted uppercase tracking-wider">Status</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-muted uppercase tracking-wider">Joined</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-muted uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-slate-800 divide-y divide-slate-200 dark:divide-slate-700">
                    @forelse($users as $user)
                        <tr class="hover:bg-slate-50 dark:hover:bg-slate-700/50 transition-colors">
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex items-center">
                                    <div class="flex-shrink-0 h-10 w-10">
                                        <div class="h-10 w-10 rounded-full bg-gradient-to-br from-blue-400 to-blue-600 flex items-center justify-center">
                                            <span class="text-sm font-medium text-white">
                                                {{ strtoupper(substr($user->name, 0, 2)) }}
                                            </span>
                                        </div>
                                    </div>
                                    <div class="ml-4">
                                        <div class="text-sm font-medium text-primary">{{ $user->name }}</div>
                                        <div class="text-sm text-muted">{{ $user->email }}</div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex flex-wrap gap-1">
                                    @forelse($user->roles as $role)
                                        @if($role->name === 'Super Admin')
                                            <span class="badge bg-indigo-500/10 text-indigo-600 dark:text-indigo-400">{{ $role->name }}</span>
                                        @elseif($role->name === 'Admin')
                                            <span class="badge bg-purple-500/10 text-purple-600 dark:text-purple-400">{{ $role->name }}</span>
                                        @else
                                            <span class="badge">{{ $role->name }}</span>
                                        @endif
                                    @empty
                                        <span class="badge">Customer</span>
                                    @endforelse
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                @if($user->is_active ?? true)
                                    <span class="badge bg-green-500/10 text-green-600 dark:text-green-400">Active</span>
                                @else
                                    <span class="badge bg-red-500/10 text-red-600 dark:text-red-400">Inactive</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-muted">
                                {{ $user->created_at->format('M d, Y') }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                <div class="flex items-center space-x-2">
                                    <a href="{{ route('super-admin.users.edit', $user) }}" 
                                       class="text-indigo-600 dark:text-indigo-400 hover:text-indigo-700 dark:hover:text-indigo-300 transition-colors font-medium">
                                       Edit Roles
                                    </a>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="px-6 py-12 text-center text-muted">
                                <svg class="mx-auto h-12 w-12 text-slate-400 dark:text-slate-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                                </svg>
                                <h3 class="mt-2 text-sm font-medium text-primary">No users found</h3>
                                <p class="mt-1 text-sm text-muted">Try adjusting your search or filter criteria.</p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        
        @if($users->hasPages())
            <div class="px-6 py-4 border-t border-soft">
                {{ $users->links() }}
            </div>
        @endif
    </div>
</div>
@endsection

