@extends('super-admin.layout')

@section('title', 'User Details')
@section('subtitle', "Viewing {$user->name}")

@section('content')
<div class="space-y-6">
    <!-- User Info Card -->
    <div class="surface rounded-xl p-6">
        <div class="flex items-center justify-between mb-6">
            <h3 class="text-lg font-semibold text-primary">User Information</h3>
            <div class="flex space-x-2">
                <a href="{{ route('super-admin.users.edit', $user) }}" 
                   class="btn btn-primary">
                    Edit User
                </a>
                <a href="{{ route('super-admin.users.index') }}" 
                   class="btn btn-outline">
                    Back to Users
                </a>
            </div>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div class="space-y-4">
                <div>
                    <label class="block text-sm font-medium text-primary">Name</label>
                    <p class="mt-1 text-sm text-primary">{{ $user->name }}</p>
                </div>
                
                <div>
                    <label class="block text-sm font-medium text-primary">Email</label>
                    <p class="mt-1 text-sm text-primary">{{ $user->email }}</p>
                </div>
                
                <div>
                    <label class="block text-sm font-medium text-primary">Phone</label>
                    <p class="mt-1 text-sm text-primary">{{ $user->phone ?? 'N/A' }}</p>
                </div>
                
                <div>
                    <label class="block text-sm font-medium text-primary">Status</label>
                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                        {{ ($user->is_active ?? true) ? 'bg-green-100 dark:bg-green-900/20 text-green-800 dark:text-green-400' : 'bg-red-100 dark:bg-red-900/20 text-red-800 dark:text-red-400' }}">
                        {{ ($user->is_active ?? true) ? 'Active' : 'Inactive' }}
                    </span>
                </div>
            </div>
            
            <div class="space-y-4">
                <div>
                    <label class="block text-sm font-medium text-primary">Roles</label>
                    <div class="mt-1 flex flex-wrap gap-1">
                        @forelse($user->roles as $role)
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                @if($role->name === 'Super Admin') bg-indigo-100 dark:bg-indigo-900/20 text-indigo-800 dark:text-indigo-400
                                @elseif($role->name === 'Admin') bg-purple-100 dark:bg-purple-900/20 text-purple-800 dark:text-purple-400
                                @else bg-slate-100 dark:bg-slate-800 text-slate-800 dark:text-slate-200 @endif">
                                {{ $role->name }}
                            </span>
                        @empty
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-slate-100 dark:bg-slate-800 text-slate-800 dark:text-slate-200">
                                Customer
                            </span>
                        @endforelse
                    </div>
                </div>
                
                <div>
                    <label class="block text-sm font-medium text-primary">Member Since</label>
                    <p class="mt-1 text-sm text-primary">{{ $user->created_at->format('M d, Y') }}</p>
                </div>
                
                <div>
                    <label class="block text-sm font-medium text-primary">Last Updated</label>
                    <p class="mt-1 text-sm text-primary">{{ $user->updated_at->diffForHumans() }}</p>
                </div>
                
                <div>
                    <label class="block text-sm font-medium text-primary">Email Verified</label>
                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                        {{ $user->email_verified_at ? 'bg-green-100 dark:bg-green-900/20 text-green-800 dark:text-green-400' : 'bg-yellow-100 dark:bg-yellow-900/20 text-yellow-800 dark:text-yellow-400' }}">
                        {{ $user->email_verified_at ? 'Verified' : 'Not Verified' }}
                    </span>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Orders -->
    @if($user->orders->count() > 0)
        <div class="surface rounded-xl p-6">
            <h3 class="text-lg font-semibold text-primary mb-4">Recent Orders</h3>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-soft">
                    <thead class="bg-slate-50 dark:bg-slate-800/50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-muted uppercase">Order ID</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-muted uppercase">Date</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-muted uppercase">Items</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-muted uppercase">Total</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-muted uppercase">Status</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-soft">
                        @foreach($user->orders as $order)
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-primary">
                                    #{{ $order->id }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-muted">
                                    {{ $order->created_at->format('M d, Y') }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-muted">
                                    {{ $order->items->sum('quantity') }} items
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-primary">
                                    ₦{{ number_format($order->total_amount, 2) }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                        @if($order->status === 'completed') bg-green-100 dark:bg-green-900/20 text-green-800 dark:text-green-400
                                        @elseif($order->status === 'pending') bg-yellow-100 dark:bg-yellow-900/20 text-yellow-800 dark:text-yellow-400
                                        @elseif($order->status === 'cancelled') bg-red-100 dark:bg-red-900/20 text-red-800 dark:text-red-400
                                        @else bg-slate-100 dark:bg-slate-800 text-slate-800 dark:text-slate-200 @endif">
                                        {{ ucfirst($order->status) }}
                                    </span>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    @else
        <div class="surface rounded-xl p-6">
            <div class="text-center py-12">
                <svg class="mx-auto h-12 w-12 text-muted" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                </svg>
                <h3 class="mt-2 text-sm font-medium text-primary">No orders</h3>
                <p class="mt-1 text-sm text-muted">This user hasn't placed any orders yet.</p>
            </div>
        </div>
    @endif
</div>
@endsection