<?php
// Minimal icon generator (trimmed).
// Keeps: src/out/sizes/mode/safe/bg. Drops advanced flags (webp, verbose, transparency, orientation, summaries).
// Usage: php scripts/generate_icons.php [--src=path] [--out=dir] [--sizes=512,192,180] [--bg=#0f172a] [--mode=contain|cover] [--safe=0.76]

declare(strict_types=1);

function fail(string $m, int $c=1){fwrite(STDERR,$m."\n");exit($c);} function println(string $m){fwrite(STDOUT,$m."\n");}
function hex_to_rgb(string $hex): array { $hex=ltrim(trim($hex),'#'); if($hex==='') return [15,23,42]; if(strlen($hex)===3){$hex=$hex[0].$hex[0].$hex[1].$hex[1].$hex[2].$hex[2];} if(!preg_match('/^[0-9a-f]{6}$/i',$hex)) return [15,23,42]; return [hexdec(substr($hex,0,2)),hexdec(substr($hex,2,2)),hexdec(substr($hex,4,2))]; }
function ensure_dir(string $d){ if(!is_dir($d) && !mkdir($d,0775,true) && !is_dir($d)) fail("Cannot create dir $d",2);} 

$root=dirname(__DIR__); $defSrc=$root.'/public/assets/logo.png'; $defOut=$root.'/public/icons';
$opt=function_exists('getopt')?getopt('',['src::','out::','sizes::','bg::','mode::','safe::','help::']):[];
if(isset($opt['help'])){ println('Usage: php scripts/generate_icons.php [--src=path] [--out=dir] [--sizes=512,192,180] [--bg=#0f172a] [--mode=contain|cover] [--safe=0.76]'); exit(0);} 
$src=$opt['src']??$defSrc; $out=$opt['out']??$defOut; $sizesStr=$opt['sizes']??'512,192,180,32,16'; $bg=$opt['bg']??'#0f172a'; $mode= in_array($opt['mode']??'contain',['contain','cover'],true)?$opt['mode']??'contain':'contain'; $safe = isset($opt['safe'])? max(0.5,min(0.95,(float)$opt['safe'])):0.76;
if(!file_exists($src)) fail("Source not found: $src"); if(!is_readable($src)) fail("Source unreadable: $src"); ensure_dir($out);
$tokens=preg_split('/[\s,;]+/',$sizesStr); $sizes=[]; foreach($tokens as $t){ if($t!=='' && ctype_digit($t)){ $n=(int)$t; if($n>0) $sizes[$n]=true; }} if(!$sizes){ $sizes=[512=>true,192=>true,180=>true]; }
$sizes=array_keys($sizes); sort($sizes,SORT_NUMERIC);
$map=[]; foreach($sizes as $s){ $map[$s]= $s===180?'apple-touch-icon-180.png':(($s===512||$s===192)?"maskable-$s.png":"icon-$s.png"); }
[$r,$g,$b]=hex_to_rgb($bg);

if(class_exists('Imagick')){ try{ $img=new Imagick($src); $w=$img->getImageWidth(); $h=$img->getImageHeight(); foreach($map as $sz=>$name){ $canvas=new Imagick(); $canvas->newImage($sz,$sz,new ImagickPixel($bg),'png'); $safePx=(int)round($sz*$safe); $scale=$mode==='cover'?max($safePx/$w,$safePx/$h):min($safePx/$w,$safePx/$h); $dw=max(1,(int)round($w*$scale)); $dh=max(1,(int)round($h*$scale)); $tmp=clone $img; $tmp->resizeImage($dw,$dh,Imagick::FILTER_LANCZOS,1); $dx=(int)round(($sz-$dw)/2); $dy=(int)round(($sz-$dh)/2); $canvas->compositeImage($tmp,Imagick::COMPOSITE_OVER,$dx,$dy); $outPath=$out.DIRECTORY_SEPARATOR.$name; $canvas->writeImage($outPath); $canvas->clear(); $tmp->clear(); println("Wrote $outPath"); } $img->clear(); exit(0);}catch(Throwable $e){ /* fallback to GD */ }}

if(extension_loaded('gd')){ $ext=strtolower(pathinfo($src,PATHINFO_EXTENSION)); $loader= $ext==='png'?'imagecreatefrompng':(($ext==='jpg'||$ext==='jpeg')?'imagecreatefromjpeg':($ext==='gif'?'imagecreatefromgif':'imagecreatefrompng')); $im=@$loader($src); if(!$im) fail('GD cannot load source',3); imagesavealpha($im,true); $w=imagesx($im); $h=imagesy($im); foreach($map as $sz=>$name){ $canvas=imagecreatetruecolor($sz,$sz); imagesavealpha($canvas,true); $bgCol=imagecolorallocatealpha($canvas,$r,$g,$b,0); imagefill($canvas,0,0,$bgCol); $safePx=(int)round($sz*$safe); $scale=$mode==='cover'?max($safePx/$w,$safePx/$h):min($safePx/$w,$safePx/$h); $dw=max(1,(int)round($w*$scale)); $dh=max(1,(int)round($h*$scale)); $dx=(int)round(($sz-$dw)/2); $dy=(int)round(($sz-$dh)/2); imagealphablending($canvas,true); imagecopyresampled($canvas,$im,$dx,$dy,0,0,$dw,$dh,$w,$h); $outPath=$out.DIRECTORY_SEPARATOR.$name; imagepng($canvas,$outPath,9); imagedestroy($canvas); println("Wrote $outPath"); } imagedestroy($im); exit(0);} 

// Fallback: copy original
foreach($map as $sz=>$name){ $outPath=$out.DIRECTORY_SEPARATOR.$name; if(!@copy($src,$outPath)) fail("Copy failed: $outPath",4); println("Copied fallback $outPath"); }
exit(0);
