<?php
// Danger: drops the specified database (defaults to bonny_delight_laravel)
// Usage (PowerShell): php scripts/drop_db.php [dbName]

error_reporting(E_ALL);
ini_set('display_errors', '1');

$dbToDrop = $argv[1] ?? 'bonny_delight_laravel';

if (!$dbToDrop || in_array($dbToDrop, ['bonny_delight', 'mysql', 'information_schema', 'performance_schema', 'sys'], true)) {
    fwrite(STDERR, "Refusing to drop protected or production DB: {$dbToDrop}\n");
    exit(2);
}

$host = '127.0.0.1';
$user = 'root';
$pass = 'vick247$';

try {
    $pdo = new PDO("mysql:host={$host};charset=utf8mb4", $user, $pass, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    ]);
} catch (Throwable $e) {
    fwrite(STDERR, "Connection failed: {$e->getMessage()}\n");
    exit(1);
}

try {
    $pdo->exec("DROP DATABASE IF EXISTS `{$dbToDrop}`");
    echo "Dropped database (if it existed): {$dbToDrop}\n";
} catch (Throwable $e) {
    fwrite(STDERR, "Drop failed: {$e->getMessage()}\n");
    exit(1);
}

echo "Done.\n";
