<?php
/**
 * Script to remove all __() translation calls that may return arrays
 * and replace them with plain strings to prevent htmlspecialchars errors.
 */

$file = __DIR__ . '/resources/views/dashboard.blade.php';
$content = file_get_contents($file);

// Translation replacements map
$replacements = [
    "__('Some data is temporarily unavailable. Parts of the dashboard may be limited.')" => "'Some data is temporarily unavailable. Parts of the dashboard may be limited.'",
    "__('Active order')" => "'Active order'",
    "__('No active order')" => "'No active order'",
    "__('Active Order')" => "'Active Order'",
    "__('Total Orders')" => "'Total Orders'",
    "__('Avg Delivery (min)')" => "'Avg Delivery (min)'",
    "__('Rewards')" => "'Rewards'",
    "__('Addresses')" => "'Addresses'",
    "__('Favorites')" => "'Favorites'",
    "__('Your Account')" => "'Your Account'",
    "__('Favorite Dishes')" => "'Favorite Dishes'",
    "__('Saved Addresses')" => "'Saved Addresses'",
    "__('Recent Orders')" => "'Recent Orders'",
    "__('View All')" => "'View All'",
    "__('items')" => "'items'",
    "__('View')" => "'View'",
    "__('No orders yet')" => "'No orders yet'",
    "__('Start Ordering')" => "'Start Ordering'",
    "__('Your Favorites')" => "'Your Favorites'",
    "__('Browse Menu')" => "'Browse Menu'",
    "__('Add to Cart')" => "'Add to Cart'",
    "__('Delivery Addresses')" => "'Delivery Addresses'",
    "__('Manage')" => "'Manage'",
    "__('Primary')" => "'Primary'",
    "__('See rewards')" => "'See rewards'",
    "__('Order now')" => "'Order now'",
    "__('Free delivery over ₦:amount',['amount'=>number_format((int) (\\App\\Models\\Setting::get('delivery.free_threshold', 20000)),0)])" => "'Free delivery over ₦'.number_format((int) (\\App\\Models\\Setting::get('delivery.free_threshold', 20000)),0)",
    "__('Limited time offer. Automatic at checkout.')" => "'Limited time offer. Automatic at checkout.'",
    "__('New users get ₦500 off')" => "'New users get ₦500 off'",
    "__('Use code WELCOME500 at checkout.')" => "'Use code WELCOME500 at checkout.'",
];

foreach ($replacements as $search => $replace) {
    $content = str_replace($search, $replace, $content);
}

file_put_contents($file, $content);

echo "✅ Replaced " . count($replacements) . " translation calls in dashboard.blade.php\n";
