<?php
// Quick DB inspection script for local debugging
// Usage (PowerShell): php scripts/inspect_db.php

error_reporting(E_ALL);
ini_set('display_errors', '1');

$host = getenv('BONNY_DB_HOST') ?: '127.0.0.1';
$user = getenv('BONNY_DB_USER') ?: 'root';
$pass = getenv('BONNY_DB_PASS') ?: 'vick247$';
$db   = getenv('BONNY_DB_NAME') ?: 'bonny_delight';

$dsn = "mysql:host={$host};dbname={$db};charset=utf8mb4";
try {
    $pdo = new PDO($dsn, $user, $pass, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);
} catch (Throwable $e) {
    fwrite(STDERR, "Connection failed: {$e->getMessage()}\n");
    exit(1);
}

echo "Connected to {$db} on {$host}\n\n";

// List tables
$tables = $pdo->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
if (!$tables) {
    echo "No tables found.\n";
    exit(0);
}

foreach ($tables as $t) {
    $count = (int) $pdo->query("SELECT COUNT(*) FROM `{$t}`")->fetchColumn();
    echo sprintf("%-30s %8d rows\n", $t, $count);
}

// If "--schema" or "-s" is passed, print table schemas
$printSchema = in_array('--schema', $argv, true) || in_array('-s', $argv, true);

echo "\nSample records:\n";
foreach ([
    'users' => 'id,name,email,role,created_at',
    'categories' => 'id,name,created_at',
    'dishes' => 'id,name,price,category_id,created_at',
    'orders' => 'id,user_id,total,status,created_at',
] as $table => $cols) {
    if (!in_array($table, $tables, true)) continue;
    echo "\n== {$table} ==\n";
    $stmt = $pdo->query("SELECT {$cols} FROM `{$table}` ORDER BY id DESC LIMIT 3");
    foreach ($stmt as $row) {
        echo json_encode($row, JSON_PRETTY_PRINT) . "\n";
    }
}

if ($printSchema) {
    echo "\nSchemas:\n";
    foreach ($tables as $t) {
        echo "\n-- {$t} --\n";
        $cols = $pdo->query("SHOW COLUMNS FROM `{$t}`")->fetchAll();
        foreach ($cols as $c) {
            echo sprintf("%-24s %-20s %s\n", $c['Field'], $c['Type'], $c['Null'] === 'NO' ? 'NOT NULL' : 'NULL');
        }
    }
}

echo "\nDone.\n";
