Windows Dev Tools Setup

This folder contains automation scripts to install Node.js LTS, Python 3, Git, Composer, and the Laravel installer on Windows. The scripts try winget first and fall back to Scoop when winget is blocked or unavailable.

Files
- install-dev-tools.ps1 — Main installer. Installs Git, Node.js (npm), Python, Composer, and Laravel installer. Optional Yarn/pnpm and Visual Studio Build Tools.
- validate-dev-tools.ps1 — Prints versions of installed tools to verify everything is wired correctly.

Usage
1) Open PowerShell and allow script execution for your user:

   Set-ExecutionPolicy -Scope CurrentUser -ExecutionPolicy RemoteSigned -Force

2) Run the installer from the project root:

   ./scripts/windows/install-dev-tools.ps1

   Optional flags:
   -WithYarnPnpm        Install Yarn and pnpm globally via npm
   -WithVSBuildTools    Attempt Visual Studio 2022 Build Tools install (may require Administrator)
   -UseSystemScope      Try system-wide winget installs instead of per-user

   Examples:
   ./scripts/windows/install-dev-tools.ps1 -WithYarnPnpm
   ./scripts/windows/install-dev-tools.ps1 -UseSystemScope -WithVSBuildTools

3) Close and re-open PowerShell to refresh PATH.

4) Validate:

   ./scripts/windows/validate-dev-tools.ps1

Notes
- If winget fails silently or needs elevation, the script will fall back to Scoop (no admin required).
- If Composer couldn’t be installed, the script will use the repository’s composer.phar with XAMPP PHP when possible.
- If commands are still not found, open a new terminal window to reload PATH or reboot.
