<#
  backup_db.ps1
  Simple MySQL backup script for the bonny_delight database.
  Usage (PowerShell):
    powershell -ExecutionPolicy Bypass -File .\scripts\windows\backup_db.ps1

  You can schedule this with Windows Task Scheduler (daily).
#>

param(
  [string]$MysqlBin = 'C:\xampp\mysql\bin',
  [string]$Database = 'bonny_delight',
  [string]$User = 'root',
  [string]$Password = 'vick247$'
)

$date = Get-Date -Format 'yyyyMMdd_HHmmss'
$backupDir = Join-Path -Path (Resolve-Path '..\..\backups' ) -ChildPath ''
if (-not (Test-Path $backupDir)) { New-Item -ItemType Directory -Path $backupDir | Out-Null }

$dumpFile = Join-Path $backupDir "$Database-$date.sql"
$zipFile  = "$dumpFile.zip"

Write-Host "[INFO] Dumping $Database to $dumpFile" -ForegroundColor Cyan

$mysqldump = Join-Path $MysqlBin 'mysqldump.exe'
if (-not (Test-Path $mysqldump)) { Write-Error "mysqldump not found at $mysqldump"; exit 1 }

& $mysqldump --routines --events --single-transaction --quick --skip-lock-tables -u $User --password=$Password $Database > $dumpFile
if ($LASTEXITCODE -ne 0) { Write-Error 'mysqldump failed'; exit 1 }

Compress-Archive -Path $dumpFile -DestinationPath $zipFile -Force
Remove-Item $dumpFile

Write-Host "[OK] Backup complete: $zipFile" -ForegroundColor Green

# Optional: prune backups older than 14 days
Get-ChildItem $backupDir -Filter "$Database-*.sql.zip" | Where-Object { $_.LastWriteTime -lt (Get-Date).AddDays(-14) } | ForEach-Object {
  Write-Host "[PRUNE] Removing $($_.Name)" -ForegroundColor Yellow
  Remove-Item $_.FullName -Force
}

Write-Host '[DONE]' -ForegroundColor Green