<#
.SYNOPSIS
  Bootstraps the Laravel app under bonny_app: composer install, .env, key:generate, migrate, npm build.

.DESCRIPTION
  Uses global Composer if available, otherwise falls back to repository composer.phar with XAMPP PHP.
  Requires Node.js (npm) for front-end build. Ensure MySQL is running in XAMPP.
#>

param(
  [string]$AppDir = "c:\xampp\htdocs\bonny_delight\bonny_app"
)

Set-StrictMode -Version Latest
$ErrorActionPreference = 'Stop'

function Test-Command($name) { return [bool](Get-Command $name -ErrorAction SilentlyContinue) }

function Run-Composer($args) {
  if (Test-Command 'composer') {
    composer @args
  } else {
    $php = 'C:\xampp\php\php.exe'
    $phar = 'c:\xampp\htdocs\bonny_delight\composer.phar'
    if (-not (Test-Path $php -PathType Leaf)) { throw 'PHP not found at C:\xampp\php\php.exe' }
    if (-not (Test-Path $phar -PathType Leaf)) { throw 'composer.phar not found in repository root' }
    & $php $phar @args
  }
}

if (-not (Test-Path $AppDir -PathType Container)) { throw "App directory not found: $AppDir" }
Push-Location $AppDir
try {
  Write-Host 'Composer install...'
  Run-Composer @('install','--no-interaction')

  if (-not (Test-Path '.env' -PathType Leaf)) {
    Write-Host 'Copy .env.example to .env'
    Copy-Item .env.example .env -Force
  }

  if (Test-Command 'php') {
    php artisan key:generate
  } else {
    & 'C:\xampp\php\php.exe' artisan key:generate
  }

  Write-Host 'Running migrations...'
  if (Test-Command 'php') {
    php artisan migrate
  } else {
    & 'C:\xampp\php\php.exe' artisan migrate
  }

  Write-Host 'Installing npm dependencies and building assets...'
  if (-not (Test-Command 'npm')) { throw 'npm not found. Install Node.js first.' }
  npm install
  npm run build

  Write-Host 'Bootstrap complete.' -ForegroundColor Green
} finally {
  Pop-Location
}
