Set-StrictMode -Version Latest
$ErrorActionPreference = 'Stop'

function Test-Command($name) { return [bool](Get-Command $name -ErrorAction SilentlyContinue) }

Write-Host "PowerShell: $($PSVersionTable.PSVersion.ToString())"
Write-Host "winget:     $((Get-Command winget -ErrorAction SilentlyContinue)?.Source ?? 'Not found')"
Write-Host "Scoop:      $((Get-Command scoop -ErrorAction SilentlyContinue)?.Source ?? 'Not found')"

Write-Host ('Node.js:   ' + ($(if (Test-Command node) { node -v } else { 'Not found' })))
Write-Host ('npm:       ' + ($(if (Test-Command npm) { npm -v } else { 'Not found' })))
Write-Host ('Python:    ' + ($(if (Test-Command python) { python --version } else { 'Not found' })))
Write-Host ('py:        ' + ($(if (Test-Command py) { py --version } else { 'Not found' })))
Write-Host ('Git:       ' + ($(if (Test-Command git) { git --version } else { 'Not found' })))
Write-Host ('PHP:       ' + ($(if (Test-Command php) { (php -v | Select-String -Pattern 'PHP').Line } else { 'Not found (XAMPP available at C:\\xampp\\php\\php.exe)' })))
Write-Host ('Composer:  ' + ($(if (Test-Command composer) { composer --version } else { 'Not found (composer.phar may be available in repo)' })))
Write-Host ('Laravel:   ' + ($(if (Test-Command laravel) { laravel --version } else { 'Not found' })))
