<?php
  $cart = session('cart', ['items' => []]);
  $ids = array_keys($cart['items']);
  $dishes = count($ids) ? \App\Models\Dish::whereIn('id',$ids)->get()->keyBy('id') : collect();
  $count = 0; $subtotal = 0;
  foreach($cart['items'] as $id => $qty){
    $dish = $dishes[$id] ?? null; if(!$dish) continue;
    $q = is_array($qty) && isset($qty['qty']) ? (int)$qty['qty'] : (int)$qty;
    $count += $q; $subtotal += ((float)$dish->price) * $q;
  }
  $belowMin = false; $atCapacity = false; $minSubtotal = 0; $capacityMsg = null;
  try {
    $minSubtotal = (float) \App\Models\Setting::get('order.min_subtotal', 0);
    $belowMin = $subtotal > 0 && $subtotal < $minSubtotal;
    $maxOpen = (int) \App\Models\Setting::get('capacity.max_open_orders', 0);
    if($maxOpen > 0){ $atCapacity = \App\Models\Order::openOrdersCount() >= $maxOpen; }
    if($atCapacity) { $capacityMsg = 'High kitchen load – prep may be slower'; }
  } catch (Throwable $e) { /* swallow */ }
?>
<!--__FC_START__-->
<?php if($count > 0): ?>
<div x-data="{ open: false }" class="fixed bottom-4 right-4 z-50 w-80 max-w-[92%]">
  <div class="surface rounded-xl shadow-lg border-subtle p-4 relative overflow-hidden">
    <div class="absolute inset-0 pointer-events-none opacity-[0.08] bg-[radial-gradient(circle_at_30%_20%,rgba(var(--brand-secondary)/0.65),transparent_70%)]"></div>
    <div class="flex items-start gap-3 relative">
      <div class="shrink-0 flex items-center justify-center w-10 h-10 rounded-full bg-primary/90 text-white shadow">
        <i data-lucide="shopping-bag" class="w-5 h-5"></i>
      </div>
      <div class="flex-1">
        <div class="flex items-center justify-between gap-2">
          <h3 class="text-sm font-semibold">Your Cart</h3>
          <button @click="open = !open" class="text-xs px-2 py-1 rounded-full bg-white/40 dark:bg-slate-700/60 hover:bg-white/60 dark:hover:bg-slate-600/60 border border-white/30 dark:border-slate-600/40 transition">
            <span x-show="!open">Details</span>
            <span x-show="open">Hide</span>
          </button>
        </div>
        <div class="mt-1 text-xs text-muted"><?php echo e($count); ?> item<?php echo e($count!==1?'s':''); ?> • ₦<?php echo e(number_format($subtotal,2)); ?></div>
        <?php if($belowMin): ?>
          <div class="mt-1 text-[11px] text-amber-600 dark:text-amber-400">Add ₦<?php echo e(number_format($minSubtotal - $subtotal,2)); ?> more to reach minimum.</div>
        <?php endif; ?>
        <?php if($capacityMsg): ?>
          <div class="mt-1 text-[11px] text-rose-600 dark:text-rose-400"><?php echo e($capacityMsg); ?></div>
        <?php endif; ?>
  <div x-show="open" x-transition.origin.top.left class="mt-3 space-y-2 pr-1 max-h-48 overflow-y-auto text-xs" x-cloak style="display:none;">
          <?php $__currentLoopData = $cart['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $qty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php $dish = $dishes[$id] ?? null; if(!$dish) continue; $q = is_array($qty)&&isset($qty['qty'])?(int)$qty['qty']:(int)$qty; ?>
            <div class="flex items-center justify-between gap-2">
              <div class="truncate font-medium"><?php echo e($dish->name); ?></div>
              <div class="tabular-nums">×<?php echo e($q); ?></div>
              <div class="tabular-nums font-semibold">₦<?php echo e(number_format(((float)$dish->price)*$q,2)); ?></div>
            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <div class="mt-4 flex items-center gap-2">
          <a href="<?php echo e(route('cart.index')); ?>" class="btn btn-outline flex-1 justify-center text-xs">View Cart</a>
          <?php if(auth()->guard()->check()): ?>
            <a href="<?php echo e(route('checkout.index')); ?>" class="btn btn-primary flex-1 justify-center text-xs <?php echo e($count===0 ? 'pointer-events-none opacity-60' : ''); ?>">Checkout</a>
          <?php else: ?>
            <a href="<?php echo e(route('login')); ?>" class="btn btn-primary flex-1 justify-center text-xs">Login</a>
          <?php endif; ?>
        </div>
      </div>
    </div>
    <button type="button" class="absolute -top-2 -right-2 bg-slate-900/70 dark:bg-slate-700/80 text-white rounded-full w-7 h-7 flex items-center justify-center shadow hover:brightness-110" aria-label="Close" @click="$el.parentElement.remove()"><i data-lucide="x" class="w-4 h-4"></i></button>
  </div>
</div>
<?php endif; ?>
<!--__FC_END__--><?php /**PATH C:\xampp\htdocs\bonny_delight\resources\views/components/cart/floating-summary.blade.php ENDPATH**/ ?>