<nav class="h-full w-full flex flex-col">
  <!-- Brand -->
  <div class="h-16 flex items-center px-3 border-b border-white/30 dark:border-slate-700/50">
    <a href="<?php echo e(route('admin.dashboard')); ?>" class="flex items-center gap-2 w-full" :class="collapsed ? 'justify-center' : ''" title="Admin">
  <img src="<?php echo e(asset('assets/logo.png')); ?>" alt="<?php echo e(config('app.name')); ?>" class="w-8 h-8 rounded" onerror="this.onerror=null;this.src='<?php echo e(asset('assets/placeholders/qr-placeholder.svg')); ?>';">
      <span class="font-semibold truncate" x-show="!collapsed" x-transition.opacity>Admin</span>
    </a>
  </div>

  <!-- Navigation -->
  <div class="flex-1 overflow-y-auto py-3">
    <ul class="px-2 space-y-1 text-sm">
      <li>
        <a href="<?php echo e(route('admin.dashboard')); ?>" title="Dashboard" :class="collapsed ? 'justify-center' : ''" class="group relative flex items-center gap-3 rounded px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800 border-l-2 <?php if(request()->routeIs('admin.dashboard')): ?> bg-slate-50 dark:bg-slate-800 border-indigo-600 <?php else: ?> border-transparent <?php endif; ?>">
          <i data-lucide="home" class="w-5 h-5"></i>
          <span x-show="!collapsed" x-transition:enter="transition-all duration-200" x-transition:enter-start="opacity-0 max-w-0" x-transition:enter-end="opacity-100 max-w-[200px]" x-transition:leave="transition-all duration-150" x-transition:leave-start="opacity-100 max-w-[200px]" x-transition:leave-end="opacity-0 max-w-0" class="whitespace-nowrap overflow-hidden">Dashboard</span>
          <span x-show="collapsed" x-transition.opacity class="pointer-events-none absolute left-full top-1/2 -translate-y-1/2 ml-2 px-2 py-1 rounded bg-slate-900 text-white text-xs shadow-lg whitespace-nowrap hidden group-hover:block">Dashboard</span>
        </a>
      </li>
      <li>
        <a href="<?php echo e(route('admin.orders.index')); ?>" title="Orders" :class="collapsed ? 'justify-center' : ''" class="group relative flex items-center gap-3 rounded px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800 border-l-2 <?php if(request()->routeIs('admin.orders.*')): ?> bg-slate-50 dark:bg-slate-800 border-indigo-600 <?php else: ?> border-transparent <?php endif; ?>">
          <i data-lucide="receipt" class="w-5 h-5"></i>
          <span x-show="!collapsed" x-transition:enter="transition-all duration-200" x-transition:enter-start="opacity-0 max-w-0" x-transition:enter-end="opacity-100 max-w-[200px]" x-transition:leave="transition-all duration-150" x-transition:leave-start="opacity-100 max-w-[200px]" x-transition:leave-end="opacity-0 max-w-0" class="whitespace-nowrap overflow-hidden">Orders</span>
          <span x-show="collapsed" x-transition.opacity class="pointer-events-none absolute left-full top-1/2 -translate-y-1/2 ml-2 px-2 py-1 rounded bg-slate-900 text-white text-xs shadow-lg whitespace-nowrap hidden group-hover:block">Orders</span>
        </a>
      </li>
      <li>
        <a href="<?php echo e(route('admin.addresses.index')); ?>" title="Addresses" :class="collapsed ? 'justify-center' : ''" class="group relative flex items-center gap-3 rounded px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800 border-l-2 <?php if(request()->routeIs('admin.addresses.*')): ?> bg-slate-50 dark:bg-slate-800 border-indigo-600 <?php else: ?> border-transparent <?php endif; ?>">
          <i data-lucide="map-pin" class="w-5 h-5"></i>
          <span x-show="!collapsed" x-transition:enter="transition-all duration-200" x-transition:enter-start="opacity-0 max-w-0" x-transition:enter-end="opacity-100 max-w-[200px]" x-transition:leave="transition-all duration-150" x-transition:leave-start="opacity-100 max-w-[200px]" x-transition:leave-end="opacity-0 max-w-0" class="whitespace-nowrap overflow-hidden">Addresses</span>
          <span x-show="collapsed" x-transition.opacity class="pointer-events-none absolute left-full top-1/2 -translate-y-1/2 ml-2 px-2 py-1 rounded bg-slate-900 text-white text-xs shadow-lg whitespace-nowrap hidden group-hover:block">Addresses</span>
        </a>
      </li>
      <li>
        <a href="<?php echo e(route('admin.categories.index')); ?>" title="Categories" :class="collapsed ? 'justify-center' : ''" class="group relative flex items-center gap-3 rounded px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800 border-l-2 <?php if(request()->routeIs('admin.categories.*')): ?> bg-slate-50 dark:bg-slate-800 border-indigo-600 <?php else: ?> border-transparent <?php endif; ?>">
          <i data-lucide="layout-grid" class="w-5 h-5"></i>
          <span x-show="!collapsed" x-transition:enter="transition-all duration-200" x-transition:enter-start="opacity-0 max-w-0" x-transition:enter-end="opacity-100 max-w-[200px]" x-transition:leave="transition-all duration-150" x-transition:leave-start="opacity-100 max-w-[200px]" x-transition:leave-end="opacity-0 max-w-0" class="whitespace-nowrap overflow-hidden">Categories</span>
          <span x-show="collapsed" x-transition.opacity class="pointer-events-none absolute left-full top-1/2 -translate-y-1/2 ml-2 px-2 py-1 rounded bg-slate-900 text-white text-xs shadow-lg whitespace-nowrap hidden group-hover:block">Categories</span>
        </a>
      </li>
      <li>
        <a href="<?php echo e(route('admin.dishes.index')); ?>" title="Dishes" :class="collapsed ? 'justify-center' : ''" class="group relative flex items-center gap-3 rounded px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800 border-l-2 <?php if(request()->routeIs('admin.dishes.*')): ?> bg-slate-50 dark:bg-slate-800 border-indigo-600 <?php else: ?> border-transparent <?php endif; ?>">
          <i data-lucide="utensils" class="w-5 h-5"></i>
          <span x-show="!collapsed" x-transition:enter="transition-all duration-200" x-transition:enter-start="opacity-0 max-w-0" x-transition:enter-end="opacity-100 max-w-[200px]" x-transition:leave="transition-all duration-150" x-transition:leave-start="opacity-100 max-w-[200px]" x-transition:leave-end="opacity-0 max-w-0" class="whitespace-nowrap overflow-hidden">Dishes</span>
          <span x-show="collapsed" x-transition.opacity class="pointer-events-none absolute left-full top-1/2 -translate-y-1/2 ml-2 px-2 py-1 rounded bg-slate-900 text-white text-xs shadow-lg whitespace-nowrap hidden group-hover:block">Dishes</span>
        </a>
      </li>
      <li>
        <a href="<?php echo e(route('admin.inventory.index')); ?>" title="Inventory" :class="collapsed ? 'justify-center' : ''" class="group relative flex items-center gap-3 rounded px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800 border-l-2 <?php if(request()->routeIs('admin.inventory.*')): ?> bg-slate-50 dark:bg-slate-800 border-indigo-600 <?php else: ?> border-transparent <?php endif; ?>">
          <i data-lucide="package" class="w-5 h-5"></i>
          <span x-show="!collapsed" x-transition:enter="transition-all duration-200" x-transition:enter-start="opacity-0 max-w-0" x-transition:enter-end="opacity-100 max-w-[200px]" x-transition:leave="transition-all duration-150" x-transition:leave-start="opacity-100 max-w-[200px]" x-transition:leave-end="opacity-0 max-w-0" class="whitespace-nowrap overflow-hidden">Inventory</span>
          <span x-show="collapsed" x-transition.opacity class="pointer-events-none absolute left-full top-1/2 -translate-y-1/2 ml-2 px-2 py-1 rounded bg-slate-900 text-white text-xs shadow-lg whitespace-nowrap hidden group-hover:block">Inventory</span>
        </a>
      </li>
      <li>
        <a href="<?php echo e(route('admin.inventory.availability')); ?>" title="Availability" :class="collapsed ? 'justify-center' : ''" class="group relative flex items-center gap-3 rounded px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800 border-l-2 <?php if(request()->routeIs('admin.inventory.availability')): ?> bg-slate-50 dark:bg-slate-800 border-indigo-600 <?php else: ?> border-transparent <?php endif; ?>">
          <i data-lucide="warehouse" class="w-5 h-5"></i>
          <span x-show="!collapsed" x-transition:enter="transition-all duration-200" x-transition:enter-start="opacity-0 max-w-0" x-transition:enter-end="opacity-100 max-w-[200px]" x-transition:leave="transition-all duration-150" x-transition:leave-start="opacity-100 max-w-[200px]" x-transition:leave-end="opacity-0 max-w-0" class="whitespace-nowrap overflow-hidden">Availability</span>
          <span x-show="collapsed" x-transition.opacity class="pointer-events-none absolute left-full top-1/2 -translate-y-1/2 ml-2 px-2 py-1 rounded bg-slate-900 text-white text-xs shadow-lg whitespace-nowrap hidden group-hover:block">Availability</span>
        </a>
      </li>
      <li>
        <a href="<?php echo e(route('admin.inventory.availability.pivot')); ?>" title="Availability Pivot" :class="collapsed ? 'justify-center' : ''" class="group relative flex items-center gap-3 rounded px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800 border-l-2 <?php if(request()->routeIs('admin.inventory.availability.pivot')): ?> bg-slate-50 dark:bg-slate-800 border-indigo-600 <?php else: ?> border-transparent <?php endif; ?>">
          <i data-lucide="grid" class="w-5 h-5"></i>
          <span x-show="!collapsed" x-transition:enter="transition-all duration-200" x-transition:enter-start="opacity-0 max-w-0" x-transition:enter-end="opacity-100 max-w-[200px]" x-transition:leave="transition-all duration-150" x-transition:leave-start="opacity-100 max-w-[200px]" x-transition:leave-end="opacity-0 max-w-0" class="whitespace-nowrap overflow-hidden">Availability Pivot</span>
          <span x-show="collapsed" x-transition.opacity class="pointer-events-none absolute left-full top-1/2 -translate-y-1/2 ml-2 px-2 py-1 rounded bg-slate-900 text-white text-xs shadow-lg whitespace-nowrap hidden group-hover:block">Pivot</span>
        </a>
      </li>
      <li>
        <a href="<?php echo e(route('admin.locations.index')); ?>" title="Locations" :class="collapsed ? 'justify-center' : ''" class="group relative flex items-center gap-3 rounded px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800 border-l-2 <?php if(request()->routeIs('admin.locations.*')): ?> bg-slate-50 dark:bg-slate-800 border-indigo-600 <?php else: ?> border-transparent <?php endif; ?>">
          <i data-lucide="map" class="w-5 h-5"></i>
          <span x-show="!collapsed" x-transition:enter="transition-all duration-200" x-transition:enter-start="opacity-0 max-w-0" x-transition:enter-end="opacity-100 max-w-[200px]" x-transition:leave="transition-all duration-150" x-transition:leave-start="opacity-100 max-w-[200px]" x-transition:leave-end="opacity-0 max-w-0" class="whitespace-nowrap overflow-hidden">Locations</span>
          <span x-show="collapsed" x-transition.opacity class="pointer-events-none absolute left-full top-1/2 -translate-y-1/2 ml-2 px-2 py-1 rounded bg-slate-900 text-white text-xs shadow-lg whitespace-nowrap hidden group-hover:block">Locations</span>
        </a>
      </li>
      <li>
        <a href="<?php echo e(route('admin.reporting.index')); ?>" title="Reporting & KPIs" :class="collapsed ? 'justify-center' : ''" class="group relative flex items-center gap-3 rounded px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800 border-l-2 <?php if(request()->routeIs('admin.reporting.*')): ?> bg-slate-50 dark:bg-slate-800 border-indigo-600 <?php else: ?> border-transparent <?php endif; ?>">
          <i data-lucide="bar-chart-3" class="w-5 h-5"></i>
          <span x-show="!collapsed" x-transition:enter="transition-all duration-200" x-transition:enter-start="opacity-0 max-w-0" x-transition:enter-end="opacity-100 max-w-[200px]" x-transition:leave="transition-all duration-150" x-transition:leave-start="opacity-100 max-w-[200px]" x-transition:leave-end="opacity-0 max-w-0" class="whitespace-nowrap overflow-hidden">Reporting</span>
          <span x-show="collapsed" x-transition.opacity class="pointer-events-none absolute left-full top-1/2 -translate-y-1/2 ml-2 px-2 py-1 rounded bg-slate-900 text-white text-xs shadow-lg whitespace-nowrap hidden group-hover:block">Reporting & KPIs</span>
        </a>
      </li>
        <li>
          <a href="<?php echo e(route('admin.contact-messages.index')); ?>" title="Contact Messages" :class="collapsed ? 'justify-center' : ''" class="group relative flex items-center gap-3 rounded px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800 border-l-2 <?php if(request()->routeIs('admin.contact-messages.*')): ?> bg-slate-50 dark:bg-slate-800 border-indigo-600 <?php else: ?> border-transparent <?php endif; ?>">
            <i data-lucide="inbox" class="w-5 h-5"></i>
            <span x-show="!collapsed" x-transition:enter="transition-all duration-200" x-transition:enter-start="opacity-0 max-w-0" x-transition:enter-end="opacity-100 max-w-[200px]" x-transition:leave="transition-all duration-150" x-transition:leave-start="opacity-100 max-w-[200px]" x-transition:leave-end="opacity-0 max-w-0" class="whitespace-nowrap overflow-hidden">Contact</span>
            <span x-show="collapsed" x-transition.opacity class="pointer-events-none absolute left-full top-1/2 -translate-y-1/2 ml-2 px-2 py-1 rounded bg-slate-900 text-white text-xs shadow-lg whitespace-nowrap hidden group-hover:block">Contact</span>
          </a>
        </li>
      <li>
        <a href="<?php echo e(route('admin.settings.index')); ?>" title="Settings" :class="collapsed ? 'justify-center' : ''" class="group relative flex items-center gap-3 rounded px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800 border-l-2 <?php if(request()->routeIs('admin.settings.*')): ?> bg-slate-50 dark:bg-slate-800 border-indigo-600 <?php else: ?> border-transparent <?php endif; ?>">
          <i data-lucide="settings" class="w-5 h-5"></i>
          <span x-show="!collapsed" x-transition:enter="transition-all duration-200" x-transition:enter-start="opacity-0 max-w-0" x-transition:enter-end="opacity-100 max-w-[200px]" x-transition:leave="transition-all duration-150" x-transition:leave-start="opacity-100 max-w-[200px]" x-transition:leave-end="opacity-0 max-w-0" class="whitespace-nowrap overflow-hidden">Settings</span>
          <span x-show="collapsed" x-transition.opacity class="pointer-events-none absolute left-full top-1/2 -translate-y-1/2 ml-2 px-2 py-1 rounded bg-slate-900 text-white text-xs shadow-lg whitespace-nowrap hidden group-hover:block">Settings</span>
        </a>
      </li>
    </ul>
  </div>

  <!-- Footer -->
  <div class="p-3 border-t border-white/30 dark:border-slate-700/50">
    <div class="space-y-1">
      <!-- View Site Button -->
      <a href="<?php echo e(route('home')); ?>" target="_blank" title="View Site" :class="collapsed ? 'justify-center' : ''" class="group relative w-full inline-flex items-center gap-2 rounded px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800 border-l-2 border-transparent transition-colors text-sm">
        <i data-lucide="external-link" class="w-4 h-4"></i>
        <span x-show="!collapsed" x-transition:enter="transition-all duration-200" x-transition:enter-start="opacity-0 max-w-0" x-transition:enter-end="opacity-100 max-w-[200px]" x-transition:leave="transition-all duration-150" x-transition:leave-start="opacity-100 max-w-[200px]" x-transition:leave-end="opacity-0 max-w-0" class="whitespace-nowrap overflow-hidden">View Site</span>
        <span x-show="collapsed" x-transition.opacity class="pointer-events-none absolute left-full top-1/2 -translate-y-1/2 ml-2 px-2 py-1 rounded bg-slate-900 dark:bg-slate-700 text-white dark:text-slate-200 text-xs shadow-lg whitespace-nowrap hidden group-hover:block z-50">View Site</span>
      </a>
      
      <!-- Light/Dark Theme Toggle Button -->
      <button onclick="toggleTheme()" title="Toggle Theme" :class="collapsed ? 'justify-center' : ''" class="group relative w-full inline-flex items-center gap-2 rounded px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800 border-l-2 border-transparent transition-colors text-sm">
        <i data-lucide="sun" class="w-4 h-4 dark:hidden"></i>
        <i data-lucide="moon" class="w-4 h-4 hidden dark:block"></i>
        <span x-show="!collapsed" x-transition:enter="transition-all duration-200" x-transition:enter-start="opacity-0 max-w-0" x-transition:enter-end="opacity-100 max-w-[200px]" x-transition:leave="transition-all duration-150" x-transition:leave-start="opacity-100 max-w-[200px]" x-transition:leave-end="opacity-0 max-w-0" class="whitespace-nowrap overflow-hidden">
          <span class="dark:hidden">Light Mode</span>
          <span class="hidden dark:inline">Dark Mode</span>
        </span>
        <span x-show="collapsed" x-transition.opacity class="pointer-events-none absolute left-full top-1/2 -translate-y-1/2 ml-2 px-2 py-1 rounded bg-slate-900 dark:bg-slate-700 text-white dark:text-slate-200 text-xs shadow-lg whitespace-nowrap hidden group-hover:block z-50">
          <span class="dark:hidden">Light Mode</span>
          <span class="hidden dark:inline">Dark Mode</span>
        </span>
      </button>
      
      <!-- Logout Button (GET) -->
      <a href="<?php echo e(route('logout.get')); ?>" title="Logout" :class="collapsed ? 'justify-center' : ''" class="group relative w-full inline-flex items-center gap-2 rounded px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800 border-l-2 border-transparent transition-colors text-sm">
        <i data-lucide="log-out" class="w-4 h-4"></i>
        <span x-show="!collapsed" x-transition:enter="transition-all duration-200" x-transition:enter-start="opacity-0 max-w-0" x-transition:enter-end="opacity-100 max-w-[200px]" x-transition:leave="transition-all duration-150" x-transition:leave-start="opacity-100 max-w-[200px]" x-transition:leave-end="opacity-0 max-w-0" class="whitespace-nowrap overflow-hidden">Logout</span>
        <span x-show="collapsed" x-transition.opacity class="pointer-events-none absolute left-full top-1/2 -translate-y-1/2 ml-2 px-2 py-1 rounded bg-slate-900 dark:bg-slate-700 text-white dark:text-slate-200 text-xs shadow-lg whitespace-nowrap hidden group-hover:block z-50">Logout</span>
      </a>
    </div>
  </div>
</nav>
<?php /**PATH C:\xampp\htdocs\bonny_delight\resources\views/components/admin/sidebar.blade.php ENDPATH**/ ?>