<?php if (isset($component)) { $__componentOriginal91fdd17964e43374ae18c674f95cdaa3 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3 = $attributes; } ?>
<?php $component = App\View\Components\AdminLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AdminLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
  <div class="space-y-6">
    <div class="flex items-center justify-between">
      <div>
        <h1 class="text-2xl font-semibold text-gray-900 dark:text-white">📊 Reporting & KPIs</h1>
        <p class="text-gray-600 dark:text-gray-400">Comprehensive business metrics and performance indicators</p>
      </div>
      <div class="flex space-x-3">
        <a href="<?php echo e(route('admin.reporting.export', request()->query())); ?>" 
           class="inline-flex items-center px-4 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700 transition-colors">
          <i data-lucide="download" class="w-4 h-4 mr-2"></i>
          Export CSV
        </a>
        <button onclick="clearCache()" 
                class="inline-flex items-center px-4 py-2 bg-gray-600 text-white rounded-lg hover:bg-gray-700 transition-colors">
          <i data-lucide="refresh-cw" class="w-4 h-4 mr-2"></i>
          Clear Cache
        </button>
      </div>
    </div>

    
    <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50 p-6">
      <form method="GET" action="<?php echo e(route('admin.reporting.index')); ?>" class="space-y-4">
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
          <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Time Window</label>
            <select name="window" class="w-full border border-gray-300 dark:border-gray-600 rounded-lg px-3 py-2 bg-white dark:bg-slate-900 text-gray-900 dark:text-white">
              <option value="daily" <?php echo e($window === 'daily' ? 'selected' : ''); ?>>Today</option>
              <option value="weekly" <?php echo e($window === 'weekly' ? 'selected' : ''); ?>>Last 7 Days</option>
              <option value="monthly" <?php echo e($window === 'monthly' ? 'selected' : ''); ?>>Last 30 Days</option>
            </select>
          </div>
          <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Start Date (Optional)</label>
            <input type="date" name="start_date" value="<?php echo e(request('start_date')); ?>" 
                   class="w-full border border-gray-300 dark:border-gray-600 rounded-lg px-3 py-2 bg-white dark:bg-slate-900 text-gray-900 dark:text-white">
          </div>
          <div>
            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">End Date (Optional)</label>
            <input type="date" name="end_date" value="<?php echo e(request('end_date')); ?>" 
                   class="w-full border border-gray-300 dark:border-gray-600 rounded-lg px-3 py-2 bg-white dark:bg-slate-900 text-gray-900 dark:text-white">
          </div>
          <div class="flex items-end">
            <button type="submit" class="w-full px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
              <i data-lucide="search" class="w-4 h-4 mr-2 inline"></i>
              Generate Report
            </button>
          </div>
        </div>
      </form>
    </div>

    
    <div class="bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-4">
      <div class="flex items-center">
        <i data-lucide="calendar" class="w-5 h-5 text-blue-600 dark:text-blue-400 mr-2"></i>
        <span class="text-blue-800 dark:text-blue-200">
          Report Period: <strong><?php echo e($report['period']['start_date']); ?></strong> to <strong><?php echo e($report['period']['end_date']); ?></strong>
          (<?php echo e(ucfirst($window)); ?> Window)
        </span>
      </div>
    </div>

    
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
      
      <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50 p-6">
        <div class="flex items-center">
          <div class="p-2 bg-green-100 dark:bg-green-900/50 rounded-lg">
            <i data-lucide="dollar-sign" class="w-6 h-6 text-green-600 dark:text-green-400"></i>
          </div>
          <div class="ml-4">
            <p class="text-sm font-medium text-gray-500 dark:text-gray-400">Gross Sales</p>
            <p class="text-2xl font-semibold text-gray-900 dark:text-white">₦<?php echo e(number_format($report['sales_metrics']['gross_sales'], 2)); ?></p>
          </div>
        </div>
      </div>

      
      <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50 p-6">
        <div class="flex items-center">
          <div class="p-2 bg-blue-100 dark:bg-blue-900/50 rounded-lg">
            <i data-lucide="trending-up" class="w-6 h-6 text-blue-600 dark:text-blue-400"></i>
          </div>
          <div class="ml-4">
            <p class="text-sm font-medium text-gray-500 dark:text-gray-400">Net Sales</p>
            <p class="text-2xl font-semibold text-gray-900 dark:text-white">₦<?php echo e(number_format($report['sales_metrics']['net_sales'], 2)); ?></p>
          </div>
        </div>
      </div>

      
      <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50 p-6">
        <div class="flex items-center">
          <div class="p-2 bg-purple-100 dark:bg-purple-900/50 rounded-lg">
            <i data-lucide="shopping-cart" class="w-6 h-6 text-purple-600 dark:text-purple-400"></i>
          </div>
          <div class="ml-4">
            <p class="text-sm font-medium text-gray-500 dark:text-gray-400">Total Orders</p>
            <p class="text-2xl font-semibold text-gray-900 dark:text-white"><?php echo e(number_format($report['sales_metrics']['total_orders'])); ?></p>
          </div>
        </div>
      </div>

      
      <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50 p-6">
        <div class="flex items-center">
          <div class="p-2 bg-orange-100 dark:bg-orange-900/50 rounded-lg">
            <i data-lucide="target" class="w-6 h-6 text-orange-600 dark:text-orange-400"></i>
          </div>
          <div class="ml-4">
            <p class="text-sm font-medium text-gray-500 dark:text-gray-400">Average Order Value</p>
            <p class="text-2xl font-semibold text-gray-900 dark:text-white">₦<?php echo e(number_format($report['sales_metrics']['average_order_value'], 2)); ?></p>
          </div>
        </div>
      </div>
    </div>

    
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
      
      <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50 p-6">
        <div class="flex items-center justify-between">
          <div>
            <p class="text-sm font-medium text-gray-500 dark:text-gray-400">Gross Margin</p>
            <p class="text-2xl font-semibold text-gray-900 dark:text-white"><?php echo e(number_format($grossMargin, 1)); ?>%</p>
          </div>
          <div class="p-2 bg-indigo-100 dark:bg-indigo-900/50 rounded-lg">
            <i data-lucide="percent" class="w-6 h-6 text-indigo-600 dark:text-indigo-400"></i>
          </div>
        </div>
      </div>

      
      <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50 p-6">
        <div class="flex items-center justify-between">
          <div>
            <p class="text-sm font-medium text-gray-500 dark:text-gray-400">Fill Rate</p>
            <p class="text-2xl font-semibold text-gray-900 dark:text-white"><?php echo e(number_format($report['operational_metrics']['fill_rate_percent'], 1)); ?>%</p>
          </div>
          <div class="p-2 bg-emerald-100 dark:bg-emerald-900/50 rounded-lg">
            <i data-lucide="check-circle" class="w-6 h-6 text-emerald-600 dark:text-emerald-400"></i>
          </div>
        </div>
      </div>

      
      <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50 p-6">
        <div class="flex items-center justify-between">
          <div>
            <p class="text-sm font-medium text-gray-500 dark:text-gray-400">Inventory Turnover</p>
            <p class="text-2xl font-semibold text-gray-900 dark:text-white"><?php echo e(number_format($report['inventory_metrics']['inventory_turnover'], 2)); ?></p>
          </div>
          <div class="p-2 bg-teal-100 dark:bg-teal-900/50 rounded-lg">
            <i data-lucide="rotate-cw" class="w-6 h-6 text-teal-600 dark:text-teal-400"></i>
          </div>
        </div>
      </div>
    </div>

    
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
      
      <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50">
        <div class="p-6 border-b border-gray-200 dark:border-slate-700">
          <h3 class="text-lg font-semibold text-gray-900 dark:text-white flex items-center">
            <i data-lucide="bar-chart-3" class="w-5 h-5 mr-2"></i>
            Sales & Financial Metrics
          </h3>
        </div>
        <div class="p-6">
          <div class="space-y-4">
            <div class="flex justify-between">
              <span class="text-gray-600 dark:text-gray-400">Gross Sales</span>
              <span class="font-medium text-gray-900 dark:text-white">₦<?php echo e(number_format($report['sales_metrics']['gross_sales'], 2)); ?></span>
            </div>
            <div class="flex justify-between">
              <span class="text-gray-600 dark:text-gray-400">Discounts</span>
              <span class="font-medium text-red-600 dark:text-red-400">-₦<?php echo e(number_format($report['sales_metrics']['discounts'], 2)); ?></span>
            </div>
            <div class="flex justify-between">
              <span class="text-gray-600 dark:text-gray-400">Net Sales</span>
              <span class="font-medium text-gray-900 dark:text-white">₦<?php echo e(number_format($report['sales_metrics']['net_sales'], 2)); ?></span>
            </div>
            <div class="flex justify-between">
              <span class="text-gray-600 dark:text-gray-400">COGS</span>
              <span class="font-medium text-gray-900 dark:text-white">₦<?php echo e(number_format($report['inventory_metrics']['cogs'], 2)); ?></span>
            </div>
            <div class="flex justify-between border-t pt-4">
              <span class="text-gray-600 dark:text-gray-400">Items Sold</span>
              <span class="font-medium text-gray-900 dark:text-white"><?php echo e(number_format($report['sales_metrics']['total_items_sold'])); ?></span>
            </div>
            <div class="flex justify-between">
              <span class="text-gray-600 dark:text-gray-400">Sales Velocity</span>
              <span class="font-medium text-gray-900 dark:text-white"><?php echo e(number_format($report['sales_metrics']['sales_velocity_per_day'], 1)); ?> items/day</span>
            </div>
          </div>
        </div>
      </div>

      
      <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50">
        <div class="p-6 border-b border-gray-200 dark:border-slate-700">
          <h3 class="text-lg font-semibold text-gray-900 dark:text-white flex items-center">
            <i data-lucide="package" class="w-5 h-5 mr-2"></i>
            Inventory & Operations
          </h3>
        </div>
        <div class="p-6">
          <div class="space-y-4">
            <div class="flex justify-between">
              <span class="text-gray-600 dark:text-gray-400">Current Inventory Value</span>
              <span class="font-medium text-gray-900 dark:text-white">₦<?php echo e(number_format($report['inventory_metrics']['current_inventory_value'], 2)); ?></span>
            </div>
            <div class="flex justify-between">
              <span class="text-gray-600 dark:text-gray-400">Total On Hand</span>
              <span class="font-medium text-gray-900 dark:text-white"><?php echo e(number_format($report['inventory_metrics']['total_on_hand'])); ?> units</span>
            </div>
            <div class="flex justify-between">
              <span class="text-gray-600 dark:text-gray-400">Low Stock Items</span>
              <span class="font-medium text-amber-600 dark:text-amber-400"><?php echo e($report['inventory_metrics']['low_stock_count']); ?></span>
            </div>
            <div class="flex justify-between">
              <span class="text-gray-600 dark:text-gray-400">Out of Stock</span>
              <span class="font-medium text-red-600 dark:text-red-400"><?php echo e($report['inventory_metrics']['out_of_stock_count']); ?></span>
            </div>
            <div class="flex justify-between border-t pt-4">
              <span class="text-gray-600 dark:text-gray-400">Days of Inventory</span>
              <span class="font-medium text-gray-900 dark:text-white"><?php echo e(number_format($report['inventory_metrics']['days_of_inventory'], 1)); ?> days</span>
            </div>
            <div class="flex justify-between">
              <span class="text-gray-600 dark:text-gray-400">Cancellation Rate</span>
              <span class="font-medium text-gray-900 dark:text-white"><?php echo e(number_format($report['operational_metrics']['cancellation_rate_percent'], 1)); ?>%</span>
            </div>
          </div>
        </div>
      </div>
    </div>

    
    <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50">
      <div class="p-6 border-b border-gray-200 dark:border-slate-700">
        <h3 class="text-lg font-semibold text-gray-900 dark:text-white flex items-center">
          <i data-lucide="award" class="w-5 h-5 mr-2"></i>
          Top Selling Dishes
        </h3>
      </div>
      <div class="overflow-x-auto">
        <table class="min-w-full text-sm">
          <thead>
            <tr class="border-b border-gray-200 dark:border-slate-700">
              <th class="px-6 py-3 text-left font-medium text-gray-500 dark:text-gray-400">Rank</th>
              <th class="px-6 py-3 text-left font-medium text-gray-500 dark:text-gray-400">Dish</th>
              <th class="px-6 py-3 text-right font-medium text-gray-500 dark:text-gray-400">Units Sold</th>
              <th class="px-6 py-3 text-right font-medium text-gray-500 dark:text-gray-400">Revenue</th>
            </tr>
          </thead>
          <tbody class="divide-y divide-gray-200 dark:divide-slate-700">
            <?php $__empty_1 = true; $__currentLoopData = $topSellers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $seller): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
              <tr>
                <td class="px-6 py-4">
                  <span class="inline-flex items-center justify-center w-6 h-6 bg-yellow-100 dark:bg-yellow-900/50 text-yellow-800 dark:text-yellow-200 rounded-full text-xs font-medium">
                    <?php echo e($index + 1); ?>

                  </span>
                </td>
                <td class="px-6 py-4 font-medium text-gray-900 dark:text-white"><?php echo e($seller['dish_name']); ?></td>
                <td class="px-6 py-4 text-right text-gray-900 dark:text-white"><?php echo e(number_format($seller['total_sold'])); ?></td>
                <td class="px-6 py-4 text-right font-medium text-gray-900 dark:text-white">₦<?php echo e(number_format($seller['revenue'], 2)); ?></td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
              <tr>
                <td colspan="4" class="px-6 py-8 text-center text-gray-500 dark:text-gray-400">
                  No sales data available for this period
                </td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>

    
    <div class="text-center text-sm text-gray-500 dark:text-gray-400">
      <p>Report generated at <?php echo e($report['generated_at'] ?? now()->toISOString()); ?></p>
      <p class="mt-1">Data is cached for improved performance. Use "Clear Cache" to refresh with latest data.</p>
    </div>
  </div>

  <script>
    async function clearCache() {
      try {
        const response = await fetch('<?php echo e(route('admin.reporting.clear-cache')); ?>', {
          method: 'POST',
          headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
            'Accept': 'application/json',
          }
        });
        
        if (response.ok) {
          alert('Cache cleared successfully! Page will reload with fresh data.');
          window.location.reload();
        } else {
          alert('Failed to clear cache. Please try again.');
        }
      } catch (error) {
        alert('Error clearing cache: ' + error.message);
      }
    }
  </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $attributes = $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $component = $__componentOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?><?php /**PATH C:\xampp\htdocs\bonny_delight\resources\views/admin/reporting/index.blade.php ENDPATH**/ ?>