<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover">
    <meta name="format-detection" content="telephone=no">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php echo e(config('app.name', 'Bonny Delight')); ?></title>

        <!-- Meta -->
    <meta name="description" content="Bonny Delight – refined Nigerian and global cuisine, delivered to your room or doorstep. Explore our menu and order online.">
        <meta name="application-name" content="<?php echo e(config('app.name', 'Bonny Delight')); ?>">
        <meta name="color-scheme" content="light dark">
        <!-- Dynamic theme-color for light/dark -->
        <meta name="theme-color" content="#0f172a">
        <meta name="theme-color" media="(prefers-color-scheme: light)" content="#ffffff">
        <meta name="theme-color" media="(prefers-color-scheme: dark)" content="#0f172a">
    <link rel="canonical" href="<?php echo e(url()->current()); ?>" />
    <meta property="og:title" content="<?php echo e(config('app.name', 'Bonny Delight')); ?>" />
    <meta property="og:type" content="website" />
    <meta property="og:image" content="<?php echo e(asset('assets/og-image.png')); ?>" />
    <meta property="og:description" content="Bonny Delight – refined Nigerian and global cuisine, delivered to your room or doorstep." />
    <meta property="og:url" content="<?php echo e(url('/')); ?>" />
    <meta name="twitter:card" content="summary_large_image" />
    <!-- iOS PWA -->
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="apple-mobile-web-app-title" content="<?php echo e(config('app.name', 'Bonny Delight')); ?>">
    <!-- Mobile Web App (Android/Chrome) -->
    <meta name="mobile-web-app-capable" content="yes">
    <!-- Windows -->
    <meta name="msapplication-TileColor" content="#0f172a" />
    <meta name="msapplication-navbutton-color" content="#0f172a" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;700&family=Playfair+Display:wght@700;900&display=swap" rel="stylesheet">

                                <!-- Early theme to avoid FOUC (deterministic: explicitly add OR remove) -->
                                <script>
                                    (function(){
                                        try {
                                            const root = document.documentElement;
                                            const saved = localStorage.getItem('theme');
                                            if (saved === 'dark') {
                                                root.classList.add('dark');
                                            } else if (saved === 'light') {
                                                root.classList.remove('dark');
                                            } else {
                                                const prefers = window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches;
                                                if (prefers) root.classList.add('dark'); else root.classList.remove('dark');
                                            }
                                        } catch(e) { /* silent */ }
                                    })();
                                </script>

                <!-- PWA Manifest -->
        <link rel="manifest" href="<?php echo e(asset('manifest.json')); ?>">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('icons/apple-touch-icon-180.png')); ?>">
    <!-- Primary favicons (existing) -->
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('icons/favicon-32x32.png')); ?>">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('icons/favicon-16x16.png')); ?>">
    <!-- Back-compat fallbacks (if some pages still request icon-*.png) -->
    <link rel="alternate icon" type="image/png" sizes="32x32" href="<?php echo e(asset('icons/icon-32.png')); ?>">
    <link rel="alternate icon" type="image/png" sizes="16x16" href="<?php echo e(asset('icons/icon-16.png')); ?>">
    <link rel="shortcut icon" href="<?php echo e(asset('icons/favicon-32x32.png')); ?>">

    <!-- Animations stylesheet is imported via Vite in app.js -->

    <?php echo $__env->yieldPushContent('head'); ?>
        <style>
            /* PWA safe-area support when installed */
            @media (display-mode: standalone) {
                body { padding-top: env(safe-area-inset-top); padding-bottom: env(safe-area-inset-bottom); }
            }
        </style>

        <!-- Scripts: Vite with safe fallback if manifest is missing -->
        <?php
            $viteHot = file_exists(public_path('hot'));
            $viteManifest = file_exists(public_path('build/manifest.json'));
        ?>
        <?php if($viteHot || $viteManifest): ?>
            <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
        <?php else: ?>
            <!-- Fallback CSS/JS for local troubleshooting when Vite build is unavailable -->
            <link rel="stylesheet" href="https://unpkg.com/aos@2.3.4/dist/aos.css">
            <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
            <script src="https://unpkg.com/lucide@0.469.0/dist/umd/lucide.js"></script>
            <script src="https://unpkg.com/aos@2.3.4/dist/aos.js"></script>
            <script>
                window.addEventListener('load', function(){
                    try {
                        if (window.lucide && document.querySelector('[data-lucide]')) {
                            // Hydrate only when icons exist to avoid wasted work
                            window.lucide.createIcons?.({ icons: window.lucide.icons });
                        }
                    } catch(e) {}
                    try { window.AOS && window.AOS.init?.({ once: true, duration: 600, easing: 'ease-out', offset: 40 }); } catch(e) {}
                });
            </script>
        <?php endif; ?>
        <!-- Tailwind CDN fallback if Vite build is unavailable -->
    <script nonce="<?php echo e($cspNonce ?? ''); ?>">
            window.addEventListener('error', (e) => {
                // no-op just to avoid unused listener notices
            });
        </script>
    <script nonce="<?php echo e($cspNonce ?? ''); ?>">
            (function ensureTailwind() {
                const test = document.createElement('div');
                test.className = 'hidden';
                document.head.appendChild(test);
                const computed = window.getComputedStyle(test).display;
                if (computed !== 'none') {
                    // Provide Tailwind config BEFORE loading CDN script
                    // Tailwind CDN fallback removed under strict CSP; rely on built assets only.
                }
                document.head.removeChild(test);
            })();
        </script>
                                <script nonce="<?php echo e($cspNonce ?? ''); ?>">
                                    // Theme helpers (simplified, CSS handles icon states via utility classes)
                                    function applyThemeMeta(dark){
                                        const metaTags = document.querySelectorAll('meta[name="theme-color"]');
                                        metaTags.forEach(m => { if (!m.getAttribute('media')) m.setAttribute('content', dark ? '#0f172a' : '#ffffff'); });
                                    }
                                    window.toggleTheme = function(){
                                        try {
                                            const root = document.documentElement;
                                            const nowDark = root.classList.toggle('dark');
                                            localStorage.setItem('theme', nowDark ? 'dark' : 'light');
                                            applyThemeMeta(nowDark);
                                        } catch(e) {}
                                    };
                                    document.addEventListener('DOMContentLoaded', function(){
                                        applyThemeMeta(document.documentElement.classList.contains('dark'));
                                    });
                                </script>
    <!-- Lucide & AOS are bundled via Vite in app.js -->
    </head>
    <body class="font-sans antialiased bg-slate-50 dark:bg-slate-950 text-slate-900 dark:text-slate-100">
    <a href="#main-content" class="sr-only focus:not-sr-only focus:absolute focus:top-2 focus:left-2 bg-white text-slate-900 px-3 py-2 rounded shadow z-50">Skip to content</a>
    <script nonce="<?php echo e($cspNonce ?? ''); ?>">
            // In local development, avoid registering the service worker to prevent caching issues
            // that can cause ERR_FAILED on hashed assets after rebuilds. Also clean up any old SW.
            if ('serviceWorker' in navigator) {
                const isLocal = ['127.0.0.1', 'localhost'].includes(location.hostname);
                if (!isLocal) {
                    window.addEventListener('load', () => {
                        navigator.serviceWorker.register('<?php echo e(asset('service-worker.js')); ?>').catch(() => {});
                    });
                } else {
                    // Best-effort cleanup in dev: unregister SW and clear caches
                    try {
                        navigator.serviceWorker.getRegistrations?.().then(regs => regs.forEach(r => r.unregister()));
                        caches?.keys?.().then(keys => keys.forEach(k => caches.delete(k)));
                    } catch (e) { /* noop */ }
                }
            }
            // Defer Lucide hydration just after first paint to avoid blocking
            document.addEventListener('DOMContentLoaded', function(){
                queueMicrotask?.(function(){
                    try { if (window.lucide && document.querySelector('[data-lucide]')) { window.lucide.createIcons?.({ icons: window.lucide.icons }); } } catch(e) {}
                });
            });
        </script>

        <!-- IntersectionObserver-based hydration for below-the-fold components -->
    <script nonce="<?php echo e($cspNonce ?? ''); ?>">
            (function(){
                function dispatchHydrate(el){
                    try { el.dispatchEvent(new CustomEvent('io-hydrate', { bubbles: true })); } catch(e) {}
                }
                var targets = document.querySelectorAll('[data-io-hydrate]');
                if (!('IntersectionObserver' in window)) {
                    // Fallback: mark so components can self-start, and dispatch once
                    window.__noIO = true;
                    targets.forEach(dispatchHydrate);
                    return;
                }
                var obs = new IntersectionObserver(function(entries){
                    entries.forEach(function(entry){
                        if (entry.isIntersecting) {
                            var el = entry.target;
                            obs.unobserve(el);
                            queueMicrotask?.(function(){ dispatchHydrate(el); });
                        }
                    });
                }, { root: null, threshold: 0.1 });
                targets.forEach(function(el){ obs.observe(el); });
            })();
        </script>
        <div class="relative min-h-screen">
            <!-- Decorative gradients -->
            <div aria-hidden="true" class="pointer-events-none absolute inset-0 overflow-hidden">
                <div class="absolute -top-24 -left-24 h-64 w-64 rounded-full bg-gradient-to-tr from-amber-300/30 via-pink-300/20 to-indigo-300/30 blur-3xl"></div>
                <div class="absolute -bottom-24 -right-24 h-72 w-72 rounded-full bg-gradient-to-tr from-indigo-400/20 via-emerald-300/20 to-cyan-300/20 blur-3xl"></div>
            </div>

            <?php echo $__env->make('layouts.navigation', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <!-- Page Heading -->
            <?php if(isset($header)): ?>
                <header class="backdrop-blur supports-[backdrop-filter]:bg-white/60 dark:supports-[backdrop-filter]:bg-slate-900/60 bg-white/70 dark:bg-slate-900/70 border-b border-white/30 dark:border-slate-700/50 shadow-sm">
                    <div class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8">
                        <?php echo e($header); ?>

                    </div>
                </header>
            <?php endif; ?>

            <!-- Page Content -->
            <main id="main-content" class="relative">
                <?php if (! empty(trim($__env->yieldContent('content')))): ?>
                    <?php echo $__env->yieldContent('content'); ?>
                <?php elseif(isset($slot)): ?>
                    <?php echo e($slot); ?>

                <?php endif; ?>
            </main>

            <!-- Floating Cart Summary -->
            <div id="floating-cart-root">
                <?php echo $__env->renderWhen(!request()->routeIs('cart.index') && !request()->routeIs('checkout.index'), 'components.cart.floating-summary', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1])); ?>
            </div>

            <?php if(session('status') || session('error')): ?>
                <div aria-live="polite" aria-atomic="true" class="fixed inset-x-0 bottom-4 z-[60] flex justify-center pointer-events-none">
                    <div id="toast-public" class="pointer-events-auto max-w-md w-[92%] sm:w-auto px-4 py-3 rounded-lg shadow-lg border text-sm flex items-start gap-3 bg-white/90 dark:bg-slate-800/90 backdrop-blur supports-[backdrop-filter]:bg-white/70 dark:supports-[backdrop-filter]:bg-slate-800/70 border-emerald-200 text-emerald-800 dark:text-emerald-200 <?php if(session('error')): ?> !border-rose-200 !text-rose-800 dark:!text-rose-200 <?php endif; ?>" role="status">
                        <i data-lucide="<?php if(session('error')): ?> alert-circle <?php else: ?> check-circle2 <?php endif; ?>" class="w-5 h-5 shrink-0"></i>
                        <div class="pr-6 flex items-center gap-3">
                            <span><?php echo e(session('error') ?? session('status')); ?></span>
                            <?php if(!session('error')): ?>
                                <a href="<?php echo e(route('cart.index')); ?>" class="inline-flex items-center px-2.5 py-1 rounded-md text-xs font-semibold bg-emerald-600 text-white hover:bg-emerald-700">View cart</a>
                            <?php endif; ?>
                        </div>
                        <button type="button" class="absolute top-1.5 right-2 text-slate-500 hover:text-slate-700 dark:text-slate-300 dark:hover:text-white" aria-label="Dismiss" onclick="(function(b){b?.closest('#toast-public')?.remove();})(this)">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="18" height="18" fill="currentColor"><path d="M6.225 4.811 4.811 6.225 10.586 12l-5.775 5.775 1.414 1.414L12 13.414l5.775 5.775 1.414-1.414L13.414 12l5.775-5.775-1.414-1.414L12 10.586z"/></svg>
                        </button>
                    </div>
                </div>
                <script nonce="<?php echo e($cspNonce ?? ''); ?>">
                    // Auto-dismiss toast after 3 seconds
                    setTimeout(() => document.getElementById('toast-public')?.remove(), 3000);
                </script>
            <?php endif; ?>

            <?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>

        <!-- Offline banner (fixed top) -->
        <div id="offline-banner" class="hidden fixed top-0 inset-x-0 z-[80] px-4 py-2 text-sm text-amber-900 dark:text-amber-100 bg-amber-50/95 dark:bg-amber-900/80 backdrop-blur supports-[backdrop-filter]:bg-amber-50/80 dark:supports-[backdrop-filter]:bg-amber-900/70 border-b border-amber-200/60 dark:border-amber-800" role="status" aria-live="polite">
            <div class="max-w-7xl mx-auto flex items-center gap-2">
                <svg class="w-4 h-4" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                <span><?php echo e(__('You are currently offline. Some features may be unavailable.')); ?></span>
            </div>
        </div>

        <!-- PWA install prompt card (fixed bottom-right) -->
    <div id="pwa-install-card" class="hidden fixed right-4 bottom-4 z-[70] max-w-xs w-[92vw] sm:w-80 rounded-xl border border-slate-200/70 dark:border-slate-700/60 bg-white/95 dark:bg-slate-800/95 backdrop-blur shadow-lg p-4 mb-4 pb-[env(safe-area-inset-bottom)]">
            <div class="flex items-start gap-3">
                <div class="w-9 h-9 rounded-lg bg-indigo-500/10 text-indigo-600 dark:text-indigo-300 flex items-center justify-center">
                    <svg class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/></svg>
                </div>
                <div class="min-w-0 flex-1">
                    <h3 class="text-sm font-semibold text-slate-900 dark:text-white"><?php echo e(__('Install app for quicker access')); ?></h3>
                    <p class="mt-1 text-xs text-slate-600 dark:text-slate-300"><?php echo e(__('Add to your home screen for a smoother, faster experience.')); ?></p>
                    <div class="mt-3 flex items-center gap-2">
                        <button id="btn-install-app" type="button" class="inline-flex items-center px-3 py-1.5 text-xs font-medium rounded-md bg-indigo-600 text-white hover:bg-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-slate-800"><?php echo e(__('Install')); ?></button>
                        <button id="btn-install-dismiss" type="button" class="inline-flex items-center px-3 py-1.5 text-xs font-medium rounded-md border border-slate-300 dark:border-slate-600 text-slate-700 dark:text-slate-200 hover:bg-slate-50 dark:hover:bg-slate-700 focus:outline-none focus:ring-2 focus:ring-slate-400 focus:ring-offset-2 dark:focus:ring-offset-slate-800"><?php echo e(__('Not now')); ?></button>
                    </div>
                </div>
                <button id="btn-install-close" type="button" class="text-slate-500 hover:text-slate-700 dark:text-slate-300 dark:hover:text-white" aria-label="<?php echo e(__('Dismiss')); ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="18" height="18" fill="currentColor"><path d="M6.225 4.811 4.811 6.225 10.586 12l-5.775 5.775 1.414 1.414L12 13.414l5.775 5.775 1.414-1.414L13.414 12l5.775-5.775-1.414-1.414L12 10.586z"/></svg>
                </button>
            </div>
        </div>

    <script nonce="<?php echo e($cspNonce ?? ''); ?>">
            (function(){
                // Offline banner
                const banner = document.getElementById('offline-banner');
                function updateOffline(){
                    if (!banner) return;
                    const off = typeof navigator.onLine === 'boolean' ? !navigator.onLine : false;
                    banner.classList.toggle('hidden', !off);
                }
                window.addEventListener('online', updateOffline);
                window.addEventListener('offline', updateOffline);
                updateOffline();

                // Install prompt card
                const card = document.getElementById('pwa-install-card');
                const btnInstall = document.getElementById('btn-install-app');
                const btnDismiss = document.getElementById('btn-install-dismiss');
                const btnClose = document.getElementById('btn-install-close');
                const DISMISS_KEY = 'pwa:install:dismissed';
                let deferredPrompt = null;

                function isStandalone(){
                    return window.matchMedia('(display-mode: standalone)').matches || window.navigator.standalone === true;
                }
                function showCard(){
                    if (!card) return;
                    if (localStorage.getItem(DISMISS_KEY) === '1') return;
                    if (isStandalone()) return;
                    card.classList.remove('hidden');
                }
                function hideCard(){ card?.classList.add('hidden'); }

                window.addEventListener('beforeinstallprompt', (e) => {
                    // Chrome/Edge: intercept and show our UI
                    e.preventDefault();
                    deferredPrompt = e;
                    showCard();
                });
                window.addEventListener('appinstalled', () => {
                    localStorage.setItem(DISMISS_KEY, '1');
                    hideCard();
                });

                btnInstall?.addEventListener('click', async () => {
                    try {
                        if (deferredPrompt && typeof deferredPrompt.prompt === 'function'){
                            deferredPrompt.prompt();
                            const choice = await deferredPrompt.userChoice;
                            if (choice && choice.outcome === 'accepted') {
                                localStorage.setItem(DISMISS_KEY, '1');
                                hideCard();
                            } else {
                                // Dismiss, but allow re-show later
                                hideCard();
                            }
                            deferredPrompt = null;
                        } else {
                            // iOS Safari or unsupported: show quick instruction toast
                            hideCard();
                        }
                    } catch (_) { hideCard(); }
                });
                function dismiss(){ localStorage.setItem(DISMISS_KEY, '1'); hideCard(); }
                btnDismiss?.addEventListener('click', dismiss);
                btnClose?.addEventListener('click', dismiss);

                // On platforms without beforeinstallprompt (e.g., iOS Safari),
                // show either our install card (generic) or a small iOS tip card,
                // but only if a Service Worker is registered. This avoids noise in local dev.
                if (!isStandalone() && localStorage.getItem(DISMISS_KEY) !== '1'){
                    setTimeout(() => {
                        if (!deferredPrompt && 'serviceWorker' in navigator){
                            navigator.serviceWorker.getRegistration()
                                .then(function(reg){
                                    if (!reg) return;
                                    const isIOS = /iphone|ipad|ipod/i.test(navigator.userAgent);
                                    const isSafari = /^((?!chrome|android).)*safari/i.test(navigator.userAgent);
                                    if (isIOS && isSafari) {
                                        const tipKey = 'pwa:ios:tip:dismissed';
                                        if (localStorage.getItem(tipKey) !== '1'){
                                            const tpl = document.getElementById('ios-a2hs-tip');
                                            if (tpl) {
                                                tpl.classList.remove('hidden');
                                                const close = tpl.querySelector('[data-close]');
                                                close?.addEventListener('click', function(){
                                                    localStorage.setItem(tipKey, '1');
                                                    tpl.classList.add('hidden');
                                                });
                                            }
                                            return;
                                        }
                                    }
                                    showCard();
                                })
                                .catch(function(){});
                        }
                    }, 2500);
                }
            })();
        </script>

        <!-- iOS Add to Home Screen tip (only shown on Safari iOS) -->
    <div id="ios-a2hs-tip" class="hidden fixed left-1/2 -translate-x-1/2 bottom-4 z-[70] max-w-md w-[92vw] sm:w-96 rounded-xl border border-slate-200/70 dark:border-slate-700/60 bg-white/95 dark:bg-slate-800/95 backdrop-blur shadow-lg p-4">
            <div class="flex items-start gap-3">
                <div class="w-9 h-9 rounded-lg bg-slate-500/10 text-slate-600 dark:text-slate-300 flex items-center justify-center">
                    <svg class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 16V8m0 0l-3 3m3-3l3 3M4 16v2a2 2 0 002 2h12a2 2 0 002-2v-2"/></svg>
                </div>
                <div class="min-w-0 flex-1">
                    <h3 class="text-sm font-semibold text-slate-900 dark:text-white"><?php echo e(__('Add to Home Screen')); ?></h3>
                    <p class="mt-1 text-xs text-slate-600 dark:text-slate-300"><?php echo e(__('Tap the Share button, then \"Add to Home Screen\".')); ?></p>
                </div>
                <button type="button" data-close class="text-slate-500 hover:text-slate-700 dark:text-slate-300 dark:hover:text-white" aria-label="<?php echo e(__('Dismiss')); ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="18" height="18" fill="currentColor"><path d="M6.225 4.811 4.811 6.225 10.586 12l-5.775 5.775 1.414 1.414L12 13.414l5.775 5.775 1.414-1.414L13.414 12l5.775-5.775-1.414-1.414L12 10.586z"/></svg>
                </button>
            </div>
        </div>

        <?php if(auth()->guard()->check()): ?>
        <?php if(!request()->routeIs('orders.*')): ?>
        <!-- Resume order hint toast -->
        <div id="resume-order-toast" class="hidden fixed inset-x-0 bottom-4 z-[60] flex justify-center pointer-events-none">
            <div class="pointer-events-auto max-w-md w-[92%] sm:w-auto px-4 py-3 rounded-lg shadow-lg border text-sm flex items-start gap-3 bg-white/90 dark:bg-slate-800/90 backdrop-blur supports-[backdrop-filter]:bg-white/70 dark:supports-[backdrop-filter]:bg-slate-800/70 border-indigo-200 text-slate-900 dark:text-slate-100" role="status" aria-live="polite">
                <i data-lucide="radar" class="w-5 h-5 shrink-0"></i>
                <div class="pr-6 flex items-center gap-3">
                    <span id="resume-order-text"><?php echo e(__('You have an active order.')); ?></span>
                    <a id="resume-order-link" href="#" class="inline-flex items-center px-2.5 py-1 rounded-md text-xs font-semibold bg-indigo-600 text-white hover:bg-indigo-700"><?php echo e(__('Track')); ?></a>
                </div>
                <button type="button" class="absolute top-1.5 right-2 text-slate-500 hover:text-slate-700 dark:text-slate-300 dark:hover:text-white" aria-label="<?php echo e(__('Dismiss')); ?>" onclick="(function(btn){ btn?.closest('#resume-order-toast')?.classList.add('hidden'); localStorage.setItem('pwa:resume:dismiss', '1'); })(this)">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="18" height="18" fill="currentColor"><path d="M6.225 4.811 4.811 6.225 10.586 12l-5.775 5.775 1.414 1.414L12 13.414l5.775 5.775 1.414-1.414L13.414 12l5.775-5.775-1.414-1.414L12 10.586z"/></svg>
                </button>
            </div>
        </div>
    <script nonce="<?php echo e($cspNonce ?? ''); ?>">
            (function(){
                const gateDismiss = localStorage.getItem('pwa:resume:dismiss') === '1';
                if (gateDismiss) return;
                const api = <?php echo json_encode(route('api.me.kpis'), 15, 512) ?>;
                const ordersBase = <?php echo json_encode(url('/orders'), 15, 512) ?>;
                // Only run a short time after load to avoid clashing with other toasts
                setTimeout(async function(){
                    try {
                        const res = await fetch(api, { headers: { 'Accept': 'application/json' } });
                        const data = await res.json();
                        const active = data && data.active_order;
                        if (!active || !active.id) return;
                        const key = 'pwa:resume:last:' + active.id;
                        const last = parseInt(localStorage.getItem(key) || '0', 10);
                        const now = Date.now();
                        // Show at most once per 6 hours per order id
                        if (now - last < 6 * 60 * 60 * 1000) return;
                        const el = document.getElementById('resume-order-toast');
                        if (!el) return;
                        const link = document.getElementById('resume-order-link');
                        const text = document.getElementById('resume-order-text');
                        if (text) text.textContent = `<?php echo e(__('Active order')); ?> #${active.id}`;
                        if (link) link.href = `${ordersBase}/${active.id}`;
                        el.classList.remove('hidden');
                        localStorage.setItem(key, String(now));
                        // Auto hide after 6 seconds
                        setTimeout(() => el.classList.add('hidden'), 6000);
                    } catch (e) { /* ignore */ }
                }, 1800);
            })();
        </script>
        <?php endif; ?>
        <?php endif; ?>
    <?php echo $__env->yieldPushContent('scripts'); ?>
    </body>
</html>
<?php /**PATH C:\xampp\htdocs\bonny_delight\resources\views/layouts/app.blade.php ENDPATH**/ ?>