<?php
  // Build responsive srcsets from manifest entry; gracefully degrade if variants missing.
  $avifSet = $webpSet = $jpgSet = '';
  $lqip = $thumb = null;
  $fallbackSrc = $fallback ? asset($fallback) : null;
  if ($entry) {
    $variants = $entry['variants'] ?? [];
    if (!empty($variants)) {
      usort($variants, fn($a,$b)=> ($a['width']??0) <=> ($b['width']??0));
      $avifSet = collect($variants)->filter(fn($v)=>!empty($v['avif']))->map(fn($v)=> asset($v['avif']).' '.($v['width']).'w')->join(', ');
      $webpSet = collect($variants)->filter(fn($v)=>!empty($v['webp']))->map(fn($v)=> asset($v['webp']).' '.($v['width']).'w')->join(', ');
      $jpgSet  = collect($variants)->filter(fn($v)=>!empty($v['jpg']))->map(fn($v)=> asset($v['jpg']).' '.($v['width']).'w')->join(', ');
      $largest = end($variants) ?: null;
      if ($largest && !empty($largest['jpg'])) {
        $fallbackSrc = asset($largest['jpg']);
      }
    }
    // If no variants but original exists in manifest, use it directly so image still displays
    if (empty($variants) && !empty($entry['original'])) {
      $fallbackSrc = asset($entry['original']);
    }
    if (isset($entry['lqip'])) $lqip = asset($entry['lqip']);
    if (isset($entry['thumb'])) $thumb = asset($entry['thumb']);
  }
  $sizesAttr = $sizes ?? ($type === 'slider' ? '(max-width: 768px) 100vw, 90vw' : '(max-width: 640px) 50vw, (max-width: 1024px) 33vw, 300px');
  $cls = $class ?? '';
?>

<?php if($entry): ?>
<picture class="relative block <?php echo e($cls); ?>">
  <?php if($avifSet): ?><source type="image/avif" srcset="<?php echo e($avifSet); ?>" sizes="<?php echo e($sizesAttr); ?>" /><?php endif; ?>
  <?php if($webpSet): ?><source type="image/webp" srcset="<?php echo e($webpSet); ?>" sizes="<?php echo e($sizesAttr); ?>" /><?php endif; ?>
  <img
    <?php if(isset($fetchpriority)): ?> fetchpriority="<?php echo e($fetchpriority); ?>" <?php endif; ?>
    <?php if($lqip): ?> data-lqip="<?php echo e($lqip); ?>" <?php endif; ?>
    src="<?php echo e($fallbackSrc); ?>"
    <?php if($jpgSet): ?> srcset="<?php echo e($jpgSet); ?>" sizes="<?php echo e($sizesAttr); ?>" <?php endif; ?>
    alt="<?php echo e($alt); ?>"
    loading="<?php echo e($loading); ?>"
    decoding="async"
    class="w-full h-auto <?php echo e($cls); ?> transition-opacity duration-300 opacity-0 js-rimg"
  />
</picture>
<?php else: ?>
  <?php if($fallbackSrc): ?>
    <img src="<?php echo e($fallbackSrc); ?>" alt="<?php echo e($alt); ?>" class="<?php echo e($cls); ?>" loading="<?php echo e($loading); ?>" decoding="async" />
  <?php else: ?>
    <!-- responsive-image: no manifest entry and no fallback provided -->
  <?php endif; ?>
<?php endif; ?>

<?php if (! $__env->hasRenderedOnce('cc11dc11-cc64-4825-8f36-b086f98993e7')): $__env->markAsRenderedOnce('cc11dc11-cc64-4825-8f36-b086f98993e7'); ?>
  <?php $__env->startPush('scripts'); ?>
  <script>
  // Tiny progressive enhancement: fade in once loaded; optionally swap in LQIP as background until load.
  (function(){
    function enhance(img){
      if (img.dataset.lqip && !img.dataset.lqipApplied){
        img.style.background = 'url('+img.dataset.lqip+') center / cover no-repeat';
        img.dataset.lqipApplied = '1';
      }
      if (img.complete && img.naturalWidth){
        requestAnimationFrame(()=>{ img.classList.remove('opacity-0'); img.style.background='none'; });
      } else {
        img.addEventListener('load', ()=>{ img.classList.remove('opacity-0'); img.style.background='none'; }, { once: true });
        img.addEventListener('error', ()=>{ img.classList.remove('opacity-0'); }, { once: true });
      }
    }
    document.querySelectorAll('img.js-rimg').forEach(enhance);
    document.addEventListener('turbo:load', ()=> document.querySelectorAll('img.js-rimg').forEach(enhance));
  })();
  </script>
  <?php $__env->stopPush(); ?>
<?php endif; ?>
<?php /**PATH C:\xampp\htdocs\bonny_delight\resources\views/components/responsive-image.blade.php ENDPATH**/ ?>