<?php $__env->startPush('head'); ?>
<script>
window.MENU_URL = "<?php echo e(route('menu.index')); ?>";
window.searchBox = function(){
    return {
        q: '', open: false, all: [], results: [], dbUnavailable: false, loading: false, error: null,
        async ensureData(){
            if(this.all.length) return;
            this.loading = true; this.error = null; this.dbUnavailable = false;
            try{
                const res = await fetch('/menu.json', { headers: { 'Accept':'application/json' } });
                const data = await res.json();
                if (data && data.db_unavailable) {
                    this.dbUnavailable = true;
                }
                const list = [];
                (data.categories||[]).forEach(c => {
                    (c.dishes||[]).forEach(d => {
                        list.push({
                            k: `d${d.id}`,
                            name: d.name,
                            category: c.name,
                            price: d.price ? `₦${Number(d.price).toLocaleString()}` : '',
                            url: window.MENU_URL + '?category=' + encodeURIComponent(c.name) + '#cat'
                        });
                    });
                });
                this.all = list;
            } catch(e) { this.all = []; this.error = 'Failed to load menu.'; this.dbUnavailable = true; }
            finally { this.loading = false; }
        },
        async refreshData(){ this.all = []; await this.ensureData(); if (this.q) { await this.onInput(); } },
        async onInput(){
            this.open = true;
            await this.ensureData();
            const q = this.q.trim().toLowerCase();
            if(!q){ this.results = []; return; }
            this.results = this.all.filter(x => x.name.toLowerCase().includes(q) || x.category.toLowerCase().includes(q)).slice(0, 8);
        },
        close(){ this.open = false; }
    };
}

// Hero background slideshow (cross-fade, pauses on hover, respects reduced motion)
window.heroSlides = function(list){
    const mql = window.matchMedia('(prefers-reduced-motion: reduce)');
    return {
        slides: Array.isArray(list) && list.length ? list : [],
        i: 0,
        timer: null,
        delay: 5000,
        enabled: !mql.matches,
        userPaused: false,
        hoverActive: false,
        init(){
            if(this.slides.length === 0){ return; }
            this.recomputeTimer();
        },
        recomputeTimer(){
            if(this.timer){ clearInterval(this.timer); this.timer = null; }
            if(this.enabled && this.slides.length > 1 && !this.userPaused && !this.hoverActive){
                this.timer = setInterval(()=>this.next(), this.delay);
            }
        },
        next(){ this.i = (this.i + 1) % this.slides.length; this.recomputeTimer(); },
        prev(){ this.i = (this.i - 1 + this.slides.length) % this.slides.length; this.recomputeTimer(); },
        goTo(n){ if(Number.isInteger(n)){ this.i = ((n % this.slides.length) + this.slides.length) % this.slides.length; this.recomputeTimer(); } },
        pause(){ this.userPaused = true; this.recomputeTimer(); },
        resume(){ this.userPaused = false; this.recomputeTimer(); },
        setHover(active){ this.hoverActive = !!active; this.recomputeTimer(); },
        toggleUserPause(){ this.userPaused = !this.userPaused; this.recomputeTimer(); }
    };
}
</script>
<?php $__env->stopPush(); ?>

<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <?php $__env->startPush('head'); ?>
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@700;900&family=Cormorant+Garamond:wght@400;700&family=Inter:wght@400;500;700&display=swap" rel="stylesheet">
        <style>
            :root{ --charcoal:#36454f; --bonny-blue:#0077c8; --coral:#ff7f50; --pearl:#fdf4e3; --gold:#ffd700; }
            .font-display{ font-family:"Playfair Display","Cormorant Garamond",serif }
            .font-sans-alt{ font-family:"Inter","SF Pro Display",system-ui,-apple-system,sans-serif }
            .text-balance{ text-wrap:balance }
        </style>
        <script type="application/ld+json">
            <?php echo json_encode([
                '<?php $__contextArgs = [];
if (context()->has($__contextArgs[0])) :
if (isset($value)) { $__contextPrevious[] = $value; }
$value = context()->get($__contextArgs[0]); ?>' => 'https://schema.org',
                '@type' => 'Restaurant',
                'name' => config('app.name', 'Bonny Delight'),
                'url' => url('/'),
                'servesCuisine' => ['Nigerian','African','Grill'],
                'image' => [asset('assets/images/jollof.jpg')],
                'priceRange' => '₦₦₦',
                'address' => ['@type' => 'PostalAddress', 'addressCountry' => 'NG'],
            ], JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE); ?>

        </script>
    <?php $__env->stopPush(); ?>

    <?php
        // Safe fallbacks (raw relative paths inside /public)
    // Use manifest slider entries if available
    $manifest = \App\Support\ImageManifest::get();
    if (empty($slides) && $manifest && !empty($manifest['slider'])) {
        $slides = collect($manifest['slider'])
            ->map(function($e){
                // prefer largest variant or original
                $vars = $e['variants'] ?? [];
                if ($vars) {
                    usort($vars, fn($a,$b)=>($b['width']??0) <=> ($a['width']??0));
                    $largest = $vars[0];
                    return asset($largest['jpg']);
                }
                return isset($e['original']) ? asset($e['original']) : null;
            })
            ->filter()->values()->all();
    }
    $slides = $slides ?? [asset('assets/images/jollof.jpg'),asset('assets/images/egusi.jpg'),asset('assets/images/suya.jpg'),asset('assets/images/efo_riro.jpg'),asset('assets/images/pepper_soup.jpg')];
        $categories = $categories ?? ['Jollof Rice','Suya','Egusi Soup','Grilled Fish'];
        $specials = ($specials ?? collect());
        $signature = ($signature ?? collect());
        $popular = $signature->isNotEmpty() ? $signature->take(6) : ($specials->isNotEmpty() ? $specials->take(6) : collect());
        $placeholderImg = '/assets/placeholders/dish-placeholder.svg';

    // Determine effective base path. The app is now flattened at project root (e.g. /bonny_delight),
    // but we keep this logic so deployments under a subdirectory continue to work without edits.
        $runtimeBase = rtrim(request()->getBaseUrl(), '/'); // request-detected base path
        $configBasePath = trim(parse_url(config('app.url'), PHP_URL_PATH) ?? '', '/'); // path portion of APP_URL if any
        $effectiveBase = $runtimeBase !== '' ? $runtimeBase : ($configBasePath !== '' ? '/' . $configBasePath : '');

        $makeUrl = function(string $p) use ($effectiveBase){
            // If already absolute (http(s) or protocol relative) return as-is
            if (preg_match('~^(?:https?:)?//~i', $p)) { return $p; }
            // Normalize to root-relative
            $p = '/' . ltrim($p, '/');
            if ($effectiveBase && $effectiveBase !== '/' && !str_starts_with($p, $effectiveBase.'/')) {
                return rtrim($effectiveBase, '/') . $p;
            }
            return $p;
        };

        // Normalize slide URLs (ensure absolute)
        // Slides now supplied as root-relative or absolute; no further expansion needed here.
        $heroImage = $slides[0] ?? asset('assets/images/jollof.jpg');
        $heroUrl = $makeUrl($heroImage);
        $slideUrls = collect($slides)->map(fn($p) => $makeUrl((string)$p))->filter()->unique()->values()->all();
        if (empty($slideUrls)) { $slideUrls = [$heroUrl]; }

        $freeThreshold = (float) \App\Models\Setting::get('delivery.free_threshold', 20000);
        $baseDeliveryFee = (float) \App\Models\Setting::get('delivery.fee_base', 1000);
    ?>

    <?php $__env->startPush('head'); ?>
        <link rel="preload" as="image" href="<?php echo e($heroUrl); ?>">
        <?php $morePreloads = array_slice($slideUrls, 1, 2); ?>
        <?php $__currentLoopData = $morePreloads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <link rel="preload" as="image" href="<?php echo e($p); ?>">
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php $__env->stopPush(); ?>

    <div class="relative">
        <!-- Hero -->
    <section class="relative min-h-[70svh] min-h-[520px] w-full overflow-hidden isolate" data-hero style="background:#000 center/cover no-repeat <?php echo e(isset($slides[0]) ? 'url('.e($slides[0]).')' : ''); ?>;">
            <div class="absolute inset-0" x-data="window.heroSlides(<?php echo \Illuminate\Support\Js::from($slideUrls)->toHtml() ?>)" x-init="init()" @mouseenter="setHover(true)" @mouseleave="setHover(false)" role="region" aria-roledescription="carousel" aria-label="Featured dishes carousel" tabindex="0" @focus="pause()" @blur="resume()" @keydown.arrow-left.prevent="prev()" @keydown.arrow-right.prevent="next()">
                <div class="sr-only" aria-live="polite" x-text="'Slide ' + (i+1) + ' of ' + slides.length"></div>
                <noscript><img src="<?php echo e($heroUrl); ?>" alt="" class="absolute inset-0 w-full h-full object-cover"/></noscript>
                <template x-for="(url,idx) in slides" :key="idx">
                    <img :id="'hero-slide-'+idx" :src="url" alt="" class="absolute inset-0 w-full h-full object-cover transition-all duration-[1500ms] ease-in-out opacity-0 scale-100" :class="idx===i ? 'opacity-100 scale-105' : ''" :loading="idx===i ? 'eager' : 'lazy'" :fetchpriority="idx===i ? 'high' : 'low'" :aria-hidden="idx===i ? 'false' : 'true'">
                </template>
                <!-- Controls -->
                <div class="absolute inset-y-0 left-0 right-0 flex items-center justify-between px-2 sm:px-4 z-10 pointer-events-none">
                    <button type="button" class="pointer-events-auto inline-flex items-center justify-center size-9 sm:size-10 rounded-full bg-white/20 hover:bg-white/30 text-white shadow ring-1 ring-white/30 focus:outline-none focus:ring-2 focus:ring-white focus:ring-offset-2 focus:ring-offset-black/30" @click="prev()" aria-label="Previous slide" @mouseenter.stop="setHover(true)" @mouseleave.stop="setHover(false)">
                        <i data-lucide="chevron-left" class="w-5 h-5"></i>
                    </button>
                    <button type="button" class="pointer-events-auto inline-flex items-center justify-center size-9 sm:size-10 rounded-full bg-white/20 hover:bg-white/30 text-white shadow ring-1 ring-white/30 focus:outline-none focus:ring-2 focus:ring-white focus:ring-offset-2 focus:ring-offset-black/30" @click="next()" aria-label="Next slide" @mouseenter.stop="setHover(true)" @mouseleave.stop="setHover(false)">
                        <i data-lucide="chevron-right" class="w-5 h-5"></i>
                    </button>
                </div>
                <!-- Pause/Play -->
                <div class="absolute bottom-3 left-3 z-10 pointer-events-none">
                    <button type="button" class="pointer-events-auto inline-flex items-center gap-2 rounded-full bg-white/20 hover:bg-white/30 text-white shadow ring-1 ring-white/30 px-3 py-1.5 text-sm font-medium focus:outline-none focus:ring-2 focus:ring-white focus:ring-offset-2 focus:ring-offset-black/30" @click="toggleUserPause()" :aria-pressed="userPaused ? 'true' : 'false'" :aria-label="userPaused ? 'Play carousel' : 'Pause carousel'">
                        <i :data-lucide="userPaused ? 'play' : 'pause'" class="w-4 h-4"></i>
                        <span x-text="userPaused ? 'Play' : 'Pause'"></span>
                    </button>
                </div>
                <!-- Indicators -->
                <div class="absolute bottom-3 sm:bottom-4 left-0 right-0 z-10 flex justify-center gap-1.5">
                    <template x-for="(u, idx) in slides" :key="'dot-'+idx">
                        <button type="button" class="h-1.5 rounded-full transition-colors focus:outline-none focus:ring-2 focus:ring-white focus:ring-offset-2 focus:ring-offset-black/30" :class="idx===i ? 'bg-white w-6' : 'bg-white/60 hover:bg-white/80 w-2.5'" @click="goTo(idx)" :aria-label="'Go to slide ' + (idx+1) + ' of ' + slides.length" :aria-current="idx===i ? 'true' : 'false'" :aria-controls="'hero-slide-'+idx" :aria-selected="idx===i ? 'true' : 'false'"></button>
                    </template>
                </div>
                <div class="absolute inset-0 bg-gradient-to-b from-black/60 via-black/40 to-black/70"></div>
            </div>

            <div class="relative z-10 max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 py-20 md:py-28 text-white text-center">
                <h1 class="font-display text-balance text-4xl sm:text-5xl md:text-6xl font-black leading-tight">Refined Nigerian Cuisine, Delivered</h1>
                <p class="mt-4 text-base md:text-lg text-white/90">Order chef-crafted meals from Bonny Delight. Fresh, fast, and beautifully served.</p>
                <div class="mt-8 flex flex-wrap items-center justify-center gap-3">
                    <a href="<?php echo e(route('menu.index')); ?>" class="inline-flex items-center justify-center rounded-full h-12 px-6 text-base font-semibold bg-[var(--bonny-blue)] text-white hover:bg-opacity-90">View Menu</a>
                    <a href="<?php echo e(route('menu.index')); ?>#all" class="inline-flex items-center justify-center rounded-full h-12 px-6 text-base font-semibold bg-[var(--coral)] text-white hover:bg-opacity-90">Order Now</a>
                </div>
                <p class="mt-3 text-sm text-white/80">Avg. delivery 25–35 min • From ₦<?php echo e(number_format($baseDeliveryFee, 0)); ?></p>
                <div class="mt-4 inline-flex items-center gap-2 bg-white/15 text-white rounded-full px-4 py-2">
                    <i data-lucide="badge-check" class="w-4 h-4"></i>
                    <span class="text-sm">Free delivery over ₦<?php echo e(number_format($freeThreshold, 0)); ?></span>
                </div>

                <!-- Hero search with live suggestions -->
                <div class="mt-8 max-w-xl mx-auto text-left" x-data="window.searchBox()">
                    <label for="hero-search" class="sr-only">Search dishes</label>
                    <div class="relative">
                        <i data-lucide="search" class="w-5 h-5 text-white/70 absolute left-3 top-1/2 -translate-y-1/2 pointer-events-none"></i>
                        <input id="hero-search" x-model="q" @input.debounce.300ms="onInput" @keydown.escape="close()" @focus="open=true" type="search" placeholder="Search dishes (e.g., jollof, suya)" class="w-full pl-10 pr-3 py-3 rounded-xl bg-white/90 text-[var(--charcoal)] placeholder:text-[var(--charcoal)]/50 focus:outline-none">
                        <!-- DB unavailable banner -->
                        <div x-show="dbUnavailable" class="mt-2 text-sm rounded-md border border-amber-300/60 bg-amber-50 text-amber-900 dark:bg-amber-950/40 dark:text-amber-200 px-3 py-2">
                            Menu data is temporarily unavailable. <button type="button" @click="refreshData()" class="underline font-medium">Retry</button>
                        </div>
                        <!-- Results -->
                        <div x-show="open && results.length" @click.outside="close()" class="absolute z-20 mt-2 w-full rounded-xl bg-white text-[var(--charcoal)] shadow-lg ring-1 ring-black/5 max-h-80 overflow-auto">
                            <ul>
                                <template x-for="item in results" :key="item.k">
                                    <li>
                                        <a :href="item.url" class="flex items-center gap-3 px-3 py-2 hover:bg-[var(--pearl)]/60">
                                            <i data-lucide="utensils" class="w-4 h-4 text-[var(--bonny-blue)]"></i>
                                            <div class="text-sm">
                                                <div class="font-medium" x-text="item.name"></div>
                                                <div class="text-[var(--charcoal)]/70" x-text="item.category"></div>
                                            </div>
                                            <span class="ms-auto text-sm font-semibold" x-text="item.price"></span>
                                        </a>
                                    </li>
                                </template>
                                <template x-if="!results.length && q.length">
                                    <li class="px-3 py-2 text-sm text-[var(--charcoal)]/70">No matches</li>
                                </template>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Decorative food image clusters removed per request -->
        </section>

        <!-- Categories (chips) -->
        <section class="py-10 bg-white">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center mb-6">
                    <h2 class="font-display text-3xl md:text-4xl font-bold text-[var(--charcoal)]">Browse by Category</h2>
                </div>
                <div class="flex justify-center flex-wrap gap-3">
                    <?php $__currentLoopData = ($categories ?? []); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a href="<?php echo e(route('menu.index', ['category' => $c])); ?>#cat" class="px-5 py-2 text-sm font-medium rounded-full bg-[var(--pearl)] text-[var(--charcoal)] hover:bg-[var(--bonny-blue)]/10 transition"><?php echo e($c); ?></a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </section>

    <!-- Popular dishes -->
    <section id="popular" class="py-14 bg-white">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex items-end justify-between mb-6">
                    <h2 class="font-display text-3xl md:text-4xl font-bold text-[var(--charcoal)]">Popular Dishes</h2>
                    <a href="<?php echo e(route('menu.index')); ?>" class="text-[var(--bonny-blue)] hover:underline">View full menu</a>
                </div>
                <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
                    <?php $hasPopular = $popular->isNotEmpty(); ?>
                    <?php $__currentLoopData = ($hasPopular ? $popular : collect(range(1,6))); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dish): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $img = asset(ltrim($placeholderImg,'/'));
                            $base = null;
                            if ($hasPopular && $dish->image) {
                                $public = $dish->public_image_url;
                                if ($public) { $img = $public; }
                                $candidateBase = $dish->image_base;
                                if ($candidateBase && App\Support\ImageManifest::find('dish', $candidateBase)) {
                                    $base = $candidateBase;
                                }
                            }
                            $name = $hasPopular ? $dish->name : 'Classic Jollof Rice';
                            $subtitle = $hasPopular ? (string)($dish->description ?? 'A staple of Nigerian cuisine.') : 'A staple of Nigerian cuisine.';
                            $price = $hasPopular ? number_format((float)($dish->price ?? 0), 2) : number_format(4500, 2);
                            $qtyInCart = $hasPopular && isset($dish->id) ? (int) (session('cart.items.'.$dish->id) ?? 0) : 0;
                        ?>
                        <div class="group flex flex-col rounded-xl overflow-hidden bg-white shadow-sm ring-1 ring-black/5">
                            <div class="overflow-hidden">
                                <?php if($base): ?>
                                    <?php if (isset($component)) { $__componentOriginale75524dba4ffced2baa5b8fd1d6ea996 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale75524dba4ffced2baa5b8fd1d6ea996 = $attributes; } ?>
<?php $component = App\View\Components\ResponsiveImage::resolve(['type' => 'dish','base' => $base,'alt' => $name,'class' => 'w-full aspect-[4/3] object-cover transition group-hover:scale-105','sizes' => '(min-width:1024px) 33vw, (min-width:640px) 50vw, 100vw','fallback' => $img] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('responsive-image'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ResponsiveImage::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale75524dba4ffced2baa5b8fd1d6ea996)): ?>
<?php $attributes = $__attributesOriginale75524dba4ffced2baa5b8fd1d6ea996; ?>
<?php unset($__attributesOriginale75524dba4ffced2baa5b8fd1d6ea996); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale75524dba4ffced2baa5b8fd1d6ea996)): ?>
<?php $component = $__componentOriginale75524dba4ffced2baa5b8fd1d6ea996; ?>
<?php unset($__componentOriginale75524dba4ffced2baa5b8fd1d6ea996); ?>
<?php endif; ?>
                                <?php else: ?>
                                    <img src="<?php echo e($img); ?>" alt="<?php echo e($name); ?>" class="w-full aspect-[4/3] object-cover transition group-hover:scale-105" width="640" height="480" loading="lazy" />
                                <?php endif; ?>
                            </div>
                            <div class="p-4 flex flex-col gap-2">
                                <div class="flex items-start justify-between gap-3">
                                    <div>
                                        <h3 class="text-lg font-semibold text-[var(--charcoal)]"><?php echo e($name); ?></h3>
                                        <p class="text-[var(--charcoal)]/70 text-sm line-clamp-2"><?php echo e($subtitle); ?></p>
                                    </div>
                                    <div class="shrink-0 text-right">
                                        <div class="text-base md:text-lg font-bold text-[var(--charcoal)]">₦<?php echo e($price); ?></div>
                                    </div>
                                </div>
                                <div class="mt-1">
                                    <?php if($hasPopular && isset($dish->id)): ?>
                                        <?php if($qtyInCart > 0): ?>
                                            <div class="inline-flex items-center gap-2" aria-label="Update quantity for <?php echo e($name); ?>">
                                                <?php if($qtyInCart > 1): ?>
                                                    <form method="POST" action="<?php echo e(route('cart.update')); ?>">
                                                        <?php echo csrf_field(); ?>
                                                        <input type="hidden" name="dish_id" value="<?php echo e($dish->id); ?>">
                                                        <input type="hidden" name="quantity" value="<?php echo e($qtyInCart - 1); ?>">
                                                        <button type="submit" class="size-9 rounded-full bg-gray-200 text-gray-700 hover:bg-gray-300" title="Decrease">
                                                            <span class="sr-only">Decrease</span>
                                                            −
                                                        </button>
                                                    </form>
                                                <?php else: ?>
                                                    <form method="POST" action="<?php echo e(route('cart.remove')); ?>">
                                                        <?php echo csrf_field(); ?>
                                                        <input type="hidden" name="dish_id" value="<?php echo e($dish->id); ?>">
                                                        <button type="submit" class="size-9 rounded-full bg-gray-200 text-gray-700 hover:bg-gray-300" title="Remove">
                                                            <span class="sr-only">Remove</span>
                                                            −
                                                        </button>
                                                    </form>
                                                <?php endif; ?>
                                                <span class="min-w-[2ch] text-center text-sm font-semibold text-[var(--charcoal)]"><?php echo e($qtyInCart); ?></span>
                                                <form method="POST" action="<?php echo e(route('cart.update')); ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <input type="hidden" name="dish_id" value="<?php echo e($dish->id); ?>">
                                                    <input type="hidden" name="quantity" value="<?php echo e($qtyInCart + 1); ?>">
                                                    <button type="submit" class="size-9 rounded-full bg-[var(--bonny-blue)] text-white hover:bg-opacity-90" title="Increase">
                                                        <span class="sr-only">Increase</span>
                                                        +
                                                    </button>
                                                </form>
                                            </div>
                                        <?php else: ?>
                                            <form method="POST" action="<?php echo e(route('cart.add')); ?>" class="inline-flex">
                                                <?php echo csrf_field(); ?>
                                                <input type="hidden" name="dish_id" value="<?php echo e($dish->id); ?>">
                                                <input type="hidden" name="quantity" value="1">
                                                <button type="submit" class="inline-flex items-center justify-center rounded-full h-9 px-4 text-sm font-semibold bg-[var(--bonny-blue)] text-white hover:bg-opacity-90">
                                                    Add
                                                </button>
                                            </form>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <a href="<?php echo e(route('menu.index')); ?>#all" class="inline-flex items-center justify-center rounded-full h-9 px-4 text-sm font-semibold bg-[var(--bonny-blue)] text-white hover:bg-opacity-90">Order</a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </section>

        <!-- Advantages -->
        <section class="py-14 bg-[var(--pearl)]/80">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center mb-8">
                    <h2 class="font-display text-3xl md:text-4xl font-bold text-[var(--charcoal)]">Why Bonny Delight</h2>
                </div>
                <div class="grid grid-cols-1 sm:grid-cols-3 gap-6 text-center">
                    <?php $adv = [
                        ['icon'=>'utensils-crossed','title'=>'Chef-crafted','desc'=>'Authentic Nigerian recipes with premium ingredients.'],
                        ['icon'=>'clock','title'=>'Fast Delivery','desc'=>'Hot and fresh to your room or doorstep.'],
                        ['icon'=>'leaf','title'=>'Fresh & Clean','desc'=>'Prepared with care in a hygienic kitchen.'],
                    ]; ?>
                    <?php $__currentLoopData = $adv; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="flex flex-col items-center gap-3 p-6 rounded-xl bg-white/80 ring-1 ring-black/5">
                            <i data-lucide="<?php echo e($a['icon']); ?>" class="w-10 h-10 text-[var(--bonny-blue)]" aria-hidden="true"></i>
                            <h3 class="text-[var(--charcoal)] text-lg font-bold"><?php echo e($a['title']); ?></h3>
                            <p class="text-[var(--charcoal)]/70 text-sm max-w-xs"><?php echo e($a['desc']); ?></p>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </section>
        
        <!-- Testimonials -->
        <section class="py-14 bg-white">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center mb-8">
                    <h2 class="font-display text-3xl md:text-4xl font-bold text-[var(--charcoal)]">Loved by diners</h2>
                    <p class="text-[var(--charcoal)]/70 max-w-2xl mx-auto">Real feedback from happy customers who enjoy fast, delicious meals.</p>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <?php $testi = [
                        ['n'=>'Ada','t'=>'“The jollof is perfect every time. Delivery is quick and food arrives hot.”'],
                        ['n'=>'Tunde','t'=>'“Best suya I’ve had in town. Ordering is so easy.”'],
                        ['n'=>'Zainab','t'=>'“Clean, tasty, and reliable. Great for late-night cravings.”'],
                    ]; ?>
                    <?php $__currentLoopData = $testi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $x): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <figure class="rounded-xl p-6 ring-1 ring-black/5 bg-white shadow-sm">
                            <div class="flex items-center gap-2 text-amber-500 mb-2" aria-label="5 stars">
                                <?php for($i=0;$i<5;$i++): ?><i data-lucide="star" class="w-4 h-4 fill-current"></i><?php endfor; ?>
                            </div>
                            <blockquote class="text-[var(--charcoal)]/80"><?php echo e($x['t']); ?></blockquote>
                            <figcaption class="mt-3 text-sm font-semibold text-[var(--charcoal)]">— <?php echo e($x['n']); ?></figcaption>
                        </figure>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </section>

        <?php
            // Cart count for sticky mobile bar
            $navCartItems = session('cart.items', []);
            $navCartCount = 0;
            if (is_array($navCartItems)) {
                foreach ($navCartItems as $it) {
                    if (is_array($it) && isset($it['qty'])) { $navCartCount += (int) $it['qty']; }
                    elseif (is_numeric($it)) { $navCartCount += (int) $it; }
                }
            }
        ?>
        <!-- Sticky mobile action bar -->
        <div class="md:hidden fixed bottom-0 inset-x-0 z-40">
            <div class="mx-4 mb-4 rounded-2xl bg-[var(--charcoal)] text-white shadow-lg ring-1 ring-black/5 px-4 py-3 flex items-center gap-3">
                <a href="<?php echo e(route('menu.index')); ?>" class="flex-1 inline-flex items-center justify-center gap-2 rounded-xl bg-[var(--bonny-blue)] px-4 py-2.5 font-semibold hover:bg-opacity-90">
                    <i data-lucide="chef-hat" class="w-5 h-5"></i>
                    Start order
                </a>
                <a href="<?php echo e(route('cart.index')); ?>" class="inline-flex items-center gap-2 rounded-xl bg-white/10 px-3 py-2 font-medium hover:bg-white/15">
                    <i data-lucide="shopping-cart" class="w-5 h-5"></i>
                    <span class="text-sm">Cart</span>
                    <?php if($navCartCount): ?>
                        <span class="ml-1 inline-flex items-center justify-center min-w-[1.5rem] h-6 rounded-full bg-[var(--coral)] text-white text-xs px-2"><?php echo e($navCartCount); ?></span>
                    <?php endif; ?>
                </a>
            </div>
        </div>

    <!-- End -->
    </div>

<?php $__env->startPush('scripts'); ?>
<script>
// Slider icons hydration (if using lucide or similar)
window.addEventListener('DOMContentLoaded', () => {
    if (window.lucide && typeof window.lucide.createIcons === 'function') {
        window.lucide.createIcons();
    }
});
</script>
<?php $__env->stopPush(); ?>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\xampp\htdocs\bonny_delight\resources\views/landing.blade.php ENDPATH**/ ?>