<header class="sticky top-0 z-30 backdrop-blur bg-white/70 dark:bg-slate-900/60 ring-1 ring-black/5">
  <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 h-16 flex items-center justify-between">
    <div class="flex items-center gap-3">
      <?php
        $user = Auth::user();
        $userName = $user?->display_name ?? 'Guest';
        // Check if returning customer (has previous orders)
        $hasOrders = false;
        try {
            $hasOrders = $user && \App\Models\Order::where('user_id', $user->id)->exists();
        } catch (\Throwable $e) {
            // DB unavailable or error, default to false
        }
        $greeting = $hasOrders ? "Welcome Back, {$userName}" : "Welcome, {$userName}";
      ?>
      <div class="font-semibold text-slate-900 dark:text-white">
        <?php echo e($greeting); ?>

      </div>
      <span class="hidden sm:inline text-slate-400">•</span>
      <span class="hidden sm:inline text-xs text-slate-600 dark:text-slate-300">Kitchen: Normal • 25–35 min</span>
    </div>

    <div class="flex items-center gap-2">
      <a href="<?php echo e(route('menu.index')); ?>" class="btn btn-primary hidden md:inline-flex">Start Order</a>
      <?php if(Route::has('orders.index')): ?>
        <a href="<?php echo e(route('orders.index')); ?>" class="btn btn-outline hidden sm:inline-flex">Track Orders</a>
      <?php endif; ?>
    </div>
  </div>
</header>
<?php /**PATH C:\xampp\htdocs\bonny_delight\resources\views/components/customer/header.blade.php ENDPATH**/ ?>