<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>Super Admin — <?php echo e(config('app.name', 'Bonny Delight')); ?></title>

    <meta name="application-name" content="<?php echo e(config('app.name', 'Bonny Delight')); ?>">
    <meta name="color-scheme" content="light dark">
    <meta name="theme-color" content="#0f172a">
    <meta name="theme-color" media="(prefers-color-scheme: light)" content="#ffffff">
    <meta name="theme-color" media="(prefers-color-scheme: dark)" content="#0f172a">
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="apple-mobile-web-app-title" content="<?php echo e(config('app.name', 'Bonny Delight')); ?>">

    <!-- Icons / Favicons -->
    <link rel="apple-touch-icon" sizes="180x180" href="/icons/apple-touch-icon-180.png">
    <link rel="icon" type="image/png" sizes="32x32" href="/icons/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="/icons/favicon-16x16.png">
    <link rel="alternate icon" type="image/png" sizes="32x32" href="/icons/icon-32.png">
    <link rel="alternate icon" type="image/png" sizes="16x16" href="/icons/icon-16.png">
    <link rel="shortcut icon" href="/icons/favicon-32x32.png">

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;700&family=Playfair+Display:wght@700;900&display=swap" rel="stylesheet">

    <?php echo $__env->yieldPushContent('head'); ?>

    <script nonce="<?php echo e($cspNonce ?? 'default'); ?>">
        // Early deterministic theme (super admin)
        (function(){
            try{
                const root = document.documentElement;
                const saved = localStorage.getItem('theme');
                if (saved === 'dark') {
                    root.classList.add('dark');
                } else if (saved === 'light') {
                    root.classList.remove('dark');
                } else {
                    const prefers = window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches;
                    if (prefers) root.classList.add('dark'); else root.classList.remove('dark');
                }
            }catch(e){}
        })();
        function applyThemeMeta(dark){
            const metaTags = document.querySelectorAll('meta[name="theme-color"]');
            metaTags.forEach(m => { if (!m.getAttribute('media')) m.setAttribute('content', dark ? '#0f172a' : '#ffffff'); });
        }
        window.toggleTheme = function(){
            try{
                const root = document.documentElement;
                const nowDark = root.classList.toggle('dark');
                localStorage.setItem('theme', nowDark ? 'dark' : 'light');
                applyThemeMeta(nowDark);
            }catch(e){}
        };
        document.addEventListener('DOMContentLoaded', function(){
            applyThemeMeta(document.documentElement.classList.contains('dark'));
        });
    </script>

    <?php
        $viteHot = file_exists(public_path('hot'));
        $viteManifest = file_exists(public_path('build/manifest.json'));
    ?>
    <?php if($viteHot || $viteManifest): ?>
        <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <?php else: ?>
        <link rel="stylesheet" href="https://unpkg.com/aos@2.3.4/dist/aos.css">
        <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
        <script src="https://unpkg.com/lucide@0.469.0/dist/umd/lucide.js"></script>
        <script src="https://unpkg.com/aos@2.3.4/dist/aos.js"></script>
        <script>
            window.addEventListener('load', function(){
                try { window.lucide && window.lucide.createIcons?.({ icons: window.lucide.icons }); } catch(e) {}
                try { window.AOS && window.AOS.init?.({ once: true, duration: 300 }); } catch(e) {}
            });
        </script>
    <?php endif; ?>

    <!-- Chart.js (UMD build to avoid ESM import issues) -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
</head>
<body class="font-sans antialiased bg-slate-50 dark:bg-slate-950 text-slate-900 dark:text-slate-100">
    <div x-data="{ open: false, collapsed: false }" x-init="(() => { try { collapsed = localStorage.getItem('superadmin:sidebar') === 'collapsed' } catch(e){} })()" class="min-h-screen flex">
        <!-- Sidebar -->
        <aside :class="collapsed ? 'w-16' : 'w-64'" class="hidden md:flex transition-[width] duration-200 border-r border-white/30 dark:border-slate-700/50 bg-white/80 dark:bg-slate-900/80 backdrop-blur supports-[backdrop-filter]:bg-white/60 dark:supports-[backdrop-filter]:bg-slate-900/60">
            <nav class="h-full w-full flex flex-col">
                <!-- Brand -->
                <div class="h-16 flex items-center px-3 border-b border-white/30 dark:border-slate-700/50">
                    <a href="<?php echo e(route('super-admin.dashboard')); ?>" class="flex items-center gap-2 w-full" :class="collapsed ? 'justify-center' : ''" title="Super Admin">
                        <img src="<?php echo e(asset('assets/logo.png')); ?>" alt="<?php echo e(config('app.name')); ?>" class="w-8 h-8 rounded" onerror="this.onerror=null;this.src='<?php echo e(asset('assets/placeholders/qr-placeholder.svg')); ?>';">
                        <span class="font-semibold truncate" x-show="!collapsed" x-transition.opacity>Super Admin</span>
                    </a>
                </div>

                <!-- Navigation -->
                <div class="flex-1 overflow-y-auto py-3">
                    <ul class="px-2 space-y-1 text-sm">
                        <li>
                            <a href="<?php echo e(route('super-admin.dashboard')); ?>" title="Dashboard" :class="collapsed ? 'justify-center' : ''" class="group relative flex items-center gap-3 rounded px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800 border-l-2 <?php if(request()->routeIs('super-admin.dashboard')): ?> bg-slate-50 dark:bg-slate-800 border-indigo-600 <?php else: ?> border-transparent <?php endif; ?>">
                                <i data-lucide="layout-dashboard" class="w-5 h-5"></i>
                                <span x-show="!collapsed" x-transition:enter="transition-all duration-200" x-transition:enter-start="opacity-0 max-w-0" x-transition:enter-end="opacity-100 max-w-[200px]" x-transition:leave="transition-all duration-150" x-transition:leave-start="opacity-100 max-w-[200px]" x-transition:leave-end="opacity-0 max-w-0" class="whitespace-nowrap overflow-hidden">Dashboard</span>
                                <span x-show="collapsed" x-transition.opacity class="pointer-events-none absolute left-full top-1/2 -translate-y-1/2 ml-2 px-2 py-1 rounded bg-slate-900 text-white text-xs shadow-lg whitespace-nowrap hidden group-hover:block">Dashboard</span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('super-admin.users.index')); ?>" title="User Management" :class="collapsed ? 'justify-center' : ''" class="group relative flex items-center gap-3 rounded px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800 border-l-2 <?php if(request()->routeIs('super-admin.users.*')): ?> bg-slate-50 dark:bg-slate-800 border-indigo-600 <?php else: ?> border-transparent <?php endif; ?>">
                                <i data-lucide="users" class="w-5 h-5"></i>
                                <span x-show="!collapsed" x-transition:enter="transition-all duration-200" x-transition:enter-start="opacity-0 max-w-0" x-transition:enter-end="opacity-100 max-w-[200px]" x-transition:leave="transition-all duration-150" x-transition:leave-start="opacity-100 max-w-[200px]" x-transition:leave-end="opacity-0 max-w-0" class="whitespace-nowrap overflow-hidden">User Management</span>
                                <span x-show="collapsed" x-transition.opacity class="pointer-events-none absolute left-full top-1/2 -translate-y-1/2 ml-2 px-2 py-1 rounded bg-slate-900 text-white text-xs shadow-lg whitespace-nowrap hidden group-hover:block">User Management</span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('super-admin.analytics.index')); ?>" title="Analytics" :class="collapsed ? 'justify-center' : ''" class="group relative flex items-center gap-3 rounded px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800 border-l-2 <?php if(request()->routeIs('super-admin.analytics.*')): ?> bg-slate-50 dark:bg-slate-800 border-indigo-600 <?php else: ?> border-transparent <?php endif; ?>">
                                <i data-lucide="bar-chart" class="w-5 h-5"></i>
                                <span x-show="!collapsed" x-transition:enter="transition-all duration-200" x-transition:enter-start="opacity-0 max-w-0" x-transition:enter-end="opacity-100 max-w-[200px]" x-transition:leave="transition-all duration-150" x-transition:leave-start="opacity-100 max-w-[200px]" x-transition:leave-end="opacity-0 max-w-0" class="whitespace-nowrap overflow-hidden">Analytics</span>
                                <span x-show="collapsed" x-transition.opacity class="pointer-events-none absolute left-full top-1/2 -translate-y-1/2 ml-2 px-2 py-1 rounded bg-slate-900 text-white text-xs shadow-lg whitespace-nowrap hidden group-hover:block">Analytics</span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('super-admin.reports.index')); ?>" title="Reports" :class="collapsed ? 'justify-center' : ''" class="group relative flex items-center gap-3 rounded px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800 border-l-2 <?php if(request()->routeIs('super-admin.reports.*')): ?> bg-slate-50 dark:bg-slate-800 border-indigo-600 <?php else: ?> border-transparent <?php endif; ?>">
                                <i data-lucide="file-text" class="w-5 h-5"></i>
                                <span x-show="!collapsed" x-transition:enter="transition-all duration-200" x-transition:enter-start="opacity-0 max-w-0" x-transition:enter-end="opacity-100 max-w-[200px]" x-transition:leave="transition-all duration-150" x-transition:leave-start="opacity-100 max-w-[200px]" x-transition:leave-end="opacity-0 max-w-0" class="whitespace-nowrap overflow-hidden">Reports</span>
                                <span x-show="collapsed" x-transition.opacity class="pointer-events-none absolute left-full top-1/2 -translate-y-1/2 ml-2 px-2 py-1 rounded bg-slate-900 text-white text-xs shadow-lg whitespace-nowrap hidden group-hover:block">Reports</span>
                            </a>
                        </li>
                        
                        <!-- Admin Tools Section -->
                        <li class="pt-4">
                            <div class="px-3 py-1">
                                <span x-show="!collapsed" class="text-xs font-semibold text-slate-400 dark:text-slate-500 uppercase tracking-widest">Admin Tools</span>
                            </div>
                        </li>
                        <li>
                            <a href="<?php echo e(route('super-admin.admin.dashboard')); ?>" title="Admin Panel" :class="collapsed ? 'justify-center' : ''" class="group relative flex items-center gap-3 rounded px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800 border-l-2 <?php if(request()->routeIs('super-admin.admin.*')): ?> bg-slate-50 dark:bg-slate-800 border-purple-600 <?php else: ?> border-transparent <?php endif; ?>">
                                <i data-lucide="settings" class="w-5 h-5"></i>
                                <span x-show="!collapsed" x-transition:enter="transition-all duration-200" x-transition:enter-start="opacity-0 max-w-0" x-transition:enter-end="opacity-100 max-w-[200px]" x-transition:leave="transition-all duration-150" x-transition:leave-start="opacity-100 max-w-[200px]" x-transition:leave-end="opacity-0 max-w-0" class="whitespace-nowrap overflow-hidden">Admin Panel</span>
                                <span x-show="collapsed" x-transition.opacity class="pointer-events-none absolute left-full top-1/2 -translate-y-1/2 ml-2 px-2 py-1 rounded bg-slate-900 text-white text-xs shadow-lg whitespace-nowrap hidden group-hover:block">Admin Panel</span>
                            </a>
                        </li>
                    </ul>
                </div>

                <!-- Footer -->
                <div class="p-3 border-t border-white/30 dark:border-slate-700/50 space-y-1">
                    <a href="<?php echo e(route('home')); ?>" target="_blank" title="View Site" :class="collapsed ? 'justify-center' : ''" class="group relative w-full inline-flex items-center gap-2 rounded px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800 border-l-2 border-transparent transition-colors text-sm">
                        <i data-lucide="external-link" class="w-4 h-4"></i>
                        <span x-show="!collapsed" x-transition:enter="transition-all duration-200" x-transition:enter-start="opacity-0 max-w-0" x-transition:enter-end="opacity-100 max-w-[200px]" x-transition:leave="transition-all duration-150" x-transition:leave-start="opacity-100 max-w-[200px]" x-transition:leave-end="opacity-0 max-w-0" class="whitespace-nowrap overflow-hidden">View Site</span>
                        <span x-show="collapsed" x-transition.opacity class="pointer-events-none absolute left-full top-1/2 -translate-y-1/2 ml-2 px-2 py-1 rounded bg-slate-900 dark:bg-slate-700 text-white dark:text-slate-200 text-xs shadow-lg whitespace-nowrap hidden group-hover:block z-50">View Site</span>
                    </a>
                    
                    <!-- Light/Dark Theme Toggle Button -->
                    <button onclick="toggleTheme()" title="Toggle Theme" :class="collapsed ? 'justify-center' : ''" class="group relative w-full inline-flex items-center gap-2 rounded px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800 border-l-2 border-transparent transition-colors text-sm">
                        <i data-lucide="sun" class="w-4 h-4 dark:hidden"></i>
                        <i data-lucide="moon" class="w-4 h-4 hidden dark:block"></i>
                        <span x-show="!collapsed" x-transition:enter="transition-all duration-200" x-transition:enter-start="opacity-0 max-w-0" x-transition:enter-end="opacity-100 max-w-[200px]" x-transition:leave="transition-all duration-150" x-transition:leave-start="opacity-100 max-w-[200px]" x-transition:leave-end="opacity-0 max-w-0" class="whitespace-nowrap overflow-hidden">
                            <span class="dark:hidden">Light Mode</span>
                            <span class="hidden dark:inline">Dark Mode</span>
                        </span>
                        <span x-show="collapsed" x-transition.opacity class="pointer-events-none absolute left-full top-1/2 -translate-y-1/2 ml-2 px-2 py-1 rounded bg-slate-900 dark:bg-slate-700 text-white dark:text-slate-200 text-xs shadow-lg whitespace-nowrap hidden group-hover:block z-50">
                            <span class="dark:hidden">Light Mode</span>
                            <span class="hidden dark:inline">Dark Mode</span>
                        </span>
                    </button>
                    
                    <a href="<?php echo e(route('logout.get')); ?>" title="Logout" :class="collapsed ? 'justify-center' : ''" class="group relative w-full inline-flex items-center gap-2 rounded px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800 border-l-2 border-transparent transition-colors text-sm">
                        <i data-lucide="log-out" class="w-4 h-4"></i>
                        <span x-show="!collapsed" x-transition:enter="transition-all duration-200" x-transition:enter-start="opacity-0 max-w-0" x-transition:enter-end="opacity-100 max-w-[200px]" x-transition:leave="transition-all duration-150" x-transition:leave-start="opacity-100 max-w-[200px]" x-transition:leave-end="opacity-0 max-w-0" class="whitespace-nowrap overflow-hidden">Logout</span>
                        <span x-show="collapsed" x-transition.opacity class="pointer-events-none absolute left-full top-1/2 -translate-y-1/2 ml-2 px-2 py-1 rounded bg-slate-900 dark:bg-slate-700 text-white dark:text-slate-200 text-xs shadow-lg whitespace-nowrap hidden group-hover:block z-50">Logout</span>
                    </a>
                </div>
            </nav>
        </aside>

        <!-- Mobile Sidebar Overlay -->
        <div class="md:hidden fixed inset-0 z-40 bg-black/40" x-show="open" x-transition.opacity @click="open=false"></div>
        <aside class="md:hidden fixed inset-y-0 left-0 z-50 w-72 border-r border-white/30 dark:border-slate-700/50 bg-white dark:bg-slate-900" x-show="open" x-transition @keydown.escape.window="open=false" role="dialog" aria-modal="true">
            <!-- Mobile navigation content - same as desktop but without collapse functionality -->
            <nav class="h-full w-full flex flex-col">
                <!-- Brand -->
                <div class="h-16 flex items-center px-3 border-b border-white/30 dark:border-slate-700/50">
                    <a href="<?php echo e(route('super-admin.dashboard')); ?>" class="flex items-center gap-2 w-full" title="Super Admin">
                        <img src="<?php echo e(asset('assets/logo.png')); ?>" alt="<?php echo e(config('app.name')); ?>" class="w-8 h-8 rounded" onerror="this.onerror=null;this.src='<?php echo e(asset('assets/placeholders/qr-placeholder.svg')); ?>';">
                        <span class="font-semibold truncate">Super Admin</span>
                    </a>
                </div>

                <!-- Navigation -->
                <div class="flex-1 overflow-y-auto py-3">
                    <ul class="px-2 space-y-1 text-sm">
                        <li>
                            <a href="<?php echo e(route('super-admin.dashboard')); ?>" class="flex items-center gap-3 rounded px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800 border-l-2 <?php if(request()->routeIs('super-admin.dashboard')): ?> bg-slate-50 dark:bg-slate-800 border-indigo-600 <?php else: ?> border-transparent <?php endif; ?>">
                                <i data-lucide="layout-dashboard" class="w-5 h-5"></i>
                                <span class="whitespace-nowrap overflow-hidden">Dashboard</span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('super-admin.users.index')); ?>" class="flex items-center gap-3 rounded px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800 border-l-2 <?php if(request()->routeIs('super-admin.users.*')): ?> bg-slate-50 dark:bg-slate-800 border-indigo-600 <?php else: ?> border-transparent <?php endif; ?>">
                                <i data-lucide="users" class="w-5 h-5"></i>
                                <span class="whitespace-nowrap overflow-hidden">User Management</span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('super-admin.analytics.index')); ?>" class="flex items-center gap-3 rounded px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800 border-l-2 <?php if(request()->routeIs('super-admin.analytics.*')): ?> bg-slate-50 dark:bg-slate-800 border-indigo-600 <?php else: ?> border-transparent <?php endif; ?>">
                                <i data-lucide="bar-chart" class="w-5 h-5"></i>
                                <span class="whitespace-nowrap overflow-hidden">Analytics</span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('super-admin.reports.index')); ?>" class="flex items-center gap-3 rounded px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800 border-l-2 <?php if(request()->routeIs('super-admin.reports.*')): ?> bg-slate-50 dark:bg-slate-800 border-indigo-600 <?php else: ?> border-transparent <?php endif; ?>">
                                <i data-lucide="file-text" class="w-5 h-5"></i>
                                <span class="whitespace-nowrap overflow-hidden">Reports</span>
                            </a>
                        </li>
                        
                        <!-- Admin Tools Section -->
                        <li class="pt-4">
                            <div class="px-3 py-1">
                                <span class="text-xs font-semibold text-slate-400 dark:text-slate-500 uppercase tracking-widest">Admin Tools</span>
                            </div>
                        </li>
                        <li>
                            <a href="<?php echo e(route('super-admin.admin.dashboard')); ?>" class="flex items-center gap-3 rounded px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800 border-l-2 <?php if(request()->routeIs('super-admin.admin.*')): ?> bg-slate-50 dark:bg-slate-800 border-purple-600 <?php else: ?> border-transparent <?php endif; ?>">
                                <i data-lucide="settings" class="w-5 h-5"></i>
                                <span class="whitespace-nowrap overflow-hidden">Admin Panel</span>
                            </a>
                        </li>
                    </ul>
                </div>

                <!-- Footer -->
                <div class="p-3 border-t border-white/30 dark:border-slate-700/50 space-y-1">
                    <a href="<?php echo e(route('home')); ?>" target="_blank" class="w-full inline-flex items-center gap-2 rounded px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800 border-l-2 border-transparent transition-colors text-sm">
                        <i data-lucide="external-link" class="w-4 h-4"></i>
                        <span class="whitespace-nowrap overflow-hidden">View Site</span>
                    </a>
                    
                    <!-- Light/Dark Theme Toggle Button -->
                    <button onclick="toggleTheme()" class="w-full inline-flex items-center gap-2 rounded px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800 border-l-2 border-transparent transition-colors text-sm">
                        <i data-lucide="sun" class="w-4 h-4 dark:hidden"></i>
                        <i data-lucide="moon" class="w-4 h-4 hidden dark:block"></i>
                        <span class="whitespace-nowrap overflow-hidden">
                            <span class="dark:hidden">Light Mode</span>
                            <span class="hidden dark:inline">Dark Mode</span>
                        </span>
                    </button>
                    
                    <a href="<?php echo e(route('logout.get')); ?>" class="w-full inline-flex items-center gap-2 rounded px-3 py-2 hover:bg-slate-100 dark:hover:bg-slate-800 border-l-2 border-transparent transition-colors text-sm">
                        <i data-lucide="log-out" class="w-4 h-4"></i>
                        <span class="whitespace-nowrap overflow-hidden">Logout</span>
                    </a>
                </div>
            </nav>
        </aside>

        <!-- Main Content -->
        <div class="flex-1 min-w-0 flex flex-col">
            <!-- Topbar -->
            <div class="h-16 flex items-center justify-between px-4 sm:px-6 lg:px-8 backdrop-blur supports-[backdrop-filter]:bg-white/60 dark:supports-[backdrop-filter]:bg-slate-900/60 bg-white/70 dark:bg-slate-900/70 border-b border-white/30 dark:border-slate-700/50">
                <div class="flex items-center gap-2">
                    <button class="md:hidden inline-flex items-center justify-center w-10 h-10 rounded hover:bg-slate-100 dark:hover:bg-slate-800" @click="open = true" aria-label="Open menu">
                        <i data-lucide="menu" class="w-5 h-5"></i>
                    </button>
                    <button class="hidden md:inline-flex items-center gap-2 px-3 py-2 rounded hover:bg-slate-100 dark:hover:bg-slate-800" @click="collapsed=!collapsed; localStorage.setItem('superadmin:sidebar', collapsed ? 'collapsed' : 'expanded')" aria-label="Toggle sidebar">
                        <i data-lucide="panel-left" class="w-4 h-4"></i>
                        <span class="text-sm">Sidebar</span>
                    </button>
                </div>
                <div class="flex items-center gap-3">
                    <span class="inline-flex items-center text-xs px-2 py-1 rounded-full bg-slate-100 dark:bg-slate-800 text-slate-700 dark:text-slate-200 border border-white/30 dark:border-slate-700/50">Super Admin</span>
                    <span class="text-sm text-slate-600 dark:text-slate-300"><?php echo e(auth()->user()->name ?? 'Super Admin'); ?></span>
                    <div class="w-8 h-8 rounded-full bg-gradient-to-br from-orange-400 to-orange-600 flex items-center justify-center text-white font-semibold text-sm">
                        <?php echo e(strtoupper(substr(auth()->user()->name ?? 'SA', 0, 1))); ?>

                    </div>
                </div>
            </div>

            <!-- Page Heading -->
            <?php if(isset($header) || $__env->hasSection('header')): ?>
                <header class="px-4 sm:px-6 lg:px-8 py-4 border-b border-white/30 dark:border-slate-700/50 space-y-3">
                    <?php if (! empty(trim($__env->yieldContent('header')))): ?>
                        <?php echo $__env->yieldContent('header'); ?>
                    <?php elseif(isset($header)): ?>
                        <?php echo e($header); ?>

                    <?php endif; ?>
                    <?php if(session('success')): ?>
                        <div class="mb-4 bg-emerald-50 dark:bg-emerald-900/20 border border-emerald-200 dark:border-emerald-800 rounded-md p-4">
                            <div class="flex">
                                <div class="flex-shrink-0">
                                    <svg class="h-5 w-5 text-emerald-400" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                    </svg>
                                </div>
                                <div class="ml-3">
                                    <p class="text-sm font-medium text-emerald-800 dark:text-emerald-200"><?php echo e(session('success')); ?></p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if(session('error')): ?>
                        <div class="mb-4 bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 rounded-md p-4">
                            <div class="flex">
                                <div class="flex-shrink-0">
                                    <svg class="h-5 w-5 text-red-400" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"></path>
                                    </svg>
                                </div>
                                <div class="ml-3">
                                    <p class="text-sm font-medium text-red-800 dark:text-red-200"><?php echo e(session('error')); ?></p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </header>
            <?php else: ?>
                <header class="px-4 sm:px-6 lg:px-8 py-4 border-b border-white/30 dark:border-slate-700/50">
                    <div>
                        <h1 class="text-2xl font-bold text-slate-900 dark:text-white"><?php echo $__env->yieldContent('title', 'Super Admin Dashboard'); ?></h1>
                        <p class="text-slate-600 dark:text-slate-400 mt-1"><?php echo $__env->yieldContent('subtitle', 'Complete business oversight and management'); ?></p>
                    </div>
                    <?php if(session('success')): ?>
                        <div class="mt-4 bg-emerald-50 dark:bg-emerald-900/20 border border-emerald-200 dark:border-emerald-800 rounded-md p-4">
                            <div class="flex">
                                <div class="flex-shrink-0">
                                    <svg class="h-5 w-5 text-emerald-400" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                    </svg>
                                </div>
                                <div class="ml-3">
                                    <p class="text-sm font-medium text-emerald-800 dark:text-emerald-200"><?php echo e(session('success')); ?></p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if(session('error')): ?>
                        <div class="mt-4 bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 rounded-md p-4">
                            <div class="flex">
                                <div class="flex-shrink-0">
                                    <svg class="h-5 w-5 text-red-400" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"></path>
                                    </svg>
                                </div>
                                <div class="ml-3">
                                    <p class="text-sm font-medium text-red-800 dark:text-red-200"><?php echo e(session('error')); ?></p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </header>
            <?php endif; ?>

            <!-- Page Content -->
            <main class="flex-1 px-4 sm:px-6 lg:px-8 py-6">
                <?php if (! empty(trim($__env->yieldContent('content')))): ?>
                    <?php echo $__env->yieldContent('content'); ?>
                <?php else: ?>
                    <?php echo e($slot ?? ''); ?>

                <?php endif; ?>
            </main>
        </div>
    </div>

    <!-- Scripts -->
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html><?php /**PATH C:\xampp\htdocs\bonny_delight\resources\views/super-admin/layout.blade.php ENDPATH**/ ?>