<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>Admin — <?php echo e(config('app.name', 'Bonny Delight')); ?></title>

  <meta name="application-name" content="<?php echo e(config('app.name', 'Bonny Delight')); ?>">
  <meta name="color-scheme" content="light dark">
  <meta name="theme-color" content="#0f172a">
  <meta name="theme-color" media="(prefers-color-scheme: light)" content="#ffffff">
  <meta name="theme-color" media="(prefers-color-scheme: dark)" content="#0f172a">
  <meta name="mobile-web-app-capable" content="yes">
  <meta name="apple-mobile-web-app-capable" content="yes">
  <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
  <meta name="apple-mobile-web-app-title" content="<?php echo e(config('app.name', 'Bonny Delight')); ?>">

  <!-- Icons / Favicons -->
  <link rel="apple-touch-icon" sizes="180x180" href="/icons/apple-touch-icon-180.png">
  <link rel="icon" type="image/png" sizes="32x32" href="/icons/favicon-32x32.png">
  <link rel="icon" type="image/png" sizes="16x16" href="/icons/favicon-16x16.png">
  <link rel="alternate icon" type="image/png" sizes="32x32" href="/icons/icon-32.png">
  <link rel="alternate icon" type="image/png" sizes="16x16" href="/icons/icon-16.png">
  <link rel="shortcut icon" href="/icons/favicon-32x32.png">

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;700&display=swap" rel="stylesheet">

    <?php echo $__env->yieldPushContent('head'); ?>

  <script nonce="<?php echo e($cspNonce ?? ''); ?>">
      // Early deterministic theme (admin)
      (function(){
        try{
          const root = document.documentElement;
          const saved = localStorage.getItem('theme');
          if (saved === 'dark') {
            root.classList.add('dark');
          } else if (saved === 'light') {
            root.classList.remove('dark');
          } else {
            const prefers = window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches;
            if (prefers) root.classList.add('dark'); else root.classList.remove('dark');
          }
        }catch(e){}
      })();
      function applyThemeMeta(dark){
        const metaTags = document.querySelectorAll('meta[name="theme-color"]');
        metaTags.forEach(m => { if (!m.getAttribute('media')) m.setAttribute('content', dark ? '#0f172a' : '#ffffff'); });
      }
      window.toggleTheme = function(){
        try{
          const root = document.documentElement;
          const nowDark = root.classList.toggle('dark');
          localStorage.setItem('theme', nowDark ? 'dark' : 'light');
          applyThemeMeta(nowDark);
        }catch(e){}
      };
      document.addEventListener('DOMContentLoaded', function(){
        applyThemeMeta(document.documentElement.classList.contains('dark'));
      });
    </script>

    <?php
      $viteHot = file_exists(public_path('hot'));
      $viteManifest = file_exists(public_path('build/manifest.json'));
    ?>
    <?php if($viteHot || $viteManifest): ?>
      <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/admin.js']); ?>
    <?php else: ?>
      <link rel="stylesheet" href="https://unpkg.com/aos@2.3.4/dist/aos.css">
      <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
      <script src="https://unpkg.com/lucide@0.469.0/dist/umd/lucide.js"></script>
      <script src="https://unpkg.com/aos@2.3.4/dist/aos.js"></script>
      <script>
        window.addEventListener('load', function(){
          try { window.lucide && window.lucide.createIcons?.({ icons: window.lucide.icons }); } catch(e) {}
          try { window.AOS && window.AOS.init?.({ once: true, duration: 300 }); } catch(e) {}
        });
      </script>
    <?php endif; ?>
  </head>
  <body class="font-sans antialiased bg-slate-50 dark:bg-slate-950 text-slate-900 dark:text-slate-100">
    <div x-data="{ open: false, collapsed: false }" x-init="(() => { try { collapsed = localStorage.getItem('admin:sidebar') === 'collapsed' } catch(e){} })()" class="min-h-screen flex">
      <!-- Sidebar -->
  <aside :class="collapsed ? 'w-16' : 'w-64'" class="hidden md:flex transition-[width] duration-200 border-r border-white/30 dark:border-slate-700/50 bg-white/80 dark:bg-slate-900/80 backdrop-blur supports-[backdrop-filter]:bg-white/60 dark:supports-[backdrop-filter]:bg-slate-900/60">
        <?php if (isset($component)) { $__componentOriginalbebe114f3ccde4b38d7462a3136be045 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbebe114f3ccde4b38d7462a3136be045 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.admin.sidebar','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin.sidebar'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbebe114f3ccde4b38d7462a3136be045)): ?>
<?php $attributes = $__attributesOriginalbebe114f3ccde4b38d7462a3136be045; ?>
<?php unset($__attributesOriginalbebe114f3ccde4b38d7462a3136be045); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbebe114f3ccde4b38d7462a3136be045)): ?>
<?php $component = $__componentOriginalbebe114f3ccde4b38d7462a3136be045; ?>
<?php unset($__componentOriginalbebe114f3ccde4b38d7462a3136be045); ?>
<?php endif; ?>
      </aside>

      <!-- Mobile Sidebar Overlay -->
  <div class="md:hidden fixed inset-0 z-40 bg-black/40" x-show="open" x-transition.opacity @click="open=false"></div>
      <aside class="md:hidden fixed inset-y-0 left-0 z-50 w-72 border-r border-white/30 dark:border-slate-700/50 bg-white dark:bg-slate-900" x-show="open" x-transition @keydown.escape.window="open=false" role="dialog" aria-modal="true">
        <?php if (isset($component)) { $__componentOriginalbebe114f3ccde4b38d7462a3136be045 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbebe114f3ccde4b38d7462a3136be045 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.admin.sidebar','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin.sidebar'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbebe114f3ccde4b38d7462a3136be045)): ?>
<?php $attributes = $__attributesOriginalbebe114f3ccde4b38d7462a3136be045; ?>
<?php unset($__attributesOriginalbebe114f3ccde4b38d7462a3136be045); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbebe114f3ccde4b38d7462a3136be045)): ?>
<?php $component = $__componentOriginalbebe114f3ccde4b38d7462a3136be045; ?>
<?php unset($__componentOriginalbebe114f3ccde4b38d7462a3136be045); ?>
<?php endif; ?>
      </aside>

      <!-- Main Content -->
    <div class="flex-1 min-w-0 flex flex-col">
        <!-- Topbar -->
        <?php if (isset($component)) { $__componentOriginal232f012cda936a4eb249de3234ccfddd = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal232f012cda936a4eb249de3234ccfddd = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.admin.topbar','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin.topbar'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
          <button class="md:hidden inline-flex items-center justify-center w-10 h-10 rounded hover:bg-slate-100 dark:hover:bg-slate-800" @click="open = true" aria-label="Open menu">
            <i data-lucide="menu" class="w-5 h-5"></i>
          </button>
      <button class="hidden md:inline-flex items-center gap-2 px-3 py-2 rounded hover:bg-slate-100 dark:hover:bg-slate-800" @click="collapsed=!collapsed; localStorage.setItem('admin:sidebar', collapsed ? 'collapsed' : 'expanded')" aria-label="Toggle sidebar">
            <i data-lucide="panel-left" class="w-4 h-4"></i>
            <span class="text-sm">Sidebar</span>
          </button>
         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal232f012cda936a4eb249de3234ccfddd)): ?>
<?php $attributes = $__attributesOriginal232f012cda936a4eb249de3234ccfddd; ?>
<?php unset($__attributesOriginal232f012cda936a4eb249de3234ccfddd); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal232f012cda936a4eb249de3234ccfddd)): ?>
<?php $component = $__componentOriginal232f012cda936a4eb249de3234ccfddd; ?>
<?php unset($__componentOriginal232f012cda936a4eb249de3234ccfddd); ?>
<?php endif; ?>

        <!-- Page Heading -->
        <?php if(isset($header) || $__env->hasSection('header')): ?>
          <header class="px-4 sm:px-6 lg:px-8 py-4 border-b border-white/30 dark:border-slate-700/50 space-y-3">
            <?php if (! empty(trim($__env->yieldContent('header')))): ?>
              <?php echo $__env->yieldContent('header'); ?>
            <?php elseif(isset($header)): ?>
              <?php echo e($header); ?>

            <?php endif; ?>
            <?php if(session('status')): ?>
              <?php if (isset($component)) { $__componentOriginal7cfab914afdd05940201ca0b2cbc009b = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal7cfab914afdd05940201ca0b2cbc009b = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.toast','data' => ['type' => 'success','message' => session('status')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('toast'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'success','message' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(session('status'))]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal7cfab914afdd05940201ca0b2cbc009b)): ?>
<?php $attributes = $__attributesOriginal7cfab914afdd05940201ca0b2cbc009b; ?>
<?php unset($__attributesOriginal7cfab914afdd05940201ca0b2cbc009b); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal7cfab914afdd05940201ca0b2cbc009b)): ?>
<?php $component = $__componentOriginal7cfab914afdd05940201ca0b2cbc009b; ?>
<?php unset($__componentOriginal7cfab914afdd05940201ca0b2cbc009b); ?>
<?php endif; ?>
            <?php endif; ?>
            <?php if(isset($errors) && $errors->any()): ?>
              <?php if (isset($component)) { $__componentOriginal7cfab914afdd05940201ca0b2cbc009b = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal7cfab914afdd05940201ca0b2cbc009b = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.toast','data' => ['type' => 'error']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('toast'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'error']); ?>
                <ul class="list-disc pl-5">
                  <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($e); ?></li>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
               <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal7cfab914afdd05940201ca0b2cbc009b)): ?>
<?php $attributes = $__attributesOriginal7cfab914afdd05940201ca0b2cbc009b; ?>
<?php unset($__attributesOriginal7cfab914afdd05940201ca0b2cbc009b); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal7cfab914afdd05940201ca0b2cbc009b)): ?>
<?php $component = $__componentOriginal7cfab914afdd05940201ca0b2cbc009b; ?>
<?php unset($__componentOriginal7cfab914afdd05940201ca0b2cbc009b); ?>
<?php endif; ?>
            <?php endif; ?>
          </header>
        <?php endif; ?>

        <!-- Page Content -->
        <main class="flex-1 px-4 sm:px-6 lg:px-8 py-6">
          <?php if (! empty(trim($__env->yieldContent('content')))): ?>
            <?php echo $__env->yieldContent('content'); ?>
          <?php else: ?>
            <?php echo e($slot ?? ''); ?>

          <?php endif; ?>
        </main>
      </div>
    </div>
  </body>
  <?php echo $__env->yieldPushContent('scripts'); ?>
  <!-- Tailwind/Alpine/Lucide CDN fallbacks removed to enforce strict CSP. All assets must be bundled. -->
</html>
<?php /**PATH C:\xampp\htdocs\bonny_delight\resources\views/layouts/admin.blade.php ENDPATH**/ ?>