<?php if (isset($component)) { $__componentOriginal91fdd17964e43374ae18c674f95cdaa3 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3 = $attributes; } ?>
<?php $component = App\View\Components\AdminLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AdminLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
   <?php $__env->slot('header', null, []); ?> 
    <div>
      <h2 class="font-semibold text-xl">Per-Location Availability</h2>
      <?php if (isset($component)) { $__componentOriginal1a2164c88256e2df02baa87be70e8a2b = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1a2164c88256e2df02baa87be70e8a2b = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.admin.breadcrumbs','data' => ['items' => [['label' => 'Inventory', 'url' => route('admin.inventory.index')], ['label' => 'Availability']]]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin.breadcrumbs'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['items' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute([['label' => 'Inventory', 'url' => route('admin.inventory.index')], ['label' => 'Availability']])]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1a2164c88256e2df02baa87be70e8a2b)): ?>
<?php $attributes = $__attributesOriginal1a2164c88256e2df02baa87be70e8a2b; ?>
<?php unset($__attributesOriginal1a2164c88256e2df02baa87be70e8a2b); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1a2164c88256e2df02baa87be70e8a2b)): ?>
<?php $component = $__componentOriginal1a2164c88256e2df02baa87be70e8a2b; ?>
<?php unset($__componentOriginal1a2164c88256e2df02baa87be70e8a2b); ?>
<?php endif; ?>
    </div>
   <?php $__env->endSlot(); ?>

  <div class="max-w-7xl mx-auto p-4 space-y-6">
    <?php if(isset($grandTotals)): ?>
    <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50 p-4">
      <div class="flex items-center justify-between">
        <div class="text-sm font-semibold">Grand totals (all pages, current filters)</div>
        <div class="space-x-6 text-sm">
          <span><span class="text-gray-500">Qty:</span> <span class="font-semibold"><?php echo e((int)($grandTotals->qty ?? 0)); ?></span></span>
          <span><span class="text-gray-500">Value +:</span> <span class="font-semibold">₦<?php echo e(number_format((float)($grandTotals->pos_value ?? 0), 2)); ?></span></span>
          <span><span class="text-gray-500">Value -:</span> <span class="font-semibold">₦<?php echo e(number_format((float)($grandTotals->neg_value ?? 0), 2)); ?></span></span>
          <span><span class="text-gray-500">Current valuation:</span> <span class="font-semibold">₦<?php echo e(number_format((float)($currentValuation ?? 0), 2)); ?></span></span>
        </div>
      </div>
    </div>
    <?php endif; ?>
    <?php
      // Build chart data: sum qty per location from current page rows
      $chartByLocation = [];
      foreach ($rows as $r) {
        $lname = $r->location_name ?? 'Unassigned';
        $chartByLocation[$lname] = ($chartByLocation[$lname] ?? 0) + (int)$r->qty;
      }
      $chartMax = max(1, collect($chartByLocation)->max() ?? 1);
    ?>
    <?php if(count($chartByLocation)): ?>
    <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50 p-4">
      <div class="flex items-center justify-between mb-3">
        <h3 class="text-lg font-semibold">Totals by Location (current page)</h3>
        <span class="text-xs text-gray-500">Simple inline chart</span>
      </div>
      <div class="overflow-x-auto">
        <div class="min-w-[600px]">
          <svg viewBox="0 0 600 <?php echo e(30 * count($chartByLocation)); ?>" width="100%" height="<?php echo e(30 * count($chartByLocation)); ?>" aria-label="Totals by Location">
            <?php $i=0; ?>
            <?php $__currentLoopData = $chartByLocation; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $locName => $total): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <?php $barWidth = $chartMax > 0 ? (int)( ($total / $chartMax) * 520 ) : 0; ?>
              <g transform="translate(60, <?php echo e(30 * $i + 5); ?>)">
                <rect x="0" y="0" width="<?php echo e($barWidth); ?>" height="20" fill="#0ea5e9" rx="4" />
                <text x="-8" y="14" text-anchor="end" fill="#64748b" font-size="12"><?php echo e(Str::limit($locName, 14)); ?></text>
                <text x="<?php echo e($barWidth + 6); ?>" y="14" fill="#334155" font-size="12"><?php echo e($total); ?></text>
              </g>
              <?php $i++; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </svg>
        </div>
      </div>
    </div>
    <?php endif; ?>
    <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50 p-4">
      <form method="GET" action="<?php echo e(route('admin.inventory.availability')); ?>" class="grid grid-cols-1 md:grid-cols-3 gap-3">
        <div>
          <label class="block text-sm mb-1">Search</label>
          <input type="text" name="search" value="<?php echo e($request->search); ?>" placeholder="Dish or location"
                 class="w-full border rounded px-3 py-2 bg-white dark:bg-slate-900" />
        </div>
        <div>
          <label class="block text-sm mb-1">Location</label>
          <select name="location_id" class="w-full border rounded px-3 py-2 bg-white dark:bg-slate-900">
            <option value="">All locations</option>
            <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <option value="<?php echo e($loc->id); ?>" <?php echo e((string)$request->location_id === (string)$loc->id ? 'selected' : ''); ?>><?php echo e($loc->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </select>
        </div>
        <div class="flex items-end gap-2">
          <button class="px-4 py-2 bg-blue-600 text-white rounded">Apply</button>
          <a href="<?php echo e(route('admin.inventory.availability')); ?>" class="px-4 py-2 border rounded">Clear</a>
          <a href="<?php echo e(route('admin.inventory.availability.export', request()->query())); ?>" class="px-4 py-2 bg-emerald-600 text-white rounded">Export CSV</a>
        </div>
      </form>
    </div>

    <?php
      // Build totals by dish from the current page rows (UI-level). For full totals, export CSV.
      $totalsByDish = [];
      $pageTotalQty = 0; $pageTotalValue = 0.0;
      foreach ($rows as $r) {
        $key = $r->dish_id.'|'.$r->dish_name;
        if (!isset($totalsByDish[$key])) {
          $totalsByDish[$key] = 0;
        }
        $totalsByDish[$key] += (int)$r->qty;
        $pageTotalQty += (int)$r->qty;
        $pageTotalValue += max(0, (int)$r->qty) * (float)$r->price;
      }
    ?>

    <div class="bg-white/80 dark:bg-slate-800/80 rounded-lg border border-white/30 dark:border-slate-700/50 overflow-hidden">
      <div class="overflow-x-auto">
        <table class="min-w-full text-sm">
          <thead class="bg-gray-50/90 dark:bg-slate-900/70 backdrop-blur text-left text-gray-700 dark:text-slate-300">
            <tr>
              <th class="px-6 py-3">Dish</th>
              <th class="px-6 py-3">Location</th>
              <th class="px-6 py-3">Qty</th>
              <th class="px-6 py-3">Threshold</th>
              <th class="px-6 py-3">Value</th>
            </tr>
          </thead>
          <tbody class="divide-y divide-gray-200 dark:divide-slate-700">
            <?php $currentDishKey = null; ?>
            <?php $__empty_1 = true; $__currentLoopData = $rows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
              <?php $dishKey = $row->dish_id.'|'.$row->dish_name; ?>
              <?php if($currentDishKey !== $dishKey): ?>
                <?php $currentDishKey = $dishKey; ?>
                <tr class="bg-gray-50/60 dark:bg-slate-900/40">
                  <td class="px-6 py-2 font-semibold" colspan="5">
                    <div class="flex items-center justify-between">
                      <div>
                        <?php echo e($row->dish_name); ?> — Total across locations (this page):
                        <span class="ml-1 inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-slate-100 dark:bg-slate-800">
                          <?php echo e((int)($totalsByDish[$dishKey] ?? 0)); ?>

                        </span>
                        <span class="ml-3 text-xs text-gray-500">
                          All locations total:
                          <span class="font-semibold js-dish-total-all" data-dish-id="<?php echo e($row->dish_id); ?>">…</span>
                        </span>
                      </div>
                      <div class="hidden md:block">
                        <svg class="js-sparkline" data-dish-id="<?php echo e($row->dish_id); ?>" width="160" height="28" viewBox="0 0 160 28" aria-label="Recent movements sparkline"></svg>
                      </div>
                    </div>
                  </td>
                </tr>
              <?php endif; ?>
              <tr class="hover:bg-gray-50/50 dark:hover:bg-slate-700/50">
                <td class="px-6 py-3">
                  <div class="text-xs text-gray-500">ID: <?php echo e($row->dish_id); ?></div>
                </td>
                <td class="px-6 py-3"><?php echo e($row->location_name ?? '—'); ?></td>
                <td class="px-6 py-3">
                  <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium
                    <?php echo e($row->qty <= $row->low_stock_threshold ? 'bg-red-100 text-red-800 dark:bg-red-900/50 dark:text-red-300' : 'bg-green-100 text-green-800 dark:bg-green-900/50 dark:text-green-300'); ?>">
                    <?php echo e((int)$row->qty); ?>

                  </span>
                </td>
                <td class="px-6 py-3"><?php echo e((int)$row->low_stock_threshold); ?></td>
                <td class="px-6 py-3">₦<?php echo e(number_format(max(0, (int)$row->qty) * (float)$row->price, 2)); ?></td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
              <tr>
                <td colspan="5" class="px-6 py-8 text-center text-gray-500">No data</td>
              </tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
      <div class="border-t border-gray-200 dark:border-slate-700">
        <div class="flex items-center justify-between px-6 py-3 text-sm">
          <div class="text-gray-600 dark:text-slate-300">Page totals</div>
          <div class="space-x-6">
            <span><span class="text-gray-500">Qty:</span> <span class="font-semibold"><?php echo e((int)$pageTotalQty); ?></span></span>
            <span><span class="text-gray-500">Value:</span> <span class="font-semibold">₦<?php echo e(number_format($pageTotalValue, 2)); ?></span></span>
          </div>
        </div>
      </div>
      <div class="p-3"><?php echo e($rows->links()); ?></div>
    </div>
  </div>

  <?php $__env->startPush('scripts'); ?>
  <script nonce="<?php echo e($cspNonce ?? ''); ?>">
    (function(){
      try {
        // Collect unique dish IDs present
        const totalEls = Array.from(document.querySelectorAll('.js-dish-total-all'));
        const ids = Array.from(new Set(totalEls.map(el => el.getAttribute('data-dish-id')).filter(Boolean)));
        if (ids.length) {
          const url = new URL("<?php echo e(route('admin.inventory.availability.totals')); ?>", window.location.origin);
          ids.forEach(id => url.searchParams.append('dish_ids[]', id));
          fetch(url.toString(), { headers: { 'Accept': 'application/json' } })
            .then(r => r.ok ? r.json() : Promise.reject())
            .then(data => {
              (data.totals || []).forEach(item => {
                const els = document.querySelectorAll(`.js-dish-total-all[data-dish-id="${item.dish_id}"]`);
                els.forEach(el => el.textContent = item.qty);
              });
            }).catch(() => {});
        }

        // Draw sparkline per dish: last N movements change values
        const sparkEls = Array.from(document.querySelectorAll('.js-sparkline'));
        const draw = (el, series) => {
          const w = el.viewBox.baseVal.width || 160;
          const h = el.viewBox.baseVal.height || 28;
          const n = series.length;
          if (!n) return;
          const min = Math.min(0, ...series);
          const max = Math.max(0, ...series);
          const span = (max - min) || 1;
          const step = w / Math.max(1, n - 1);
          const mid = (0 - min) / span * (h - 6) + 3; // baseline
          let d = '';
          series.forEach((v, i) => {
            const x = i * step;
            const y = h - ( (v - min) / span * (h - 6) + 3 );
            d += (i ? ' L ' : 'M ') + x.toFixed(2) + ' ' + y.toFixed(2);
          });
          el.innerHTML = '';
          const axis = document.createElementNS('http://www.w3.org/2000/svg', 'line');
          axis.setAttribute('x1', '0'); axis.setAttribute('x2', String(w));
          const ay = h - mid; axis.setAttribute('y1', String(ay)); axis.setAttribute('y2', String(ay));
          axis.setAttribute('stroke', '#94a3b8'); axis.setAttribute('stroke-width', '1'); axis.setAttribute('opacity', '0.5');
          el.appendChild(axis);
          const path = document.createElementNS('http://www.w3.org/2000/svg', 'path');
          path.setAttribute('d', d);
          path.setAttribute('fill', 'none');
          path.setAttribute('stroke', '#0ea5e9');
          path.setAttribute('stroke-width', '2');
          el.appendChild(path);
        };
        sparkEls.forEach(el => {
          const id = el.getAttribute('data-dish-id');
          const url = new URL("<?php echo e(route('admin.inventory.availability.sparkline')); ?>", window.location.origin);
          url.searchParams.set('dish_id', id);
          url.searchParams.set('n', '20');
          fetch(url.toString(), { headers: { 'Accept': 'application/json' } })
            .then(r => r.ok ? r.json() : Promise.reject())
            .then(data => draw(el, data.series || []))
            .catch(() => {});
        });
      } catch (e) {}
    })();
  </script>
  <?php $__env->stopPush(); ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $attributes = $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $component = $__componentOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php /**PATH C:\xampp\htdocs\bonny_delight\resources\views/admin/inventory/availability.blade.php ENDPATH**/ ?>