import defaultTheme from 'tailwindcss/defaultTheme';
import forms from '@tailwindcss/forms';

/** @type {import('tailwindcss').Config} */
export default {
    darkMode: 'class',
    content: [
        './vendor/laravel/framework/src/Illuminate/Pagination/resources/views/*.blade.php',
        './storage/framework/views/*.php',
        './resources/views/**/*.blade.php',
    ],

    theme: {
        extend: {
            fontFamily: {
                sans: ['Inter', ...defaultTheme.fontFamily.sans],
                display: ['Playfair Display', 'serif'],
            },
            colors: {
                brand: {
                    primary: '#0077c8', // bonny blue
                    coral: '#ff7f50',
                    charcoal: '#36454f',
                    pearl: '#fdf4e3',
                    gold: '#ffd700',
                },
            },
            keyframes: {
                bounce: {
                    '0%, 100%': { transform: 'translateY(-15%)', animationTimingFunction: 'cubic-bezier(0.8,0,1,1)' },
                    '50%': { transform: 'translateY(0)', animationTimingFunction: 'cubic-bezier(0,0,0.2,1)' },
                },
            },
            animation: {
                bounce: 'bounce 1.5s infinite',
            },
        },
    },

    plugins: [forms],
};
