<?php
// Simple test script to verify analytics endpoints
require_once 'config.php';

echo "Testing Analytics Endpoints\n";
echo "==========================\n\n";

// Test database connection
try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    echo "✅ Database connection successful\n";
} catch (PDOException $e) {
    echo "❌ Database connection failed: " . $e->getMessage() . "\n";
    exit(1);
}

// Test basic analytics queries
echo "\nTesting Basic Analytics Queries:\n";
echo "--------------------------------\n";

// Test today's revenue
try {
    $stmt = $pdo->prepare("
        SELECT 
            COALESCE(SUM(total), 0) as revenue_today,
            COUNT(*) as orders_today
        FROM orders 
        WHERE DATE(created_at) = CURDATE()
        AND status IN ('completed', 'delivered')
    ");
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    
    echo "✅ Today's Revenue: ₦" . number_format($result['revenue_today'], 2) . "\n";
    echo "✅ Today's Orders: " . $result['orders_today'] . "\n";
} catch (PDOException $e) {
    echo "❌ Revenue query failed: " . $e->getMessage() . "\n";
}

// Test customer count
try {
    $stmt = $pdo->prepare("SELECT COUNT(*) as total_customers FROM users WHERE role = 'Customer'");
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    
    echo "✅ Total Customers: " . $result['total_customers'] . "\n";
} catch (PDOException $e) {
    echo "❌ Customer query failed: " . $e->getMessage() . "\n";
}

// Test dish count
try {
    $stmt = $pdo->prepare("SELECT COUNT(*) as total_dishes FROM dishes WHERE is_active = 1");
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    
    echo "✅ Active Dishes: " . $result['total_dishes'] . "\n";
} catch (PDOException $e) {
    echo "❌ Dish query failed: " . $e->getMessage() . "\n";
}

// Test categories
try {
    $stmt = $pdo->prepare("SELECT COUNT(*) as total_categories FROM categories");
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    
    echo "✅ Categories: " . $result['total_categories'] . "\n";
} catch (PDOException $e) {
    echo "❌ Category query failed: " . $e->getMessage() . "\n";
}

echo "\nAnalytics Database Test Complete!\n";
echo "================================\n";
echo "All core analytics queries are working properly.\n";
echo "Nigerian Naira (₦) formatting is functional.\n";
echo "Ready for comprehensive analytics dashboard!\n";
?>