<?php

namespace Tests\Feature;

use App\Models\User;
use App\Models\Stay;
use App\Services\Delivery\{DeliveryContext, DeliveryVerificationService};
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class DeliveryVerificationTest extends TestCase
{
    use RefreshDatabase;

    protected function setUp(): void
    {
        parent::setUp();
        // Migrate base schemas
        $this->artisan('migrate')->run();
    }

    public function test_room_delivery_is_accepted()
    {
        $user = User::factory()->create();
        $stay = Stay::create([
            'user_id' => $user->id,
            'room_number' => '101',
            'check_in_at' => now()->subHour(),
            'check_out_at' => now()->addDay(),
        ]);
        $ctx = new DeliveryContext(
            user: $user,
            activeStay: $stay,
            deliveryMode: 'room',
            rawAddress: null,
            radiusKm: 5,
            hotelLat: 6.43,
            hotelLng: 3.42,
            requireVerification: false,
        );
        $service = app(DeliveryVerificationService::class);
        $decision = $service->decide($ctx);
        $this->assertEquals('ACCEPT', $decision->status);
        $this->assertEquals('room_delivery', $decision->reason);
    }

    public function test_external_delivery_placeholder_accepts()
    {
        $user = User::factory()->create();
        $ctx = new DeliveryContext(
            user: $user,
            activeStay: null,
            deliveryMode: 'external',
            rawAddress: 'Some address text',
            radiusKm: 5,
            hotelLat: 6.43,
            hotelLng: 3.42,
            requireVerification: false,
        );
        $service = app(DeliveryVerificationService::class);
        $decision = $service->decide($ctx);
        $this->assertEquals('ACCEPT', $decision->status);
        $this->assertStringStartsWith('external_placeholder', $decision->reason);
    }
}
